/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class CookiePolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CookiePolicy.class);
    private final CookieHandler cookies = new CookieManager();

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return Mono.defer(() -> {
            CookiePolicy.beforeRequest(httpPipelineCallContext.getHttpRequest(), this.cookies);
            return httpPipelineNextPolicy.process();
        }).map(httpResponse -> CookiePolicy.afterResponse(httpPipelineCallContext, httpResponse, this.cookies));
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        CookiePolicy.beforeRequest(httpPipelineCallContext.getHttpRequest(), this.cookies);
        return CookiePolicy.afterResponse(httpPipelineCallContext, httpPipelineNextSyncPolicy.processSync(), this.cookies);
    }

    private static void beforeRequest(HttpRequest httpRequest, CookieHandler cookieHandler) {
        try {
            URI uRI = httpRequest.getUrl().toURI();
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (Object object : httpRequest.getHeaders()) {
                hashMap.put(((Header)object).getName(), ((Header)object).getValuesList());
            }
            Map<String, List<String>> map = cookieHandler.get(uRI, hashMap);
            for (Map.Entry entry : map.entrySet()) {
                httpRequest.getHeaders().set((String)entry.getKey(), (List<String>)((List)entry.getValue()));
            }
        }
        catch (IOException | URISyntaxException exception) {
            throw LOGGER.logExceptionAsError(new RuntimeException(exception));
        }
    }

    private static HttpResponse afterResponse(HttpPipelineCallContext httpPipelineCallContext, HttpResponse httpResponse, CookieHandler cookieHandler) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (HttpHeader httpHeader : httpResponse.getHeaders()) {
            hashMap.put(httpHeader.getName(), httpHeader.getValuesList());
        }
        try {
            URI uRI = httpPipelineCallContext.getHttpRequest().getUrl().toURI();
            cookieHandler.put(uRI, hashMap);
        }
        catch (IOException | URISyntaxException exception) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)exception));
        }
        return httpResponse;
    }
}

