/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class OkHttpProxySelector
extends ProxySelector {
    private final Proxy.Type proxyType;
    private final Supplier<InetSocketAddress> proxyAddressSupplier;
    private final Pattern nonProxyHostsPattern;

    public OkHttpProxySelector(Proxy.Type type, Supplier<InetSocketAddress> supplier, String string) {
        this.proxyType = type;
        this.proxyAddressSupplier = supplier;
        this.nonProxyHostsPattern = string == null ? null : Pattern.compile(string, 2);
    }

    @Override
    public List<Proxy> select(URI uRI) {
        return this.nonProxyHostsPattern == null || !this.nonProxyHostsPattern.matcher(uRI.getHost()).matches() ? Collections.singletonList(new Proxy(this.proxyType, OkHttpProxySelector.getProxyAddress(this.proxyAddressSupplier))) : null;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
    }

    private static InetSocketAddress getProxyAddress(Supplier<InetSocketAddress> supplier) {
        InetSocketAddress inetSocketAddress = supplier.get();
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }
}

