/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationPropertyBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class ProxyOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ProxyOptions.class);
    private static final String INVALID_AZURE_PROXY_URL = "URL is invalid and is being ignored.";
    private static final String JAVA_SYSTEM_PROXY_PREREQUISITE = "java.net.useSystemProxies";
    private static final String JAVA_PROXY_HOST = "proxyHost";
    private static final String JAVA_PROXY_PORT = "proxyPort";
    private static final String JAVA_PROXY_USER = "proxyUser";
    private static final String JAVA_PROXY_PASSWORD = "proxyPassword";
    private static final String JAVA_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP = "http";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final Pattern HTTP_NON_PROXY_HOSTS_SPLIT = Pattern.compile("(?<!\\\\)\\|");
    private static final Pattern NO_PROXY_SPLIT = Pattern.compile("(?<!\\\\),");
    private static final Pattern UNESCAPED_PERIOD = Pattern.compile("(?<!\\\\)\\.");
    private static final Pattern ANY = Pattern.compile("\\*");
    private static final ConfigurationProperty<String> NON_PROXY_PROPERTY = ConfigurationPropertyBuilder.ofString("http.proxy.non-proxy-hosts").shared(true).logValue(true).build();
    private static final ConfigurationProperty<String> HOST_PROPERTY = ConfigurationPropertyBuilder.ofString("http.proxy.hostname").shared(true).logValue(true).build();
    private static final ConfigurationProperty<Integer> PORT_PROPERTY = ConfigurationPropertyBuilder.ofInteger("http.proxy.port").shared(true).defaultValue(443).build();
    private static final ConfigurationProperty<String> USER_PROPERTY = ConfigurationPropertyBuilder.ofString("http.proxy.username").shared(true).logValue(true).build();
    private static final ConfigurationProperty<String> PASSWORD_PROPERTY = ConfigurationPropertyBuilder.ofString("http.proxy.password").shared(true).build();
    private final InetSocketAddress address;
    private final Type type;
    private String username;
    private String password;
    private String nonProxyHosts;

    public ProxyOptions(Type type, InetSocketAddress inetSocketAddress) {
        this.type = type;
        this.address = inetSocketAddress;
    }

    public ProxyOptions setCredentials(String string, String string2) {
        this.username = Objects.requireNonNull(string, "'username' cannot be null.");
        this.password = Objects.requireNonNull(string2, "'password' cannot be null.");
        return this;
    }

    public ProxyOptions setNonProxyHosts(String string) {
        this.nonProxyHosts = ProxyOptions.sanitizeJavaHttpNonProxyHosts(string);
        return this;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public static ProxyOptions fromConfiguration(Configuration configuration) {
        return ProxyOptions.fromConfiguration(configuration, false);
    }

    public static ProxyOptions fromConfiguration(Configuration configuration, boolean bl2) {
        Configuration configuration2 = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
        return ProxyOptions.attemptToLoadProxy(configuration2, bl2);
    }

    private static ProxyOptions attemptToLoadProxy(Configuration configuration, boolean bl2) {
        if (configuration == Configuration.NONE) {
            return null;
        }
        ProxyOptions proxyOptions = null;
        if (Boolean.parseBoolean(configuration.get(JAVA_SYSTEM_PROXY_PREREQUISITE))) {
            proxyOptions = ProxyOptions.attemptToLoadSystemProxy(configuration, bl2, "HTTPS_PROXY");
            if (proxyOptions != null) {
                LOGGER.verbose("Using proxy created from HTTPS_PROXY environment variable.");
                return proxyOptions;
            }
            proxyOptions = ProxyOptions.attemptToLoadSystemProxy(configuration, bl2, "HTTP_PROXY");
            if (proxyOptions != null) {
                LOGGER.verbose("Using proxy created from HTTP_PROXY environment variable.");
                return proxyOptions;
            }
        }
        if ((proxyOptions = ProxyOptions.attemptToLoadAzureSdkProxy(configuration, bl2)) != null) {
            return proxyOptions;
        }
        proxyOptions = ProxyOptions.attemptToLoadJavaProxy(configuration, bl2, HTTPS);
        if (proxyOptions != null) {
            LOGGER.verbose("Using proxy created from JVM HTTPS system properties.");
            return proxyOptions;
        }
        proxyOptions = ProxyOptions.attemptToLoadJavaProxy(configuration, bl2, HTTP);
        if (proxyOptions != null) {
            LOGGER.verbose("Using proxy created from JVM HTTP system properties.");
            return proxyOptions;
        }
        return null;
    }

    private static ProxyOptions attemptToLoadSystemProxy(Configuration configuration, boolean bl2, String string) {
        String string2 = configuration.get(string);
        if (CoreUtils.isNullOrEmpty(string2)) {
            return null;
        }
        try {
            String[] stringArray;
            String string3;
            URL uRL = ImplUtils.createUrl(string2);
            int n2 = uRL.getPort() == -1 ? uRL.getDefaultPort() : uRL.getPort();
            InetSocketAddress inetSocketAddress = bl2 ? InetSocketAddress.createUnresolved(uRL.getHost(), n2) : new InetSocketAddress(uRL.getHost(), n2);
            ProxyOptions proxyOptions = new ProxyOptions(Type.HTTP, inetSocketAddress);
            String string4 = configuration.get("NO_PROXY");
            if (!CoreUtils.isNullOrEmpty(string4)) {
                proxyOptions.nonProxyHosts = ProxyOptions.sanitizeNoProxy(string4);
                LOGGER.atVerbose().addKeyValue("regex", proxyOptions.nonProxyHosts).log("Using non-proxy hosts");
            }
            if ((string3 = uRL.getUserInfo()) != null && (stringArray = string3.split(":", 2)).length == 2) {
                try {
                    proxyOptions.setCredentials(URLDecoder.decode(stringArray[0], StandardCharsets.UTF_8.toString()), URLDecoder.decode(stringArray[1], StandardCharsets.UTF_8.toString()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return proxyOptions;
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.atWarning().addKeyValue("url", string).log(INVALID_AZURE_PROXY_URL);
            return null;
        }
    }

    static String sanitizeNoProxy(String string) {
        return ProxyOptions.sanitizeNonProxyHosts(NO_PROXY_SPLIT.split(string));
    }

    private static ProxyOptions attemptToLoadJavaProxy(Configuration configuration, boolean bl2, String string) {
        int n2;
        String string2 = configuration.get(string + "." + JAVA_PROXY_HOST);
        if (CoreUtils.isNullOrEmpty(string2)) {
            return null;
        }
        try {
            n2 = Integer.parseInt(configuration.get(string + "." + JAVA_PROXY_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = HTTPS.equals(string) ? 443 : 80;
        }
        String string3 = configuration.get(JAVA_NON_PROXY_HOSTS);
        String string4 = configuration.get(string + "." + JAVA_PROXY_USER);
        String string5 = configuration.get(string + "." + JAVA_PROXY_PASSWORD);
        return ProxyOptions.createOptions(string2, n2, string3, string4, string5, bl2);
    }

    private static ProxyOptions attemptToLoadAzureSdkProxy(Configuration configuration, boolean bl2) {
        String string = configuration.get(HOST_PROPERTY);
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        int n2 = configuration.get(PORT_PROPERTY);
        String string2 = configuration.get(NON_PROXY_PROPERTY);
        String string3 = configuration.get(USER_PROPERTY);
        String string4 = configuration.get(PASSWORD_PROPERTY);
        return ProxyOptions.createOptions(string, n2, string2, string3, string4, bl2);
    }

    private static ProxyOptions createOptions(String string, int n2, String string2, String string3, String string4, boolean bl2) {
        InetSocketAddress inetSocketAddress = bl2 ? InetSocketAddress.createUnresolved(string, n2) : new InetSocketAddress(string, n2);
        ProxyOptions proxyOptions = new ProxyOptions(Type.HTTP, inetSocketAddress);
        if (!CoreUtils.isNullOrEmpty(string2)) {
            proxyOptions.nonProxyHosts = ProxyOptions.sanitizeJavaHttpNonProxyHosts(string2);
            LOGGER.atVerbose().addKeyValue("regex", proxyOptions.nonProxyHosts).log("Using non-proxy host regex");
        }
        if (string3 != null && string4 != null) {
            proxyOptions.setCredentials(string3, string4);
        }
        return proxyOptions;
    }

    static String sanitizeJavaHttpNonProxyHosts(String string) {
        return ProxyOptions.sanitizeNonProxyHosts(HTTP_NON_PROXY_HOSTS_SPLIT.split(string));
    }

    private static String sanitizeNonProxyHosts(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append("|");
            }
            String string = "";
            String string2 = "";
            String string3 = stringArray[i2];
            if (string3.startsWith(".")) {
                string = ".*?";
                string3 = string3.substring(1);
            } else if (string3.startsWith(".?")) {
                string = ".*?";
                string3 = string3.substring(2);
            } else if (string3.startsWith("*?")) {
                string = ".*?";
                string3 = string3.substring(2);
            } else if (string3.startsWith("*")) {
                string = ".*?";
                string3 = string3.substring(1);
            } else if (string3.startsWith(".*?")) {
                string = ".*?";
                string3 = string3.substring(3);
            } else if (string3.startsWith(".*")) {
                string = ".*?";
                string3 = string3.substring(2);
            }
            if (string3.endsWith(".")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith(".?")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 3);
            } else if (string3.endsWith("*?")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 3);
            } else if (string3.endsWith("*")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith(".*?")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 4);
            } else if (string3.endsWith(".*")) {
                string2 = ".*?";
                string3 = string3.substring(0, string3.length() - 3);
            }
            try {
                String string4 = string3;
                string4 = UNESCAPED_PERIOD.matcher(string4).replaceAll("\\\\.");
                string4 = ANY.matcher(string4).replaceAll("\\.*?");
                string3 = Pattern.compile(string4).pattern();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                string3 = Pattern.quote(string3);
            }
            stringBuilder.append("(").append(string).append(string3).append(string2).append(")");
        }
        return stringBuilder.toString();
    }

    public static enum Type {
        HTTP(Proxy.Type.HTTP),
        SOCKS4(Proxy.Type.SOCKS),
        SOCKS5(Proxy.Type.SOCKS);

        private final Proxy.Type proxyType;

        private Type(Proxy.Type type) {
            this.proxyType = type;
        }

        public Proxy.Type toProxyType() {
            return this.proxyType;
        }
    }

    private static class ConfigurationProperties {
        public static final String HTTP_PROXY_NON_PROXY_HOSTS = "http.proxy.non-proxy-hosts";
        public static final String HTTP_PROXY_HOST = "http.proxy.hostname";
        public static final String HTTP_PROXY_PORT = "http.proxy.port";
        public static final String HTTP_PROXY_USER = "http.proxy.username";
        public static final String HTTP_PROXY_PASSWORD = "http.proxy.password";

        private ConfigurationProperties() {
        }
    }
}

