/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.HttpPipelineCallState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.scheduler.Schedulers;

public class HttpPipelineNextPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineNextPolicy.class);
    private final HttpPipelineCallState state;
    private final boolean originatedFromSyncPolicy;

    HttpPipelineNextPolicy(HttpPipelineCallState httpPipelineCallState) {
        this.state = httpPipelineCallState;
        this.originatedFromSyncPolicy = false;
    }

    HttpPipelineNextPolicy(HttpPipelineCallState httpPipelineCallState, boolean bl2) {
        this.state = httpPipelineCallState;
        this.originatedFromSyncPolicy = bl2;
    }

    public Mono<HttpResponse> process() {
        HttpPipelinePolicy httpPipelinePolicy;
        if (this.originatedFromSyncPolicy && !Schedulers.isInNonBlockingThread()) {
            return Mono.fromCallable(() -> new HttpPipelineNextSyncPolicy(this.state).processSync());
        }
        if (this.originatedFromSyncPolicy) {
            LOGGER.log(LogLevel.WARNING, () -> "The pipeline switched from synchronous to asynchronous. Check if " + this.state.getCurrentPolicy().getClass().getSimpleName() + " does not override HttpPipelinePolicy.processSync");
        }
        if ((httpPipelinePolicy = this.state.getNextPolicy()) == null) {
            return this.state.getPipeline().getHttpClient().send(this.state.getCallContext().getHttpRequest(), this.state.getCallContext().getContext());
        }
        return httpPipelinePolicy.process(this.state.getCallContext(), this);
    }

    public HttpPipelineNextPolicy clone() {
        return new HttpPipelineNextPolicy(this.state.clone(), this.originatedFromSyncPolicy);
    }
}

