/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.DeliveryType;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataDeadLetterPolicyRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataDeliveryConfigRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataExpirationPolicyRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataRetryPolicyRequestConsumer;
import coldfusion.cloud.gcp.pubsub.exception.MinMaxRangeException;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataDeadLetterPolicyRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataDeliveryConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataExpirationPolicyRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataRetryPolicyRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.gcp.validator.GCPLabelValidator;
import coldfusion.cloud.gcp.validator.GCPResourceNameValidator;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFNonNegativeIntegerValidator;
import coldfusion.cloud.validator.CFStructValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.util.RB;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.Arrays;
import java.util.Collections;

public enum SubscriptionMetadataRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SubscriptionMetadataRequest> consumerMap = new ConsumerMap();

    private SubscriptionMetadataRequestConsumer() {
        this.consumerMap.put((Object)"topicName", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setTopicId(this.cast.getStringProperty(value)), Collections.singletonList(GCPResourceNameValidator.TOPIC)));
        this.consumerMap.put((Object)"subscriptionName", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setSubscriptionId(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, GCPResourceNameValidator.SUBSCRIPTION)));
        this.consumerMap.put((Object)"deliveryConfig", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataDeliveryConfigRequest deliveryConfig = new SubscriptionMetadataDeliveryConfigRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)deliveryConfig, this.cast.getMapProperty(value, "deliveryConfig"), SubscriptionMetadataDeliveryConfigRequestConsumer.INSTANCE.getConsumerMap());
            DeliveryType deliveryType = deliveryConfig.getType();
            if (deliveryConfig.getPushConfig() != null && (deliveryType == DeliveryType.PULL || deliveryType == DeliveryType.BIGQUERY)) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_PUSH_DELIVERY_TYPE_VALIDATION", (Object)((Object)deliveryType)));
            }
            if (deliveryConfig.getBigQueryConfig() != null && (deliveryType == DeliveryType.PULL || deliveryType == DeliveryType.PUSH)) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_BIGQUERY_DELIVERY_TYPE_VALIDATION", (Object)((Object)deliveryType)));
            }
            subscriptionMetadataRequest.setDeliveryConfig(deliveryConfig);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"ackDeadlineSeconds", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setAckDeadlineSeconds(this.cast.getIntegerProperty(value)), Collections.singletonList(new CFNonNegativeIntegerValidator("ackDeadlineSeconds"))));
        this.consumerMap.put((Object)"deadLetterPolicy", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataDeadLetterPolicyRequest deadLetterPolicy = new SubscriptionMetadataDeadLetterPolicyRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)deadLetterPolicy, this.cast.getMapProperty(value, "deadLetterPolicy"), SubscriptionMetadataDeadLetterPolicyRequestConsumer.INSTANCE.getConsumerMap());
            subscriptionMetadataRequest.setDeadLetterPolicy(deadLetterPolicy);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"expirationPolicy", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataExpirationPolicyRequest expirationPolicy = new SubscriptionMetadataExpirationPolicyRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)expirationPolicy, this.cast.getMapProperty(value, "expirationPolicy"), SubscriptionMetadataExpirationPolicyRequestConsumer.INSTANCE.getConsumerMap());
            subscriptionMetadataRequest.setExpirationPolicy(expirationPolicy);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"retryPolicy", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            SubscriptionMetadataRetryPolicyRequest retryPolicy = new SubscriptionMetadataRetryPolicyRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)retryPolicy, this.cast.getMapProperty(value, "retryPolicy"), SubscriptionMetadataRetryPolicyRequestConsumer.INSTANCE.getConsumerMap());
            Duration minimumBackoff = retryPolicy.getMinimumBackoff();
            Duration maximumBackoff = retryPolicy.getMaximumBackoff();
            if (minimumBackoff != null && maximumBackoff != null && maximumBackoff.getSeconds() < minimumBackoff.getSeconds()) {
                throw new MinMaxRangeException(RB.getString(PubSubClientImpl.class, (String)"MIN_MAX_VALIDATION_ERROR", (Object)"maximumBackoff", (Object)"minimumBackoff"));
            }
            subscriptionMetadataRequest.setRetryPolicy(retryPolicy);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableExactlyOnceDelivery", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setEnableExactlyOnceDelivery(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableMessageOrdering", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setEnableMessageOrdering(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"retainAckedMessages", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setRetainAckedMessages(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"filter", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            String filter = this.cast.getStringProperty(value);
            if (!PubSubServiceUtils.isNullOrEmpty(filter)) {
                filter = filter.replaceAll("'", "\"");
            }
            subscriptionMetadataRequest.setFilter(filter);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"messageRetentionDuration", new ConsumerValidator((subscriptionMetadataRequest, value) -> {
            long seconds = this.cast.getDurationProperty(value, "messageRetentionDuration").getSeconds();
            PubSubServiceUtils.validateDurationRange(seconds, 600L, 604800L, "messageRetentionDuration", (String)value, "10M", "168h");
            subscriptionMetadataRequest.setMessageRetentionDuration(Durations.fromSeconds((long)seconds));
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"labels", new ConsumerValidator((subscriptionMetadataRequest, value) -> subscriptionMetadataRequest.setLabels(this.cast.getGCPLabelsMapProperty(value, "labels")), Collections.singletonList(GCPLabelValidator.INSTANCE)));
    }

    public ConsumerMap<SubscriptionMetadataRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

