/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.consumer.IAMPolicyOptionsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicyGetOptionsRequest;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicyGetRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum IAMPolicyGetRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<IAMPolicyGetRequest> consumerMap = new ConsumerMap();
    private final List<Validator> validators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(ResourceType.class, "resourceType"));

    private IAMPolicyGetRequestConsumer() {
        this.consumerMap.put((Object)"resourceName", new ConsumerValidator((iamPolicyRequest, value) -> iamPolicyRequest.setResourceName(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"resourceType", new ConsumerValidator((iamPolicyRequest, value) -> {
            String resourceType = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
            iamPolicyRequest.setResourceType(ResourceType.valueOf(resourceType));
        }, this.validators));
        this.consumerMap.put((Object)"policyOptions", new ConsumerValidator((getIamPolicyRequest, value) -> {
            IAMPolicyGetOptionsRequest getPolicyOptions = new IAMPolicyGetOptionsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)getPolicyOptions, this.cast.getMapProperty(value, "policyOptions"), IAMPolicyOptionsRequestConsumer.INSTANCE.getConsumerMap());
            getIamPolicyRequest.setPolicyOptions(getPolicyOptions);
        }, Collections.emptyList()));
    }

    public ConsumerMap<IAMPolicyGetRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

