/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public class TLVByte
extends TLV {
    private byte value = 0;

    public TLVByte() {
        super(1, 1);
    }

    public TLVByte(short p_tag) {
        super(p_tag, 1, 1);
    }

    public TLVByte(short p_tag, byte p_value) {
        super(p_tag, 1, 1);
        this.value = p_value;
        this.markValueSet();
    }

    protected void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        try {
            this.value = buffer.removeByte();
        }
        catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
            // empty catch block
        }
        this.markValueSet();
    }

    protected ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendByte(this.getValue());
        return valueBuf;
    }

    public void setValue(byte p_value) {
        this.value = p_value;
        this.markValueSet();
    }

    public byte getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(byte: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.value;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

