/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.PDUException;
import org.smpp.pdu.Response;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLVByte;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public abstract class BindResponse
extends Response {
    private String systemId = "";
    private TLVByte scInterfaceVersion = new TLVByte(528);

    public BindResponse(int commandId) {
        super(commandId);
        this.registerOptional(this.scInterfaceVersion);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        if (this.getCommandStatus() == 0) {
            this.setSystemId(buffer.removeCString());
        }
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        if (this.getCommandStatus() == 0) {
            buffer.appendCString(this.getSystemId());
        }
        return buffer;
    }

    public void setSystemId(String sysId) throws WrongLengthOfStringException {
        BindResponse.checkString(sysId, 16);
        this.systemId = sysId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean hasScInterfaceVersion() {
        return this.scInterfaceVersion.hasValue();
    }

    public void setScInterfaceVersion(byte value) {
        this.scInterfaceVersion.setValue(value);
    }

    public byte getScInterfaceVersion() throws ValueNotSetException {
        return this.scInterfaceVersion.getValue();
    }

    public String debugString() {
        String dbgs = "(bindresp: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSystemId();
        if (this.hasScInterfaceVersion()) {
            dbgs = dbgs + " ";
            try {
                dbgs = dbgs + this.getScInterfaceVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

