/*
 * Copyright (c) 1997-2021 IDRsolutions (https://www.idrsolutions.com)
 */
app = new App();

function App() {
    this.isFDF = true;

    this.activeDocs = [];
    this.calculate = false;
    this.contstants = null;
    this.focusRect = false;
    this.formsVersion = 6.0;
    this.fromPDFConverters = new Array();
    this.fs = new FullScreen();
    this.fullScreen = false;
    this.language = "ENU";
    this.media = new Media();
    this.monitors = {};
    this.numPlugins = 0;
    this.openInPlace = false;
    this.platform = "WIN";
    this.plugins = new Array();
    this.printColorProfiles = new Array();
    this.printNames = new Array();
    this.runtimeHighlight = false;
    this.runtimeHightlightColor = new Array();
    this.thermometer = null;
    this.toolBar = false;
    this.toolBarHorizontal = false;
    this.toolBarVertical = false;
    this.viewerType = "Exchange-Pro";
    this.viewerVariation = "Full";
    this.viewerVersion = 6.0;
}

function event() {
    this.change = null;
    this.changeEx = null;
    this.commitKey = null;
    this.fieldFull = null;
    this.keyDown = null;
    this.modifier = null;
    this.name = null;
    this.rc = null;
    this.richChange = null;
    this.richChangeEx = null;
    this.richValue = null;
    this.selEnd = null;
    this.selStart = null;
    this.shift = null;
    this.source = null;
    this.target = null;
    this.targetName = null;
    this.type = null;
    this.value = null;
    this.willCommit = null;
}

function Events() {

}

Object.defineProperty(Events.prototype, "add", {
    value: function () {
        console.log("add not defined");
    }
});

Object.defineProperty(Events.prototype, "dispatch", {
    value: function (oMediaEvent) {
        console.log("dispatch not defined");
    }
});

Object.defineProperty(Events.prototype, "remove", {
    value: function () {
        console.log("remove not defined");
    }
});

function Field(ele) {
    this.input = ele;
    this.buttonAlignX = 0;
    this.buttonAlignY = 0;
    this.buttonFitBounds = false;
    this.buttonPosition = 0;
    this.buttonScaleHoq = 0;
    this.buttonScaleWhen = 0;
    this.calcOrderIndex = 0;
    this.comb = false;
    this.commitOnSelChange = false;
    this.currentValueIndices = [];
    this.defaultStyle = {};
    this.defaultValue = "";
    this.doNotScroll = false;
    this.doNotSpellCheck = false;
    this.delay = false;
    this.display = 0;
    this.doc = {};
    this.exportValues = [];
    this.fileSelect = false;
    this.fillColor = [];
    this.highlight = "none";
    this.multiline = false;
    this.multipleSelection = false;
    this.page = 0;
    this.password = false;
    this.print = true;
    this.radiosInUnison = false;
    this.rect = [];
    this.richText = false;
    this.richValue = [];
    this.rotation = 0;
    this.strokeColor = [];
    this.style = "";
    this.submitName = "";
    this.textColor = [];
    this.textFont = null;
    this.userName = "";
}

Object.defineProperty(Field.prototype, "alignment", {
    get: function () {
        return this.input.style.textAlign;
    }, set: function (v) {
        this.input.style.textAlign = v;
    }
});

var border = {};
border.s = "solid";
border.d = "dashed";
border.b = "beveled";
border.i = "inset";
border.u = "underline";

Object.defineProperty(Field.prototype, "borderStyle", {
    get: function () {
        switch (this.input.style.borderStyle) {
            case "solid":
                return border.s;
            case "dashed":
                return border.d;
            case "beveled":
                return border.b;
            case "inset":
                return border.i;
            case "underline":
                return border.u;
        }
        return "none";
    }, set: function (v) {
        this.input.style.borderStyle = v;
    }
});

Object.defineProperty(Field.prototype, "charLimit", {
    get: function () {
        return this.input.maxLength;
    }, set: function (v) {
        this.input.maxLength = v;
    }
});

Object.defineProperty(Field.prototype, "editable", {
    get: function () {
        return this.input.disabled;
    }, set: function (v) {
        this.input.style.disabled = v;
    }
});

Object.defineProperty(Field.prototype, "hidden", {
    get: function () {
        return this.input.hidden;
    }, set: function (v) {
        this.input.hidden = v;
    }
});

Object.defineProperty(Field.prototype, "lineWidth", {
    get: function () {
        return parseInt(this.style.borderWidth);
    }, set: function (v) {
        this.input.style.borderWidth = v + "px";
    }
});

Object.defineProperty(Field.prototype, "name", {
    get: function () {
        return this.input.getAttribute("data-name");
    }, set: function (v) {
        this.input.setAttribute("data-name", v);
    }
});

Object.defineProperty(Field.prototype, "numItems", {
    get: function () {
        return this.input.options.length;
    }
});

Object.defineProperty(Field.prototype, "readOnly", {
    get: function () {
        return this.input.readOnly;
    }, set: function (v) {
        this.input.readOnly = v;
    }
});

Object.defineProperty(Field.prototype, "required", {
    get: function () {
        return this.input.required;
    }, set: function (v) {
        this.input.required = v;
    }
});

Object.defineProperty(Field.prototype, "textSize", {
    get: function () {
        return parseInt(this.input.style.fontSize);
    }, set: function (v) {
        this.input.style.fontSize = parseInt(v) + "px";
    }
});

Object.defineProperty(Field.prototype, "type", {
    get: function () {
        var tagName = this.input.tagName;
        if (tagName === "INPUT") {
            return this.getAttribute("type");
        } else if (tagName === "SELECT") {
            return "listbox";
        } else if (tagName === "BUTTON") {
            return "button";
        }
        return "text";
        // do later signature and combobox
    }
});

Object.defineProperty(Field.prototype, "value", {
    get: function () {
        return this.input.value;
    }, set: function (v) {
        this.input.value = v;
    }
});

Object.defineProperty(Field.prototype, "valueAsString", {
    get: function () {
        return "" + this.input.value;
    }, set: function (v) {
        this.input.value = "" + v;
    }
});

Object.defineProperty(Field.prototype, "browseForFileToSubmit", {
    value: function () {
        console.log("browseForFileToSubmit is not defined");
    }
});

Object.defineProperty(Field.prototype, "buttonGetCaption", {
    value: function () {
        return this.input.innerHTML;
    }
});

Object.defineProperty(Field.prototype, "buttonGetIcon", {
    value: function () {
        console.log("buttonGetIcon is not defined");
    }
});

Object.defineProperty(Field.prototype, "buttonImportIcon", {
    value: function () {
        console.log("buttonImportIcon is not defined");
    }
});

Object.defineProperty(Field.prototype, "buttonSetCaption", {
    value: function (val) {
        this.input.innerHTML = val;
    }
});

Object.defineProperty(Field.prototype, "buttonSetIcon", {
    value: function () {
        console.log("buttonSetIcon is not defined");
    }
});

Object.defineProperty(Field.prototype, "checkThisBox", {
    value: function (nWidget, bCheckIt) {
        this.input.checked = true; // do later
    }
});

Object.defineProperty(Field.prototype, "clearItems", {
    value: function () {
        var i, ii = this.input.options.length - 1;
        for (i = ii; i >= 0; i--) {
            this.input.remove(i);
        }
    }
});

Object.defineProperty(Field.prototype, "defaultsChecked", {
    value: function () {
        return this.input.checked;
    }
});

Object.defineProperty(Field.prototype, "deleteItemAt", {
    value: function (nIdx) {
        if (nIdx === -1) {
            var i = this.input.options.length - 1;
            this.input.remove(i);
        } else {
            this.input.remove(nIdx);
        }
    }
});

Object.defineProperty(Field.prototype, "getArray", {
    value: function () {
        console.log("getArray is not defined");
    }
});

Object.defineProperty(Field.prototype, "getItemAt", {
    value: function (nIdx, bExportValue) {
        return this.input.options[nIdx];
    }
});

Object.defineProperty(Field.prototype, "getLock", {
    value: function () {
        console.log("getLock is not defined");
    }
});

Object.defineProperty(Field.prototype, "insertItemAt", {
    value: function (cName, cExport, nIdx) {
        var option = document.createElement("option");
        option.text = cName;
        this.input.add(option, nIdx);
    }
});

Object.defineProperty(Field.prototype, "isBoxChecked", {
    value: function (nWidget) {
        return this.input.checked; // do later
    }
});

Object.defineProperty(Field.prototype, "isDefaultChecked", {
    value: function (nWidget) {
        console.log("isDefaultChecked is not defined");
    }
});

Object.defineProperty(Field.prototype, "setAction", {
    value: function (cTrigger, cScript) {
        console.log("setAction is not defined");
    }
});

Object.defineProperty(Field.prototype, "setFocus", {
    value: function () {
        this.input.focus();
    }
});

Object.defineProperty(Field.prototype, "setItems", {
    value: function (oArray) {
        for (var i = 0; i < oArray.length; i++) {
            var option = document.createElement("option");
            option.text = oArray[i];
            this.input.add(option);
        }
    }
});

Object.defineProperty(Field.prototype, "setLock", {
    value: function (cLock) {
        console.log("setLock is not defined");
    }
});

Object.defineProperty(Field.prototype, "signatureGetModifications", {
    value: function () {
        console.log("signatureGetModifications is not defined");
    }
});

Object.defineProperty(Field.prototype, "signatureGetSeedValue", {
    value: function () {
        console.log("signatureGetSeedValue is not defined");
    }
});

Object.defineProperty(Field.prototype, "signatureInfo", {
    value: function () {
        console.log("signatureInfo is not defined");
    }
});

Object.defineProperty(Field.prototype, "signauteSetSeedValue", {
    value: function () {
        console.log("signauteSetSeedValue is not defined");
    }
});

Object.defineProperty(Field.prototype, "signatureSign", {
    value: function () {
        console.log("signatureSign is not defined");
    }
});

Object.defineProperty(Field.prototype, "signatureValidate", {
    value: function () {
        console.log("signatureValidate is not defined");
    }
});

function FDF() {
    this.deleteOption = 0;
    this.isSigned = false;
    this.numEmbeddedFiles = 0;
}

Object.defineProperty(FDF.prototype, "addContact", {
    value: function (oUserEntity) {
        console.log("addContact not defined");
    }
});

Object.defineProperty(FDF.prototype, "addEmbeddedFile", {
    value: function (cDIPath, nSaveOption) {
        console.log("addEmbeddedFile not defined");
    }
});

Object.defineProperty(FDF.prototype, "addRequest", {
    value: function (cType, cReturnAddress, cName) {
        console.log("addRequest not defined");
    }
});

Object.defineProperty(FDF.prototype, "addRequest", {
    value: function (cType, cReturnAddress, cName) {
        console.log("addRequest not defined");
    }
});

Object.defineProperty(FDF.prototype, "close", {
    value: function () {
        console.log("close not defined");
    }
});

Object.defineProperty(FDF.prototype, "mail", {
    value: function () {
        console.log("mail not defined");
    }
});

Object.defineProperty(FDF.prototype, "save", {
    value: function () {
        console.log("save not defined");
    }
});

Object.defineProperty(FDF.prototype, "signatureClear", {
    value: function () {
        console.log("signatureClear not defined");
        return false;
    }
});

Object.defineProperty(FDF.prototype, "signatureSign", {
    value: function () {
        console.log("signatureSign not defined");
        return false;
    }
});

Object.defineProperty(FDF.prototype, "signatureValidate", {
    value: function (oSig, bUI) {
        console.log("signatureSign not defined");
        return {};
    }
});

function FullScreen() {

}

Object.defineProperty(FullScreen.prototype, "isFullscreen", {
    get: function () {
        return this.isinFullscreen;
    }, set: function (newValue) {
        if (newValue) {
            var requestFullscreen = document.body.requestFullscreen
                    || document.body.msRequestFullscreen
                    || document.body.mozRequestFullScreen
                    || document.body.webkitRequestFullscreen;
            requestFullscreen.call(document.body);
        } else {
            var exitFullscreen = document.exitFullscreen
                    || document.msExitFullscreen
                    || document.mozCancelFullScreen
                    || document.webkitCancelFullScreen;
            exitFullscreen.call(document);
        }
    }, configurable: true, enumerable: true
});

Object.defineProperty(FullScreen.prototype, "isFullscreenEnabled", {
    value: function () {
        return document.fullscreenEnabled || document.msFullscreenEnabled
                || document.mozFullScreenEnabled || document.webkitFullscreenEnabled;
    }
});

Object.defineProperty(FullScreen.prototype, "isinFullscreen", {
    value: function () {
        return !!(document.fullscreenElement || document.msFullscreenElement
                || document.mozFullScreenElement || document.webkitFullscreenElement);
    }
});

Object.defineProperty(FullScreen.prototype, "toggleFullscreen", {
    value: function () {
        if (!this.isinFullscreen()) {
            var requestFullscreen = document.body.requestFullscreen
                    || document.body.msRequestFullscreen
                    || document.body.mozRequestFullScreen
                    || document.body.webkitRequestFullscreen;
            requestFullscreen.call(document.body);
        } else {
            var exitFullscreen = document.exitFullscreen
                    || document.msExitFullscreen
                    || document.mozCancelFullScreen
                    || document.webkitCancelFullScreen;
            exitFullscreen.call(document);
        }
    }
});


var ADBC = {
//sql types
    SQLT_BIGINT: 0, SQLT_BINARY: 1, SQLT_BIT: 2, SQLT_CHAR: 3, SQLT_DATE: 4,
    SQLT_DECIMAL: 5, SQLT_DOUBLE: 6, SQLT_FLOAT: 7, SQLT_INTEGER: 8,
    SQLT_LONGVARBINARY: 9, SQLT_LONGVARCHAR: 10, SQLT_NUMERIC: 11, SQLT_REAL: 12,
    SQLT_SMALLINT: 13, SQLT_TIME: 14, SQLT_TIMESTAMP: 15, SQLT_TINYINT: 16,
    SQLT_VARBINARY: 17, SQLT_VARCHAR: 18, SQLT_NCHAR: 19, SQLT_NVARCHAR: 20,
    SQLT_NTEXT: 21,
//javascript types
    Numeric: 0, String: 1, Binary: 2, Boolean: 3, Time: 4, Date: 5, TimeStamp: 6,
    getDataSourceList: function () {
        console.log("ADBC.getDataSourceList() not defined");
        return new Array();
    },
    newConnnection: function () {
        var obj = {};
        if (arguments[0] instanceof Object) {
            obj = arguments[0];
        } else {
            obj.cDSN = arguments[0];
            switch (arguments.length) {
                case 2:
                    obj.cUID = arguments[1];
                    break;
                case 3:
                    obj.cUID = arguments[1];
                    obj.cPWD = arguments[2];
                    break;
            }
        }
        console.log("ADBC.newConnection not defined");
        return null;
    }
};

function Alerter() {
    this.dispathc = function () {
        console.log("dispatch not defined");
    };
}

function Alert() {
    this.type = "";
    this.doc = null;
    this.fromUser = false;
    this.error = {message: ""};
    this.errorText = "";
    this.fileName = "";
    this.selection = null; //mediaselection object
}

function AlternatePresentation() {
    this.active = false;
    this.type = "";
    this.start = function () {
        console.log("start not defined");
    };
    this.stop = function () {
        console.log("stop not defined");
    };
}

var AnnotationType = {
    Caret: "Caret", Circle: "Circle", FileAttachment: "FileAttachment",
    FreeText: "FreeText", Highlight: "Highlight", Ink: "Ink", Link: "Link", Line: "Line",
    Polygon: "Polygon", PolyLine: "PolyLine", Sound: "Sound", Square: "Square",
    Squiggly: "Squiggly", Stamp: "Stamp", StrikeOut: "StrikeOut", Text: "Text",
    Underline: "Underline"
};

function Annotation() {

    this.type = "Text"; //required
    this.rect = [];//required
    this.page = 0; //required and pages starting from 0 used by IDR

    this.alignment = 0; //left0, center3, right2
    //Approved,AsIs,Confidential,Departmental,Draft,Experimental,Expired,Final,
    //ForComment,ForPublicRelease,NotApproved,NotForPublicRelease,Sold,TopSecret
    this.AP = "Approved";
    //none,OpenArrow,ClosedArrow,ROpenArrow,RCloseArrow,Butt,Diamond,Circle,Square
    //Slash
    this.arrowBegin = "None";
    this.arrowEnd = "None"; //same as arrowbegin
    this.attachIcon = "PushPin"; //PaperClip,PushPin,Graph,Tag
    this.author = "";
    this.borderEffectIntensity = "";
    this.callout = [];
    this.caretSymbol = ""; //"P" or "S";
    this.contents = "";
    this.creationDate = new Date();
    this.dash = [];
    this.delay = false;
    this.doc = null; //doc object;
    this.doCaption = false;
    this.fillColor = [];// Ex : for gray [0.7] for rgb [0.2,0.7,1.0] for cmyk [1,0,0,0.2];
    this.gestures = [];
    this.hidden = false;
    this.inReplyTo = "";
    this.intent = "";
    this.leaderExtend = 0;
    this.leaderLength = 0;
    this.lineEnding = "none"; //same as arrowbegin
    this.lock = false;
    this.modDate = new Date();
    this.name = "";
    //Check,Circle,Comment,Cross,Help,Insert,Key,NewParagraph,Note,RightArrow,
    //RightPointer,Star,UpArrow,UpLeftArrow
    this.noteIcon = "Note";
    this.noView = false;
    this.opacity = 1.0;
    this.open = false;
    this.point = [];
    this.points = [];
    this.popupOpen = true;
    this.popupRect = [];
    this.print = false;
    this.quads = [];
    this.readOnly = false;
    this.refType = "";
    this.richContents = []; //array of span objects page69
    this.richDefaults = null; //span object;
    this.rotate = 0;
    this.seqNum = 0;
    this.soundIcon = "";
    this.state = "";
    this.stateModel = "";
    this.strokeColor = [];
    this.style = "";
    this.subject = "";
    this.textFont = "";
    this.textSize = 10;
    this.toggleNoView = false;
    this.vertices = null; //array of arrays;
    this.width = 1;

    //below are custom addition for link
    this.URI = "";
    this.GoTo = "";
}

Object.defineProperty(Annotation.prototype, "getDictionaryString", {
    value: function () {
        var str = "<</Type /Annot /Subtype /" + this.type + " /Rect [ ";
        for (var i = 0, ii = this.rect.length; i < ii; i++) {
            str += this.rect[i] + " ";
        }
        str += "]";
        if (this.type === AnnotationType.Highlight) {
            str += "/QuadPoints [ ";
            for (var i = 0, ii = this.quads.length; i < ii; i++) {
                str += (this.quads[i] + " ");
            }
            str += "]";
        } else if (this.type === AnnotationType.Text) {
            if (this.contents.length > 0) {
                str += "/Contents (" + this.contents + ")";
            }
            if (this.open) {
                str += "/Open true";
            }
        } else if (this.type === AnnotationType.Link) {
            if (this.URI.length > 0) {
                str += "/A <</Type /Action /S /URI /URI (" + this.URI + ")>>";
            } else if (this.GoTo.length > 0) {
                str += "/Dest [" + this.GoTo + " /Fit]>>";
            }
            if (this.quads.length > 0) {
                str += "/QuadPoints [ ";
                for (var i = 0, ii = this.quads.length; i < ii; i++) {
                    str += (this.quads[i] + " ");
                }
                str += "]";
            }
        } else if (this.type === AnnotationType.Line) { //stroke color is important to view line
            str += ("/L [" + this.points[0] + " " + this.points[1] + " " + this.points[2] + " " + this.points[3] + "]");
        } else if (this.type === AnnotationType.Polygon || this.type === AnnotationType.PolyLine) {
            str += "/Vertices [";
            for (var i = 0, ii = this.vertices.length; i < ii; i++) {
                str += this.vertices[i] + " ";
            }
            str += "]";
        } else if (this.type === AnnotationType.Ink) {
            str += "/InkList [";
            var gs = this.gestures;
            for (var i = 0, ii = gs.length; i < ii; i++) {
                var cp = gs[i];
                str += " [";
                for (var j = 0, jj = cp.length; j < jj; j++) {
                    str += cp[j] + " ";
                }
                str += "] ";
            }
            str += "]";
        } else if (this.type === AnnotationType.FreeText) {
            var contentStr = "";
            for (var i = 0, ii = this.richContents.length; i < ii; i++) {
                var rc = this.richContents[i];
                contentStr += "<span style='font-size:" + rc.textSize + ";color:"
                        + rc.textColor + "'>" + rc.text + "</span>";
            }
            str += "/DA (/Arial " + this.textSize + " Tf)"
                    + "/RC (<body><p>" + contentStr + "</p></body>)";
        }

        if (this.type === AnnotationType.Line
                || this.type === AnnotationType.Highlight
                || this.type === AnnotationType.FreeText
                || this.type === AnnotationType.Link
                || this.type === AnnotationType.Square
                || this.type === AnnotationType.Circle
                || this.type === AnnotationType.Polygon
                || this.type === AnnotationType.PolyLine
                || this.type === AnnotationType.Ink) {
            if (this.opacity < 1.0) {
                str += "/CA " + this.opacity;
            }
            if (this.width !== 1) {
                str += "/BS <</Type /Border /W " + this.width + ">>";
            }
            if (this.fillColor.length > 0) {
                str += "/IC [";
                for (var i = 0, ii = this.fillColor.length; i < ii; i++) {
                    str += this.fillColor[i] + " ";
                }
                str += "]";
            }
            if (this.strokeColor.length > 0) {
                str += "/C [";
                for (var i = 0, ii = this.strokeColor.length; i < ii; i++) {
                    str += this.strokeColor[i] + " ";
                }
                str += "]";
            }
        }
        str += ">>";
        return str;
    }
});

Object.defineProperty(Annotation.prototype, "destroy", {
    value: function () {
        console.log("destroy not defined");
        return true;
    }
});

Object.defineProperty(Annotation.prototype, "getProps", {
    value: function () {
        console.log("getProps not defined");
        return true;
    }
});

Object.defineProperty(Annotation.prototype, "getStateInModel", {
    value: function () {
        console.log("getStateInModel not defined");
        return true;
    }
});

Object.defineProperty(Annotation.prototype, "setProps", {
    value: function (objParam) {
        for (var nn in objParam) {
            if (nn in this) {
                this[nn] = objParam[nn];
            }
        }
        return true;
    }
});

Object.defineProperty(Annotation.prototype, "transitionToState", {
    value: function (objParam) {
        console.log("transitionToState not defined");
    }
});

function Bookmark() {
    this.children = null; //or array
    this.color = ["RGB", 1, 0, 0];
    this.name = "";
    this.open = true;
    this.parent = null;
    this.style = 0;
    this.createChild = function (cName, cExpr, nIndex) {
        console.log("createChild not defined");
    };
    this.execute = function () {
        console.log("execute not defined");
    };
    this.insertChild = function (oBookmark, nIndex) {
        console.log("insertChild not defined");
    };
    this.remove = function () {
        console.log("remove not defined");
    };
    this.setAction = function (cScript) {
        console.log("setAction not defined");
    };
}

function Catalog() {
    this.isIdle = false;
    this.jobs = new Array();
    this.getIndex = function (cDIPath) {
        console.log("getIndex not defined");
    };
    this.remove = function (oJob) {
        console.log("remove not defined");
    };
}

function CatalogJob() {
    this.path = "";
    this.type = "";//Build,Rebuild,Delete
    this.status = "";//Pending,Processing,Completed,CompletedWithErrors    
}

function Certificate() {
    this.binary = "";
    this.issuerDN = {};
    this.keyUsage = new Array();
    //kDigitalSignature kDataEncipherment kCRLSign,kNonRepudiation kKeyAgreement,
    //kEncipherOnly,kKeyEncipherment kKeyCertSign kDecipherOnly    
    this.MD5Hash = "";
    this.privateKeyValidityEnd = {};
    this.privateKeyValidityStart = {};
    this.SHA1Hash = "";
    this.serialNumber = "";
    this.subjectCN = "";
    this.subjectDN = "";
    this.ubRights = {};
    this.usage = {};
    this.validityEnd = {};
    this.validityStart = {};

}

function Rights() {
    this.mode = ""; //Evaluation,Production
    this.rights = new Array();
    //FormFillInAndSave ,FormImportExport,FormAddDelete ,SubmitStandalone,
    //SpawnTemplate, Signing, AnnotModify, AnnotImportExport, BarcodePlaintext,
    //AnnotOnline, FormOnline, EFModify       
}

function Usage() {
    this.endUserSigning = false;
    this.endUserEncryption = false;
}

var Collab = {
    addStateModel: function (cName, cUIName, oStates, cDefault, bHidden, bHistory) {
        console.log("addStateModel not implemented");
    },
    documentToStream: function (oDocument) {
        console.log("documentToStream not implemented");
    },
    removeStateModel: function (cName) {
        console.log("removeStateModel not implemented");
    }
};

function States() {
    this.cUIName = "";
    this.oIcon = {};
}

var color = {
    transparent: ["T"], black: ["G", 0], white: ["G", 1], red: ["RGB", 1, 0, 0],
    green: ["RGB", 0, 1, 0], blue: ["RGB", 0, 0, 1], cyan: ["CMYK", 1, 0, 0, 0],
    magenta: ["CMYK", 0, 1, 0, 0], yellow: ["CMYK", 0, 0, 1, 0], dkGray: ["G", 0.25],
    gray: ["G", 0.5], ltGray: ["G", 0.75],
    convert: function (oColor, oColorSpace) {
        var oOut = oColor;
        switch (oColorSpace) {
            case "G":
                if (oColor[0] === "RGB")
                    oOut = new Array("G", 0.3 * oColor[1] + 0.59 * oColor[2] + 0.11 * oColor[3]);
                else if (oColor[0] === "CMYK")
                    oOut = new Array("G", 1.0 - Math.min(1.0,
                            0.3 * oColor[1] + 0.59 * oColor[2] + 0.11 * oColor[3] + oColor[4]));
                break;
            case "RGB":
                if (oColor[0] === "G")
                    oOut = new Array("RGB", oColor[1], oColor[1], oColor[1]);
                else if (oColor[0] === "CMYK")
                    oOut = new Array("RGB", 1.0 - Math.min(1.0, oColor[1] + oColor[4]),
                            1.0 - Math.min(1.0, oColor[2] + oColor[4]),
                            1.0 - Math.min(1.0, oColor[3] + oColor[4]));
                break;
            case "CMYK":
                if (oColor[0] === "G")
                    oOut = new Array("CMYK", 0, 0, 0, 1.0 - oColor[1]);
                else if (oColor[0] === "RGB")
                    oOut = new Array("CMYK", 1.0 - oColor[1], 1.0 - oColor[2], 1.0 - oColor[3], 0);
                break;
        }
        return oOut;
    },
    equal: function (c1, c2) {
        if (c1[0] === "G") {
            c1 = this.convert(c1, c2[0]);
        } else {
            c2 = this.convert(c2, c1[0]);
        }
        if (c1[0] !== c2[0]) {
            return false;
        }
        var nComponents = c1[0].length;
        for (var i = 1; i <= nComponents; i++) {
            if (c1[i] !== c2[i]) {
                return false;
            }
        }
        return true;
    }
};

function ColorConvertAction() {
    this.action = {};//constants.actions object
    this.alias = "";
    this.colorantName = "";
    this.convertIntent = 0;
    this.convertProfile = "";
    this.embed = false;
    this.isProcessColor = false;
    this.matchAttributesAll = {};//constants.objectFlags object
    this.matchAttributesAny = 0;
    this.matchIntent = {};
    this.matchSpaceTypeAll = {};//constants.spaceFlags object
    this.matchSpaceTypeAny = 0;
    this.preserveBlack = false;
    this.useBlackPointCompensation = false;
}

function Column() {
    this.columnNum - 0;
    this.name = "";
    this.type = 0;
    this.typeName = "";
    this.value = "";
}

function ColumnInfo() {
    this.name = "";
    this.description = "";
    this.type = "";
    this.typeName = "";
}

function Connection() {
    this.close = function () {
        console.log("close not defined");
    };
    this.getColumnList = function (cName) {
        console.log("getColumnList not defined");
    };
    this.getTableList = function () {
        console.log("getTableList not defined");
    };
    this.newStatement = function () {
        console.log("newStatement not defined");
    };
}

function Data() {
    this.creationDate = {};
    this.description = "";
    this.MIMEType = "";
    this.modDate = {};
    this.name = "";
    this.path = "";
    this.size = 0;
}

function DataSourceInfo() {
    this.name = "";
    this.description = "";
}

function dbg() {
    this.bps = new Array();
    this.c = new function () {
        console.log("c not defined");
    };
    this.cb = function (fileName, lineNum) {
        console.log("cb not defined");
    };
    this.q = function () {
        console.log("q not defined");
    };
    this.sb = function (fileName, lineNum, condition) {
        console.log("sb not defined");
    };
    this.si = function () {
        console.log("si not defined");
    };
    this.sn = function () {
        console.log("sn not defined");
    };
    this.so = function () {
        console.log("so not defined");
    };
    this.sv = function () {
        console.log("sv not defined");
    };
}

function Dialog() {
    this.enable = function (obj) {
        console.log("enable not defined");
    };
    this.end = function (str) {
        console.log("end not defined");
    };
    this.load = function (obj) {
        console.log("load not defined");
    };
    this.store = function (obj) {
        console.log("store not defined");
    };
}

function DirConnection() {
    this.canList = false;
    this.canDoCustomSearch = false;
    this.canDoCustomUISearch = false;
    this.canDoStandardSearch = false;
    this.groups = new Array();
    this.name = "";
    this.uiName = "";
}

function Directory() {
    this.info = {};
    this.connect = function (oParams, bUI) {
        console.log("connect not defined");
        return null;
    };
}

function DirectoryInformation() {
    this.dirStdEntryID = "";
    this.dirStdEntryName = "";
    this.dirStdEntryPrefDirHandlerID = "";
    this.dirStdEntryDirType = "";
    this.dirStdEntryDirVersion = "";
    this.server = "";
    this.port = 0;
    this.searchBase = "";
    this.maxNumEntries = 0;
    this.timeout = 0;
}

function Icon() {
    this.name = "";
}

function IconStream() {
    this.width = 0;
    this.height = 0;
}

function Identity() {
    this.corporation = "";
    this.email = "";
    this.loginName = "";
    this.name = "";
}

function Index() {
    this.available = false;
    this.name = "";
    this.path = "";
    this.selected = false;
    this.build = function () {
        console.log("build is not defined");
    };
    this.parameters = function () {
        console.log("parameters is not defined");
    };
}

function Link() {
    this.borderColor = [];
    this.borderWidth = 0;
    this.highlightMode = "invert";
    this.rect = [];
    this.setAction = function () {
        console.log("setAction is not defined");
    };
}

function Marker() {
    this.frame = 0;
    this.index = 0;
    this.name = "";
    this.time = 0;
}

function Markers() {
    this.player = {};
    this.get = function (i) {
        console.log("get is not defined");
    };
}

function Media() {
    this.align = {
        topLeft: 0, topCenter: 1, topRight: 2, centerLeft: 3, center: 4,
        centerRight: 5, bottomLeft: 6, bottomCenter: 7, bottomRight: 8
    };
    this.canResize = {
        no: 0, keepRatio: 1, yes: 2
    };
    this.closeReason = {
        general: 0, error: 1, done: 2, stop: 3, play: 4, uiGeneral: 5,
        uiScreen: 6, uiEdit: 7, docClose: 8, docSave: 9, docChange: 10
    };
    this.defaultVisible = true;
    this.ifOffScreen = {
        allow: 0, forseOnScreen: 1, cancel: 2
    };
    this.layout = {
        meet: 0, slice: 1, fill: 2, scroll: 3, hidden: 4, standard: 5
    };
    this.monitorType = {
        document: 0, nonDocument: 1, primary: 3, bestColor: 4, largest: 5,
        tallest: 6, widest: 7
    };
    this.openCode = {
        success: 0, failGeneral: 1, failSecurityWindow: 2, failPlayerMixed: 3,
        failPlayerSecurityPrompt: 4, failPlayerNotFound: 5, failPlayerMimeType: 6,
        failPlayerSecurity: 7, failPlayerData: 8
    };
    this.over = {
        pageWindow: 0, appWindow: 1, desktop: 2, monitor: 3
    };
    this.pageEventNames = {
        Open: 0, Close: 1, InView: 2, OutView: 3
    };
    this.raiseCode = {
        fileNotFound: 0, fileOpenFailed: 1
    };
    this.raiseSystem = {
        fileError: 0
    };
    this.renditionType = {
        unknown: 0, media: 1, selector: 2
    };
    this.status = {
        clear: 0, message: 1, contacting: 2, buffering: 3, init: 4, seeking: 5
    };
    this.trace = false;
    this.version = 7.0;
    this.windowType = {
        docked: 0, floating: 1, fullScreen: 2
    };
    this.addStockEvents = function (playerObj, annot) {
        console.log("addStockEvents not defined");
    };
    this.alertFileNotFound = function (oDoc, cFileName, bCanSkipAlert) {
        console.log("alertFileNotFound not defined");
    };
    this.alertSelectFailed = function (oDoc, oRejects, bCanSkipAlert, bFromUser) {
        console.log("alertFileNotFound not defined");
    };
    this.argsDWIM = function (args) {
        console.log("argsDWIM not defined");
    };
    this.canPlayOrAlert = function (args) {
        console.log("canPlayOrAlert not defined");
    };
    this.computeFloatWinRect = function (doc, floating, monitorType, uiSize) {
        console.log("computeFloatWinRect not defined");
    };
    this.constrainRectToScreen = function (rect, anchorPt) {
        console.log("constrainRectToScreen not defined");
    };
    this.createPlayer = function (args) {
        console.log("createPlayer not defined");
    };
    this.getAltTextData = function (cAltText) {
        console.log("getAltTextData not defined");
    };
    this.getAltTextSettings = function () {
        console.log("getAltTextSettings not defined");
    };
    this.getAnnotStockEvents = function () {
        console.log("getAnnotStockEvents not defined");
    };
    this.getAnnotTraceEvents = function () {
        console.log("getAnnotTraceEvents not defined");
    };
    this.getPlayers = function () {
        console.log("getPlayers not defined");
    };
    this.getPlayerStockEvents = function () {
        console.log("getPlayerStockEvents not defined");
    };
    this.getPlayerTraceEvents = function () {
        console.log("getPlayerTraceEvents not defined");
    };
    this.getRenditionSettings = function () {
        console.log("getRenditionSettings not defined");
    };
    this.getURLData = function () {
        console.log("getURLData not defined");
    };
    this.getURLSettings = function () {
        console.log("getURLSettings not defined");
    };
    this.getWindowBorderSize = function () {
        console.log("getWindowBorderSize not defined");
    };
    this.openPlayer = function () {
        console.log("openPlayer not defined");
    };
    this.removeStockEvents = function () {
        console.log("removeStockEvents not defined");
    };
    this.startPlayer = function () {
        console.log("startPlayer not defined");
    };
}

function MediaOffset() {
    this.frame = 0;
    this.marker = "";
    this.time = 0;
}

function MediaPlayer() {
    this.annot = {};
    this.defaultSize = {width: 0, height: 0};
    this.doc = {};
    this.events = {};
    this.hasFocus = false;
    this.id = 0;
    this.innerRect = [];
    this.isOpen = false;
    this.isPlaying = false;
    this.outerRect = [];
    this.page = 0;
    this.settings = {};
    this.uiSize = [];
    this.visible = false;

    this.close = function () {
        console.log("close is not implemented");
    };
    this.open = function () {
        console.log("open is not implemented");
    };
    this.pause = function () {
        console.log("pause is not implemented");
    };
    this.play = function () {
        console.log("play is not implemented");
    };
    this.seek = function () {
        console.log("seek is not implemented");
    };
    this.setFocus = function () {
        console.log("setFocus is not implemented");
    };
    this.stop = function () {
        console.log("stop is not implemented");
    };
    this.triggerGetRect = function () {
        console.log("triggerGetRect is not implemented");
    };
}

function MediaReject() {
    this.rendition = {};
}

function MediaSelection() {
    this.selectContext = {};
    this.players = [];
    this.rejects = [];
    this.rendtion = {};
}

function MediaSettings() {
    this.autoPlay = false;
    this.baseURL = "";
    this.bgColor = [];
    this.bgOpacity = 1.0;
    this.data = {};
    this.duration = 0;
    this.endAt = 0;
    this.floating = {};
    this.layout = 0;
    this.monitor = {};
    this.monitorType = 0;
    this.page = 0;
    this.palindrome = false;
    this.players = {};
    this.rate = 0;
    this.repeat = 0;
    this.showUI = false;
    this.startAt = {};
    this.visible = false;
    this.volume = 0;
    this.windowType = 0;
}

function Monitor() {
    this.colorDepth = 0;
    this.isPrimary = false;
    this.rect = [];
    this.workRect = [];
}

function Monitors() {
    this.bestColor = function () {
        console.log("bestColor is not implemented");
    };
    this.bestFit = function () {
        console.log("bestFit is not implemented");
    };
    this.desktop = function () {
        console.log("desktop is not implemented");
    };
    this.document = function () {
        console.log("document is not implemented");
    };
    this.filter = function () {
        console.log("filter is not implemented");
    };
    this.largest = function () {
        console.log("largest is not implemented");
    };
    this.leastOverlap = function () {
        console.log("leastOverlap is not implemented");
    };
    this.mostOverlap = function () {
        console.log("mostOverlap is not implemented");
    };
    this.nonDocument = function () {
        console.log("nonDocument is not implemented");
    };
    this.primary = function () {
        console.log("primary is not implemented");
    };
    this.secondary = function () {
        console.log("secondary is not implemented");
    };
    this.select = function () {
        console.log("select is not implemented");
    };
    this.tallest = function () {
        console.log("tallest is not implemented");
    };
    this.widest = function () {
        console.log("widest is not implemented");
    };
}

function Net() {
    this.SOAP = {};
    this.Discovery = {};
    this.HTTP = {};
    this.streamDecode = function () {
        console.log("streamDecode is not implemented");
    };
    this.streamDigest = function () {
        console.log("streamDigest is not implemented");
    };
    this.streamEncode = function () {
        console.log("streamEncode is not implemented");
    };
}

function OCG() {
    this.constants = {};
    this.initState = false;
    this.locked = false;
    this.name = "";
    this.state = false;
    this.getIntent = function () {
        console.log("getIntent is not implemented");
    };
    this.setAction = function () {
        console.log("setAction is not implemented");
    };
    this.setIntent = function () {
        console.log("setIntent is not implemented");
    };
}

function PlayerInfo() {
    this.id = "";
    this.mimeTypes = [];
    this.name = "";
    this.version = "";
    this.canPlay = function () {
        console.log("canPlay is not implemented");
    };
    this.canUseData = function () {
        console.log("canUseData is not implemented");
    };
    this.honors = function () {
        console.log("honors is not implemented");
    };
}

function PlayerInfoList() {
    this.select = function () {
        console.log("select is not implemented");
    };
}

function Plugin() {
    this.certified = false;
    this.loaded = false;
    this.name = "";
    this.path = "";
    this.version = 0;
}

function PrintParams() {
    this.binaryOK = true;
    this.bitmapDPI = 0;
    this.booklet = 0;
    this.colorOverride = 0;
    this.colorProfile = "";
    this.constants = {};
    this.downloadFarEastFonts = false;
    this.fileName = "";
    this.firstPage = 0;
    this.flags = 0;
    this.fontPolicy = 0;
    this.gradientDPI = 0;
    this.interactive = 0;
    this.lastPage = 0;
    this.nUpAutoRotate = false;
    this.nUpNumPagesH = 0;
    this.nUpNumPagesV = 0;
    this.nUpPageBorder = false;
    this.nUpPageOrder = 0;
    this.pageHandling = 0;
    this.pageSubset = 0;
    this.printAsImage = false;
    this.printContent = 0;
    this.printName = "";
    this.psLevel = 0;
    this.rasterFlags = 0;
    this.reversePages = false;
    this.tileLabel = false;
    this.tileMark = 0;
    this.tileOverlap = 0;
    this.tileScale = 0;
    this.transparencyLevel = 0;
    this.usePrinterCRD = 0;
    this.useT1Conversion = 0;
}

RE_NUMBER_ENTRY_DOT_SEP = new Array(
        "[+-]?\\d*\\.?\\d*"
        );
RE_NUMBER_COMMIT_DOT_SEP = new Array(
        "[+-]?\\d+(\\.\\d+)?", /* -1.0 or -1 */
        "[+-]?\\.\\d+", /* -.1 */
        "[+-]?\\d+\\."				/* -1. */
        );
RE_NUMBER_ENTRY_COMMA_SEP = new Array(
        "[+-]?\\d*,?\\d*"
        );
RE_NUMBER_COMMIT_COMMA_SEP = new Array(
        "[+-]?\\d+([.,]\\d+)?", /* -1,0 or -1 */
        "[+-]?[.,]\\d+", /* -,1 */
        "[+-]?\\d+[.,]"	/* -1, */
        );
RE_ZIP_ENTRY = new Array(
        "\\d{0,5}"
        );
RE_ZIP_COMMIT = new Array(
        "\\d{5}"
        );
RE_ZIP4_ENTRY = new Array(
        "\\d{0,5}(\\.|[- ])?\\d{0,4}"
        );
RE_ZIP4_COMMIT = new Array(
        "\\d{5}(\\.|[- ])?\\d{4}"
        );
RE_PHONE_ENTRY = new Array(
        "\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", /* 555-1234 or 408 555-1234 */
        "\\(\\d{0,3}", /* (408 */
        "\\(\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", /* (408) 555-1234 */
        /* (allow the addition of parens as an afterthought) */
        "\\(\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", /* (408 555-1234 */
        "\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", /* 408) 555-1234 */
        "011(\\.|[- \\d])*"										/* international */
        );
RE_PHONE_COMMIT = new Array(
        "\\d{3}(\\.|[- ])?\\d{4}", /* 555-1234 */
        "\\d{3}(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}", /* 408 555-1234 */
        "\\(\\d{3}\\)(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}", /* (408) 555-1234 */
        "011(\\.|[- \\d])*"									/* international */
        );
RE_SSN_ENTRY = new Array(
        "\\d{0,3}(\\.|[- ])?\\d{0,2}(\\.|[- ])?\\d{0,4}"
        );
RE_SSN_COMMIT = new Array(
        "\\d{3}(\\.|[- ])?\\d{2}(\\.|[- ])?\\d{4}"
        );
var JSRESERVED = [
    "break", "delete", "function", "return", "typeof", "case", "do", "if",
    "switch", "var", "catch", "else", "in", "this", "void", "continue", "false",
    "instanceof", "throw", "while", "debugger", "finally", "new", "true", "with",
    "default", "for", "null", "try", "class", "const", "enum", "export", "extends",
    "import", "super", "implements", "let", "private", "public", "yield",
    "interface", "package", "protected", "static",
    "abstract", "double", "goto", "native", "static", "boolean", "enum",
    "implements", "package", "super", "byte", "export", "import", "private",
    "synchronized", "char", "extends", "int", "protected", "throws", "class",
    "final", "interface", "public", "transient", "const", "float", "long",
    "short", "volatile",
    "arguments", "encodeURI", "Infinity", "Number", "RegExp", "Array",
    "encodeURIComponent", "isFinite", "Object", "String", "Boolean", "Error",
    "isNaN", "parseFloat", "SyntaxError", "Date", "eval", "JSON", "parseInt",
    "TypeError", "decodeURI", "EvalError", "Math", "RangeError", "undefined",
    "decodeURIComponent", "Function", "NaN", "ReferenceError", "URIError"
];

var QeTable = [
    {qe: 0x5601, nmps: 1, nlps: 1, switchFlag: 1},
    {qe: 0x3401, nmps: 2, nlps: 6, switchFlag: 0},
    {qe: 0x1801, nmps: 3, nlps: 9, switchFlag: 0},
    {qe: 0x0ac1, nmps: 4, nlps: 12, switchFlag: 0},
    {qe: 0x0521, nmps: 5, nlps: 29, switchFlag: 0},
    {qe: 0x0221, nmps: 38, nlps: 33, switchFlag: 0},
    {qe: 0x5601, nmps: 7, nlps: 6, switchFlag: 1},
    {qe: 0x5401, nmps: 8, nlps: 14, switchFlag: 0},
    {qe: 0x4801, nmps: 9, nlps: 14, switchFlag: 0},
    {qe: 0x3801, nmps: 10, nlps: 14, switchFlag: 0},
    {qe: 0x3001, nmps: 11, nlps: 17, switchFlag: 0},
    {qe: 0x2401, nmps: 12, nlps: 18, switchFlag: 0},
    {qe: 0x1c01, nmps: 13, nlps: 20, switchFlag: 0},
    {qe: 0x1601, nmps: 29, nlps: 21, switchFlag: 0},
    {qe: 0x5601, nmps: 15, nlps: 14, switchFlag: 1},
    {qe: 0x5401, nmps: 16, nlps: 14, switchFlag: 0},
    {qe: 0x5101, nmps: 17, nlps: 15, switchFlag: 0},
    {qe: 0x4801, nmps: 18, nlps: 16, switchFlag: 0},
    {qe: 0x3801, nmps: 19, nlps: 17, switchFlag: 0},
    {qe: 0x3401, nmps: 20, nlps: 18, switchFlag: 0},
    {qe: 0x3001, nmps: 21, nlps: 19, switchFlag: 0},
    {qe: 0x2801, nmps: 22, nlps: 19, switchFlag: 0},
    {qe: 0x2401, nmps: 23, nlps: 20, switchFlag: 0},
    {qe: 0x2201, nmps: 24, nlps: 21, switchFlag: 0},
    {qe: 0x1c01, nmps: 25, nlps: 22, switchFlag: 0},
    {qe: 0x1801, nmps: 26, nlps: 23, switchFlag: 0},
    {qe: 0x1601, nmps: 27, nlps: 24, switchFlag: 0},
    {qe: 0x1401, nmps: 28, nlps: 25, switchFlag: 0},
    {qe: 0x1201, nmps: 29, nlps: 26, switchFlag: 0},
    {qe: 0x1101, nmps: 30, nlps: 27, switchFlag: 0},
    {qe: 0x0ac1, nmps: 31, nlps: 28, switchFlag: 0},
    {qe: 0x09c1, nmps: 32, nlps: 29, switchFlag: 0},
    {qe: 0x08a1, nmps: 33, nlps: 30, switchFlag: 0},
    {qe: 0x0521, nmps: 34, nlps: 31, switchFlag: 0},
    {qe: 0x0441, nmps: 35, nlps: 32, switchFlag: 0},
    {qe: 0x02a1, nmps: 36, nlps: 33, switchFlag: 0},
    {qe: 0x0221, nmps: 37, nlps: 34, switchFlag: 0},
    {qe: 0x0141, nmps: 38, nlps: 35, switchFlag: 0},
    {qe: 0x0111, nmps: 39, nlps: 36, switchFlag: 0},
    {qe: 0x0085, nmps: 40, nlps: 37, switchFlag: 0},
    {qe: 0x0049, nmps: 41, nlps: 38, switchFlag: 0},
    {qe: 0x0025, nmps: 42, nlps: 39, switchFlag: 0},
    {qe: 0x0015, nmps: 43, nlps: 40, switchFlag: 0},
    {qe: 0x0009, nmps: 44, nlps: 41, switchFlag: 0},
    {qe: 0x0005, nmps: 45, nlps: 42, switchFlag: 0},
    {qe: 0x0001, nmps: 45, nlps: 43, switchFlag: 0},
    {qe: 0x5601, nmps: 46, nlps: 46, switchFlag: 0}
];

function ArithmeticDecoder() {
    this.construct = function (data, start, end) {
        this.data = data;
        this.bp = start;
        this.dataEnd = end;
        this.chigh = data[start];
        this.clow = 0;
        this.byteIn();

        this.chigh = ((this.chigh << 7) & 0xffff) | ((this.clow >> 9) & 0x7f);
        this.clow = (this.clow << 7) & 0xffff;
        this.ct -= 7;
        this.a = 0x8000;
    };
    this.byteIn = function () {
        const data = this.data;
        let bp = this.bp;
        if (data[bp] === 0xff) {
            if (data[bp + 1] > 0x8f) {
                this.clow += 0xff00;
                this.ct = 8;
            } else {
                bp++;
                this.clow += data[bp] << 9;
                this.ct = 7;
                this.bp = bp;
            }
        } else {
            bp++;
            this.clow += bp < this.dataEnd ? data[bp] << 8 : 0xff00;
            this.ct = 8;
            this.bp = bp;
        }
        if (this.clow > 0xffff) {
            this.chigh += this.clow >> 16;
            this.clow &= 0xffff;
        }
    };
    this.readBit = function (contexts, pos) {
        let cx_index = contexts[pos] >> 1,
                cx_mps = contexts[pos] & 1;
        const qeTableIcx = QeTable[cx_index];
        const qeIcx = qeTableIcx.qe;
        let d;
        let a = this.a - qeIcx;

        if (this.chigh < qeIcx) {
            if (a < qeIcx) {
                a = qeIcx;
                d = cx_mps;
                cx_index = qeTableIcx.nmps;
            } else {
                a = qeIcx;
                d = 1 ^ cx_mps;
                if (qeTableIcx.switchFlag === 1) {
                    cx_mps = d;
                }
                cx_index = qeTableIcx.nlps;
            }
        } else {
            this.chigh -= qeIcx;
            if ((a & 0x8000) !== 0) {
                this.a = a;
                return cx_mps;
            }
            if (a < qeIcx) {
                d = 1 ^ cx_mps;
                if (qeTableIcx.switchFlag === 1) {
                    cx_mps = d;
                }
                cx_index = qeTableIcx.nlps;
            } else {
                d = cx_mps;
                cx_index = qeTableIcx.nmps;
            }
        }
        do {
            if (this.ct === 0) {
                this.byteIn();
            }
            a <<= 1;
            this.chigh = ((this.chigh << 1) & 0xffff) | ((this.clow >> 15) & 1);
            this.clow = (this.clow << 1) & 0xffff;
            this.ct--;
        } while ((a & 0x8000) === 0);
        this.a = a;
        contexts[pos] = (cx_index << 1) | cx_mps;
        return d;
    };
}

var EcmaFilter = {
    decode: function (name, data) {
        if (name === "FlateDecode") {
            var ef = new EcmaFlate();
            var input = [];
            var a = 0;
            for (var i = 2, ii = data.length; i < ii; i++) {
                input[a++] = data[i];
            }
            return ef.decode(input);
        } else if (name === "ASCII85Decode") {
            var as8 = new EcmaAscii85();
            return as8.decode(data);
        } else if (name === "ASCIIHexDecode") {
            var ash = new EcmaAsciiHex();
            return ash.decode(data);
        } else if (name === "RunLengthDecode") {
            var rlc = new EcmaRunLength();
            return rlc.decode();
        } else {
            console.log("This type of decoding is not supported yet : " + name);
            return data;
        }
    },
    applyPredictor: function (data, mainPred, bos, colors, bpc, columns, earlychange) {
        if (mainPred === 1) {
            return data;
        }
        var predictor;
        var bytesAvailable = data.length;
        var bis = new EcmaBuffer(data);

        var bpp = (colors * bpc + 7) >> 3;
        var rowLength = ((columns * colors * bpc + 7) >> 3) + bpp;

        var thisLine = this.createByteBuffer(rowLength);
        var lastLine = this.createByteBuffer(rowLength);
        var curPred;
        var count = 0;
        var byteCount = 0;
        while (true) {
            if (bytesAvailable <= byteCount) {
                break;
            }
            predictor = mainPred;
            var i = 0;
            var offset = bpp;
            if (predictor >= 10) {
                curPred = bis.getByte();
                if (curPred === -1) {
                    break;
                }
                curPred += 10;
            } else {
                curPred = predictor;
            }
            while (offset < rowLength) {
                i = bis.readTo(thisLine, offset, rowLength - offset);
                if (i === -1) {
                    break;
                }
                offset += i;
                byteCount += i;
            }
            if (i === -1) {
                break;
            }
            switch (curPred) {
                case 2:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        var sub = thisLine[i1] & 0xff;
                        var raw = thisLine[i1 - bpp] & 0xff;
                        thisLine[i1] = (sub + raw) & 0xff;
                        if (bos) {
                            bos[count] = thisLine[i1];
                        }
                        count++;
                    }
                    break;
                case 10:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        if (bos) {
                            bos[count] = thisLine[i1] & 0xff;
                        }
                        count++;
                    }
                    break;
                case 11:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        var sub = thisLine[i1] & 0xff;
                        var raw = thisLine[i1 - bpp] & 0xff;
                        thisLine[i1] = sub + raw;
                        if (bos) {
                            bos[count] = thisLine[i1] & 0xff;
                        }
                        count++;
                    }
                    break;
                case 12:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        var sub = (lastLine[i1] & 0xff) + (thisLine[i1] & 0xff);
                        thisLine[i1] = sub;
                        if (bos) {
                            bos[count] = thisLine[i1] & 0xff;
                        }
                        count++;
                    }
                    break;
                case 13:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        var av = thisLine[i1] & 0xff;
                        var ff = ((thisLine[i1 - bpp] & 0xff) + (lastLine[i1] & 0xff) >> 1);
                        thisLine[i1] = av + ff;
                        if (bos) {
                            bos[count] = thisLine[i1] & 0xff;
                        }
                        count++;
                    }
                    break;
                case 14:
                    for (var i1 = bpp; i1 < rowLength; i1++) {
                        var a = thisLine[i1 - bpp] & 0xff;
                        var b = lastLine[i1] & 0xff;
                        var c = lastLine[i1 - bpp] & 0xff;
                        var p = a + b - c;
                        var pa = p - a, pb = p - b, pc = p - c;
                        pa = pa < 0 ? -pa : pa;
                        pb = pb < 0 ? -pb : pb;
                        pc = pc < 0 ? -pc : pc;
                        if (pa <= pb && pa <= pc) {
                            thisLine[i1] = thisLine[i1] + a;
                        } else if (pb <= pc) {
                            thisLine[i1] = thisLine[i1] + b;
                        } else {
                            thisLine[i1] = thisLine[i1] + c;
                        }
                        if (bos) {
                            bos[count] = thisLine[i1] & 0xff;
                        }
                        count++;
                    }
                    break;
                case 15:
                    break;
            }
            for (var i = 0; i < rowLength; i++) {
                lastLine[i] = thisLine[i];
            }
        }
        return count;
    },
    createByteBuffer: function (size) {
        var arr = [];
        for (var i = 0; i < size; i++) {
            arr.push(0);
        }
        return arr;
    },
    decodeBase64: function (bStr) {
        var hashKey = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var enc1, enc2, enc3, enc4;
        var output = [];
        var input = bStr.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        var ii = input.length;
        var i = 0;
        while (i < ii) {
            enc1 = hashKey.indexOf(input.charAt(i++));
            enc2 = hashKey.indexOf(input.charAt(i++));
            enc3 = hashKey.indexOf(input.charAt(i++));
            enc4 = hashKey.indexOf(input.charAt(i++));
            output.push((enc1 << 2) | (enc2 >> 4));
            if (enc3 !== 64) {
                output.push(((enc2 & 15) << 4) | (enc3 >> 2));
            }
            if (enc4 !== 64) {
                output.push(((enc3 & 3) << 6) | enc4);
            }
        }
        return output;
    },
    encodeBase64: function (inputArr) { //input is byte array
        var hashKey = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        var iLen = inputArr.length;
        while (i < iLen) {
            chr1 = inputArr[i++];
            chr2 = inputArr[i++];
            chr3 = inputArr[i++];
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }
            output += hashKey.charAt(enc1) + hashKey.charAt(enc2) +
                    hashKey.charAt(enc3) + hashKey.charAt(enc4);
        }
        return output;
    }
};

function EcmaFlate() {
    this.decode = function (data) {
        var res, buff;
        var k, j, buffLen = 1024;
        zip_wp = 0;
        bitsBuffer = 0;
        bitsLength = 0;
        flateType = -1;
        isEOF = false;
        zip_copy_leng = zip_copy_dist = 0;
        zip_tl = null;
        flateData = data;
        flatePos = 0;
        buff = new Array(buffLen);
        res = [];
        while ((k = inflateChunks(buff, 0, buffLen)) > 0) {
            for (j = 0; j < k; j++) {
                res.push(buff[j]);
            }
        }
        flateData = null;
        return res;
    };

    var MASK_BITS = [
        0x0000, 0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff,
        0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff, 0xffff
    ];
    var CODE_LENGTHS = [
        3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59,
        67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
    ];
    var CODE_DISTANCES = [
        1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513,
        769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577
    ];
    var FLATE_MARGINS = [
        16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15
    ];
    var zip_cplext = [
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
        5, 5, 5, 5, 0, 99, 99
    ];
    var zip_cpdext = [
        0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
        10, 11, 11, 12, 12, 13, 13
    ];

    var WINDOW_SIZE = 32768;
    var STORED_BLOCK = 0;
    var windowSlides = new Array(WINDOW_SIZE << 1);
    var flateType, flateData, flatePos, bitsBuffer, bitsLength;
    var isEOF;
    var zip_wp;
    var zip_fixed_tl = null;
    var zip_fixed_td, zip_fixed_bl, zip_fixed_bd;
    var zip_copy_leng;
    var zip_copy_dist;
    var zip_lbits = 9, zip_dbits = 6, zip_tl, zip_td, zip_bl, zip_bd;

    function readByte() {
        if (flateData.length === flatePos) {
            return -1;
        }
        return flateData[flatePos++] & 0xff;
    }
    function readBits(x) {
        return bitsBuffer & MASK_BITS[x];
    }
    function HuffmanTableList() {
        this.next = null;
        this.list = null;
    }
    function HuffmanTableNode() {
        this.e = 0;
        this.b = 0;
        this.n = 0;
        this.t = null;
    }
    function HuffmanTableBlock(b, n, s, d, e, mm) {
        this.BMAX = 16;
        this.N_MAX = 288;
        this.status = 0;
        this.root = null;
        this.m = 0;
        {
            var a, c = new Array(this.BMAX + 1);
            var el, f, g, h, i, j, k, lx = new Array(this.BMAX + 1);
            var p, pidx, q;
            var r = new HuffmanTableNode();
            var u = new Array(this.BMAX);
            var v = new Array(this.N_MAX);
            var x = new Array(this.BMAX + 1);
            var w, xp, y, z, o, tail;

            tail = this.root = null;
            for (i = 0; i < c.length; i++) {
                c[i] = 0;
            }
            for (i = 0; i < lx.length; i++) {
                lx[i] = 0;
            }
            for (i = 0; i < u.length; i++) {
                u[i] = null;
            }
            for (i = 0; i < v.length; i++) {
                v[i] = 0;
            }
            for (i = 0; i < x.length; i++) {
                x[i] = 0;
            }

            el = n > 256 ? b[256] : this.BMAX;
            p = b;
            pidx = 0;
            i = n;
            do {
                c[p[pidx]]++;
                pidx++;
            } while (--i > 0);
            if (c[0] === n) {
                this.root = null;
                this.m = 0;
                this.status = 0;
                return;
            }
            for (j = 1; j <= this.BMAX; j++) {
                if (c[j] !== 0) {
                    break;
                }
            }
            k = j;
            if (mm < j) {
                mm = j;
            }
            for (i = this.BMAX; i !== 0; i--) {
                if (c[i] !== 0) {
                    break;
                }
            }
            g = i;
            if (mm > i) {
                mm = i;
            }
            for (y = 1 << j; j < i; j++, y <<= 1) {
                if ((y -= c[j]) < 0) {
                    this.status = 2;
                    this.m = mm;
                    return;
                }
            }
            if ((y -= c[i]) < 0) {
                this.status = 2;
                this.m = mm;
                return;
            }
            c[i] += y;

            x[1] = j = 0;
            p = c;
            pidx = 1;
            xp = 2;
            while (--i > 0) {
                x[xp++] = (j += p[pidx++]);
            }

            p = b;
            pidx = 0;
            i = 0;
            do {
                if ((j = p[pidx++]) !== 0) {
                    v[x[j]++] = i;
                }
            } while (++i < n);
            n = x[g];
            x[0] = i = 0;
            p = v;
            pidx = 0;
            h = -1;
            w = lx[0] = 0;
            q = null;
            z = 0;

            for (; k <= g; k++) {
                a = c[k];
                while (a-- > 0) {
                    while (k > w + lx[1 + h]) {
                        w += lx[1 + h];
                        h++;
                        z = (z = g - w) > mm ? mm : z;
                        if ((f = 1 << (j = k - w)) > a + 1) {
                            f -= a + 1;
                            xp = k;
                            while (++j < z) {
                                if ((f <<= 1) <= c[++xp])
                                    break;
                                f -= c[xp];
                            }
                        }
                        if (w + j > el && w < el)
                            j = el - w;
                        z = 1 << j;
                        lx[1 + h] = j;

                        q = new Array(z);
                        for (o = 0; o < z; o++) {
                            q[o] = new HuffmanTableNode();
                        }

                        if (tail) {
                            tail = tail.next = new HuffmanTableList();
                        } else {
                            tail = this.root = new HuffmanTableList();
                        }
                        tail.next = null;
                        tail.list = q;
                        u[h] = q;
                        if (h > 0) {
                            x[h] = i;
                            r.b = lx[h];
                            r.e = 16 + j;
                            r.t = q;
                            j = (i & ((1 << w) - 1)) >> (w - lx[h]);
                            u[h - 1][j].e = r.e;
                            u[h - 1][j].b = r.b;
                            u[h - 1][j].n = r.n;
                            u[h - 1][j].t = r.t;
                        }
                    }
                    r.b = k - w;
                    if (pidx >= n) {
                        r.e = 99;
                    } else if (p[pidx] < s) {
                        r.e = (p[pidx] < 256 ? 16 : 15);
                        r.n = p[pidx++];
                    } else {
                        r.e = e[p[pidx] - s];
                        r.n = d[p[pidx++] - s];
                    }
                    f = 1 << (k - w);
                    for (j = i >> w; j < z; j += f) {
                        q[j].e = r.e;
                        q[j].b = r.b;
                        q[j].n = r.n;
                        q[j].t = r.t;
                    }
                    for (j = 1 << (k - 1); (i & j) !== 0; j >>= 1) {
                        i ^= j;
                    }
                    i ^= j;

                    while ((i & ((1 << w) - 1)) !== x[h]) {
                        w -= lx[h];
                        h--;
                    }
                }
            }

            this.m = lx[1];
            this.status = ((y !== 0 && g !== 1) ? 1 : 0);
        }
    }
    function zip_NEEDBITS(n) {
        while (bitsLength < n) {
            bitsBuffer |= readByte() << bitsLength;
            bitsLength += 8;
        }
    }
    function ignoreBits(n) {
        bitsBuffer >>= n;
        bitsLength -= n;
    }
    function decodeHFC(buff, off, size) {
        if (size === 0) {
            return 0;
        }
        var e, t, n = 0;
        while (true) {
            zip_NEEDBITS(zip_bl);
            t = zip_tl.list[readBits(zip_bl)];
            e = t.e;
            while (e > 16) {
                if (e === 99) {
                    return -1;
                }
                ignoreBits(t.b);
                e -= 16;
                zip_NEEDBITS(e);
                t = t.t[readBits(e)];
                e = t.e;
            }
            ignoreBits(t.b);

            if (e === 16) {
                zip_wp &= WINDOW_SIZE - 1;
                buff[off + n++] = windowSlides[zip_wp++] = t.n;
                if (n === size) {
                    return size;
                }
                continue;
            }

            if (e === 15) {
                break;
            }
            zip_NEEDBITS(e);
            zip_copy_leng = t.n + readBits(e);
            ignoreBits(e);

            zip_NEEDBITS(zip_bd);
            t = zip_td.list[readBits(zip_bd)];
            e = t.e;

            while (e > 16) {
                if (e === 99) {
                    return -1;
                }
                ignoreBits(t.b);
                e -= 16;
                zip_NEEDBITS(e);
                t = t.t[readBits(e)];
                e = t.e;
            }
            ignoreBits(t.b);
            zip_NEEDBITS(e);
            zip_copy_dist = zip_wp - t.n - readBits(e);
            ignoreBits(e);

            while (zip_copy_leng > 0 && n < size) {
                zip_copy_leng--;
                zip_copy_dist &= WINDOW_SIZE - 1;
                zip_wp &= WINDOW_SIZE - 1;
                buff[off + n++] = windowSlides[zip_wp++] = windowSlides[zip_copy_dist++];
            }
            if (n === size) {
                return size;
            }
        }

        flateType = -1;
        return n;
    }

    function decodeHFCS(buff, off, size) {
        var n;
        n = bitsLength & 7;
        ignoreBits(n);
        zip_NEEDBITS(16);
        n = readBits(16);
        ignoreBits(16);
        zip_NEEDBITS(16);
        if (n !== ((~bitsBuffer) & 0xffff))
            return -1;
        ignoreBits(16);

        zip_copy_leng = n;

        n = 0;
        while (zip_copy_leng > 0 && n < size) {
            zip_copy_leng--;
            zip_wp &= WINDOW_SIZE - 1;
            zip_NEEDBITS(8);
            buff[off + n++] = windowSlides[zip_wp++] = readBits(8);
            ignoreBits(8);
        }

        if (zip_copy_leng === 0) {
            flateType = -1;
        }
        return n;
    }

    function decodeHFCF(buff, off, size) {
        if (zip_fixed_tl == null) {
            var i;
            var l = new Array(288);
            var h;

            for (i = 0; i < 144; i++) {
                l[i] = 8;
            }
            for (; i < 256; i++) {
                l[i] = 9;
            }
            for (; i < 280; i++) {
                l[i] = 7;
            }
            for (; i < 288; i++) {
                l[i] = 8;
            }
            zip_fixed_bl = 7;

            h = new HuffmanTableBlock(l, 288, 257, CODE_LENGTHS, zip_cplext, zip_fixed_bl);
            if (h.status !== 0) {
                throw("EcmaFlateDecodeError : Huffman Status " + h.status);
                return -1;
            }
            zip_fixed_tl = h.root;
            zip_fixed_bl = h.m;

            for (i = 0; i < 30; i++) {
                l[i] = 5;
            }
            zip_fixed_bd = 5;

            h = new HuffmanTableBlock(l, 30, 0, CODE_DISTANCES, zip_cpdext, zip_fixed_bd);
            if (h.status > 1) {
                zip_fixed_tl = null;
                throw("EcmaFlateDecodeError : Huffman Status" + h.status);
                return -1;
            }
            zip_fixed_td = h.root;
            zip_fixed_bd = h.m;
        }

        zip_tl = zip_fixed_tl;
        zip_td = zip_fixed_td;
        zip_bl = zip_fixed_bl;
        zip_bd = zip_fixed_bd;
        return decodeHFC(buff, off, size);
    }

    function decodeHFCD(buff, off, size) {
        var i, j, l, n, t, nb, nl, nd, h;
        var ll = new Array(286 + 30);
        for (i = 0; i < ll.length; i++) {
            ll[i] = 0;
        }
        zip_NEEDBITS(5);
        nl = 257 + readBits(5);
        ignoreBits(5);
        zip_NEEDBITS(5);
        nd = 1 + readBits(5);
        ignoreBits(5);
        zip_NEEDBITS(4);
        nb = 4 + readBits(4);
        ignoreBits(4);
        if (nl > 286 || nd > 30) {
            return -1;
        }
        for (j = 0; j < nb; j++) {
            zip_NEEDBITS(3);
            ll[FLATE_MARGINS[j]] = readBits(3);
            ignoreBits(3);
        }
        for (; j < 19; j++) {
            ll[FLATE_MARGINS[j]] = 0;
        }
        zip_bl = 7;
        h = new HuffmanTableBlock(ll, 19, 19, null, null, zip_bl);
        if (h.status !== 0) {
            return -1;
        }
        zip_tl = h.root;
        zip_bl = h.m;
        n = nl + nd;
        i = l = 0;
        while (i < n) {
            zip_NEEDBITS(zip_bl);
            t = zip_tl.list[readBits(zip_bl)];
            j = t.b;
            ignoreBits(j);
            j = t.n;
            if (j < 16)
                ll[i++] = l = j;
            else if (j === 16) {
                zip_NEEDBITS(2);
                j = 3 + readBits(2);
                ignoreBits(2);
                if (i + j > n)
                    return -1;
                while (j-- > 0)
                    ll[i++] = l;
            } else if (j === 17) {
                zip_NEEDBITS(3);
                j = 3 + readBits(3);
                ignoreBits(3);
                if (i + j > n)
                    return -1;
                while (j-- > 0)
                    ll[i++] = 0;
                l = 0;
            } else {
                zip_NEEDBITS(7);
                j = 11 + readBits(7);
                ignoreBits(7);
                if (i + j > n)
                    return -1;
                while (j-- > 0)
                    ll[i++] = 0;
                l = 0;
            }
        }

        zip_bl = zip_lbits;
        h = new HuffmanTableBlock(ll, nl, 257, CODE_LENGTHS, zip_cplext, zip_bl);
        if (zip_bl === 0) {
            h.status = 1;
        }
        if (h.status !== 0) {
            return -1;
        }
        zip_tl = h.root;
        zip_bl = h.m;

        for (i = 0; i < nd; i++)
            ll[i] = ll[i + nl];
        zip_bd = zip_dbits;
        h = new HuffmanTableBlock(ll, nd, 0, CODE_DISTANCES, zip_cpdext, zip_bd);
        zip_td = h.root;
        zip_bd = h.m;

        if (zip_bd === 0 && nl > 257 || h.status !== 0) {
            return -1;
        }
        return decodeHFC(buff, off, size);
    }

    function inflateChunks(buff, off, size) {
        var n = 0, i;
        while (n < size) {
            if (isEOF && flateType === -1) {
                return n;
            }
            if (zip_copy_leng > 0) {
                if (flateType !== STORED_BLOCK) {
                    while (zip_copy_leng > 0 && n < size) {
                        zip_copy_leng--;
                        zip_copy_dist &= WINDOW_SIZE - 1;
                        zip_wp &= WINDOW_SIZE - 1;
                        buff[off + n++] = windowSlides[zip_wp++] =
                                windowSlides[zip_copy_dist++];
                    }
                } else {
                    while (zip_copy_leng > 0 && n < size) {
                        zip_copy_leng--;
                        zip_wp &= WINDOW_SIZE - 1;
                        zip_NEEDBITS(8);
                        buff[off + n++] = windowSlides[zip_wp++] = readBits(8);
                        ignoreBits(8);
                    }
                    if (zip_copy_leng === 0)
                        flateType = -1;
                }
                if (n === size)
                    return n;
            }

            if (flateType === -1) {
                if (isEOF) {
                    break;
                }
                zip_NEEDBITS(1);
                if (readBits(1) !== 0) {
                    isEOF = true;
                }
                ignoreBits(1);
                zip_NEEDBITS(2);
                flateType = readBits(2);
                ignoreBits(2);
                zip_tl = null;
                zip_copy_leng = 0;
            }
            switch (flateType) {
                case 0:
                    i = decodeHFCS(buff, off + n, size - n);
                    break;
                case 1:
                    if (zip_tl) {
                        i = decodeHFC(buff, off + n, size - n);
                    } else {
                        i = decodeHFCF(buff, off + n, size - n);
                    }
                    break;
                case 2:
                    if (zip_tl) {
                        i = decodeHFC(buff, off + n, size - n);
                    } else {
                        i = decodeHFCD(buff, off + n, size - n);
                    }
                    break;
                default:
                    i = -1;
                    break;
            }
            if (i === -1) {
                return (isEOF) ? 0 : -1;
            }
            n += i;
        }
        return n;
    }
}

function EcmaAsciiHex() {
    this.decode = function (data) {
        var res = [];
        var prefix = -1;
        var pointer = 0;
        var val, dd;
        var isEOF = false;
        for (var i = 0, ii = data.length; i < ii; i++) {
            val = data[i];
            if (val >= 0x30 && val <= 0x39) {
                dd = val & 0x0F;
            } else if ((val >= 0x41 && val <= 0x46) || (val >= 0x61 && val <= 0x66)) {
                dd = (val & 0x0f) + 9;
            } else if (val === 0x3e) {
                isEOF = true;
                break;
            } else {
                continue;
            }
            if (prefix < 0) {
                prefix = dd;
            } else {
                res[pointer++] = (prefix << 4) | dd;
                prefix = -1;
            }
        }
        if (prefix >= 0 && isEOF) {
            res[pointer++] = prefix << 4;
            prefix = -1;
        }
        return res;
    };
}

function EcmaAscii85() {
    this.decode = function (data) {
        var n = data.length, r = [], b = [0, 0, 0, 0, 0], j, t, x, w, d;
        for (var i = 0; i < n; ++i) {
            if (data[i] === 0x7a) {
                r.push(0, 0, 0, 0);
                continue;
            }
            for (j = 0; j < 5; ++j) {
                b[j] = data[i + j] - 0x21;
            }
            d = n - i;
            if (d < 5) {
                for (j = d; j < 4; b[++j] = 0) {
                    //
                }
                b[d] = 0x55;
            }
            t = (((b[0] * 85 + b[1]) * 85 + b[2]) * 85 + b[3]) * 85 + b[4];
            x = t & 0xff;
            t >>>= 8;
            w = t & 0xff;
            t >>>= 8;
            r.push(t >>> 8, t & 0xff, w, x);
            for (j = d; j < 5; ++j, r.pop()) {
                //
            }
            i += 4;
        }
        return r;

    };
}

function EcmaRunLength() {
    this.decode = function (data) {
        var len;
        var value;
        var count = data.length;
        var pp = 0;
        var res = [];

        for (var i = 0; i < count; i++) {
            len = data[i];
            if (len < 0) {
                len = 256 + len;
            }
            if (len === 128) {
                i = count;
            } else if (len > 128) {
                i++;
                len = 257 - len;
                value = data[i];
                for (var j = 0; j < len; j++) {
                    res[pp++] = value;
                }
            } else {
                i++;
                len++;
                for (var j = 0; j < len; j++) {
                    res[pp++] = data[i + j];
                }
                i = i + len - 1;
            }
        }
        return res;
    };
}
