/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1995 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

package coldfusion.mail.mod;

import coldfusion.sql.Table;

import com.sun.mail.pop3.POP3Folder;

import java.util.ArrayList;

import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.search.MessageNumberTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.SearchTerm;

/**
 * 
 * Created on Mar 26, 2003 Author: tomj
 * 
 */
public class PopImpl
{
    protected HostImpl source;
    protected Session session = null;

    protected String username = null;
    protected String password = null;

    protected Store store = null;
    protected Folder folder = null;

    private String[] HEADER_FIELDS = {"date", "from", "messagenumber", "replyto", "subject", "cc", "to", "header", "messageid", "uid"};
    private String[] BODY_FIELDS  = {"body", "textbody", "htmlbody", "date", "from", "messagenumber", "replyto", "subject", "cc", "to", "header", "attachments", "attachmentfiles", "cids","messageid", "uid"};
    protected String[] fields = HEADER_FIELDS;

    protected String attach_path = null;
    protected boolean unique_filenames = false;

    protected boolean debug = false;
    private String[] uids = null;
    private String[] msgnums = null;
    private int startmsg = 1;
    private int maxrows = 999999;
    private boolean useSSL = false;
    private SearchTerm searchTerm = null;
    private String accept = null;

    /**
     * 
     * @param o
     */
    public void setAccept(String o)
    {
        accept = o;
    }

    /**
     * 
     * @return
     */
    public String getAccept()
    {
        return accept;
    }

    /**
     * @return the searchTerm
     */
    public SearchTerm getSearchTerm()
    {
        return searchTerm;
    }

    /**
     * @param searchTerm
     *            the searchTerm to set
     */
    public void setSearchTerm(SearchTerm searchTerm)
    {
        this.searchTerm = searchTerm;
    }

    /**
     * Set a mail source used for retrieving mail
     * @param s
     */
    public void setMailSource(HostImpl s)
    {
        source = s;
    }

    public void setUsername(String s)
    {
        username = s;
    }

    public void setPassword(String p)
    {
        password = p;
    }

    public void setPath(String p)
    {
        attach_path = p;
    }

    public void setUniqueFilenames(boolean b)
    {
        unique_filenames = b;
    }

    public void setDebug(boolean d)
    {
        debug = d;
    }

    public void setUids(String[] uids)
    {
        this.uids = uids;
    }

    public void setMsgs(String[] m)
    {
        msgnums = m;
    }

    public void setStartMsg(int start)
    {
        startmsg = start;
    }

    public void setMaxRows(int max)
    {
        maxrows = max;
    }

    public void setBody(boolean b)
    {
        if (b)
            fields = BODY_FIELDS;
        else
            fields = HEADER_FIELDS;
    }

    /**
     * Reset member elements to null, close any open folder or store.
     */
    public void clear()
    {
        source = null;
        session = null;

        username = null;
        password = null;

        fields = HEADER_FIELDS;

        attach_path = null;
        unique_filenames = false;
        debug = false;
        startmsg = 1;
        maxrows = 999999;
        msgnums = null;
        uids = null;
        useSSL = false;

        try
        {
            folder.close(false);
        }
        catch (Exception ex)
        {
        }
        finally
        {
            folder = null;
        }

        try
        {
            store.close();
        }
        catch (Exception ex)
        {
        }
        finally
        {
            store = null;
        }
    }


    /**
     * Allocates a JavaMail session object for the class
     * and connects to the mail store.
     *
     * @throws MessagingException for any errors
     */
    public void validate_folder() throws MessagingException
    {
        if (session == null)
        {
            try
            {
                session = source.getSession();
            }
            catch (Exception ex)
            {
                throw new MessagingException(ex.getMessage());
            }
        }

        session.setDebug(debug);
        if(useSSL)
        {
            try
            {
                session.getProvider("pop3s");
            } catch (Exception ex)
            {
                session.addProvider(new Provider(session.getProvider("pop3").getType(), "pop3s", "com.sun.mail.pop3.POP3SSLStore", "Sun Microsystems, Inc", null));
            }
            store = session.getStore("pop3s");
        }
        else
        {
            store = session.getStore("pop3");
        }

        String host = source.getHost();
        int port = source.getPort();

        if (port == -1)
        {
            store.connect(host, username, password);
        }
        else
        {
            store.connect(host, port, username, password);
        }

        if ((folder = store.getDefaultFolder()) == null)
        {
            throw new FolderNotFoundException();
        }
    }


    /**
     * Performs the GET and GETALL operations on messages
     * specified by the previous executed statements.
     *
     * @return a SQL table of messages
     * @throws MessagingException
     */
    public Table getMails() throws MessagingException
    {
        try
        {
            folder = folder.getFolder("INBOX");
            if (folder == null)
            {
                throw new FolderNotFoundException("INBOX", null);
            }

            folder.open(Folder.READ_ONLY);
            Message[] msgs = getMessages(true);

            // put messages into a query table
            EmailTable table = new EmailTable();
            table.populate(folder, fields, msgs, attach_path, unique_filenames, accept);
            return table;
        }
        finally
        {
            if (folder != null)
            {
                folder.close(false);
            }
        }
    }

    /**
     * Mark messages seen as specified by the previous executed statements
     * 
     * @throws MessagingException
     */
    public void markRead() throws MessagingException
    {
        try
        {
        folder = folder.getFolder("INBOX");
        if (folder == null)
        {
            throw new FolderNotFoundException("INBOX", null);
        }
       
        folder.open(Folder.READ_WRITE);
        Message[] msgs = getMessages(false);
        folder.setFlags(msgs, new Flags(Flags.Flag.SEEN), true);
        }
        finally
        {
            if (folder != null)
            {
                folder.close(true);
            }
        }
    }

    /**
     * Deletes messages as specified by the previous executed statements
     *
     * @throws MessagingException
     */
    public void deleteMails() throws MessagingException
    {
        // CW: maybe it's a good idea to return the update count...
        try
        {
            folder = folder.getFolder("INBOX");
            if (folder == null)
            {
                throw new FolderNotFoundException("INBOX", null);
            }

            folder.open(Folder.READ_WRITE);
            Message[] msgs = getMessages(false);
            folder.setFlags( msgs, new Flags(Flags.Flag.DELETED), true);
        }
        finally
        {
            if (folder != null)
            {
                folder.close(true);
            }
        }
    }

    /**
     * Return an array of messages that we should process
     *
     * @throws MessagingException
     */
    private Message[] getMessages(boolean isGet) throws MessagingException
    {
        Message[] msgs;
        int count = folder.getMessageCount();

        if (count == 0)
            return new Message[0];

        // if we have message numbers, use them
        if (msgnums != null)
        {
            // populate message number search Term
            SearchTerm searchTerm = null;
            for (int i = 0; i < msgnums.length; i++)
            {
                try
                {
                    Integer num = Integer.valueOf(msgnums[i]);
                    if (num.intValue() > 0 && num.intValue() <= count)
                    {
                        if (searchTerm == null)
                        {
                            searchTerm = new MessageNumberTerm(num);
                        }
                        else
                        {
                            searchTerm = new OrTerm(searchTerm, new MessageNumberTerm(num));
                        }
                    }
                }
                catch (NumberFormatException e)
                {
                    // ignore, and skip this value
                }
            }

            // get specified messages
            if(searchTerm != null)
                msgs = folder.search(searchTerm);
            else
                msgs = new Message[0];

        }
        // If we have a list of uids, use them
        else if (uids != null)
        {
            msgs = folder.getMessages();
        }
        else if (searchTerm != null)
        {
            // get specified messages
            msgs = folder.search(searchTerm);
        }
        else // use limits if no uids either
        {
            if (startmsg > count)
                throw new ArrayIndexOutOfBoundsException(Integer.toString(count));
            int end = startmsg + (maxrows - 1);
            if (end > count) end = count;
            msgs = folder.getMessages(startmsg, end);
        }

        // pre-fetch UID entries if uids specified or doing any Get
        if (isGet || uids != null)
        {
            FetchProfile fp = new FetchProfile();
            fp.add(UIDFolder.FetchProfileItem.UID);
            folder.fetch(msgs, fp);
        }

        // If we are getting messages by uid, search through our
        // messages and keep only the ones that match
        if (uids != null && msgnums == null)
        {
            POP3Folder pf = (POP3Folder) folder;
            ArrayList<Message> newMsgs = new ArrayList<Message>();
            for (int i = 0; i < uids.length; i++)
            {
                String uid = uids[i];
                for (int j = 0; j < msgs.length; j++)
                {
                    Message message = msgs[j];
                    String mUID = pf.getUID(message);
                    if (uid.equals(mUID))
                    {   // we want this message
                        newMsgs.add(message);
                        break;
                    }
                }
            }
            msgs = (Message[]) newMsgs.toArray(new Message[0]);
        }
        return msgs;
    }

    public void setUseSSL(boolean useSSL)
    {
        this.useSSL  = useSSL;
        
    }

}

