/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sqs;

import coldfusion.cloud.aws.sqs.SQSAPIException;
import coldfusion.cloud.aws.sqs.SQSClient;
import coldfusion.cloud.aws.sqs.SQSQueue;
import coldfusion.log.Logger;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class SQSQueueImpl
implements SQSQueue,
ObjectHandledInvokable,
NamedInvokable {
    SQSClient sqsClient;
    String queueUrl;
    String queueArn;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.sqs");
    private static InvokeNamedMethodInvocationMap<SQSQueueImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public SQSQueueImpl(SQSClient sqsQueueClient, String queueueUrl) {
        this.sqsClient = sqsQueueClient;
        this.queueUrl = queueueUrl;
    }

    @Override
    public Struct sendMessage(Map message) {
        return this.sqsClient.sendMessage(this.queueUrl, message);
    }

    @Override
    public Struct sendMessageBatch(List<Map> messages) {
        return this.sqsClient.sendMessageBatch(this.queueUrl, messages);
    }

    @Override
    public Struct receiveMessage(Map receiveMessageOptions) {
        return this.sqsClient.receiveMessage(this.queueUrl, receiveMessageOptions);
    }

    @Override
    public Struct purge() {
        return this.sqsClient.purgeQueue(this.queueUrl);
    }

    @Override
    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    @Override
    public Struct deleteMessage(Map message) {
        return this.sqsClient.deleteMessage(this.queueUrl, message);
    }

    @Override
    public Struct deleteMessageBatch(List<Map> messages) {
        return this.sqsClient.deleteMessageBatch(this.queueUrl, messages);
    }

    @Override
    public Struct tag(Map tags) {
        return this.sqsClient.tagQueue(this.queueUrl, tags);
    }

    @Override
    public Struct untag(Map tags) {
        return this.sqsClient.untagQueue(this.queueUrl, tags);
    }

    @Override
    public Struct listQueueTags() {
        return this.sqsClient.listQueueTags(this.queueUrl);
    }

    @Override
    public Struct changeMessageVisibility(Map message) {
        return this.sqsClient.changeMessageVisibility(this.queueUrl, message);
    }

    @Override
    public Struct changeMessageVisibilityBatch(List<Map> messages) {
        return this.sqsClient.changeMessageVisibilityBatch(this.queueUrl, messages);
    }

    @Override
    public Struct setAttributes(Map attributes) {
        return this.sqsClient.setQueueAttributes(this.queueUrl, attributes);
    }

    @Override
    public Struct getAttributes(Map attributes) {
        return this.sqsClient.getQueueAttributes(this.queueUrl, attributes);
    }

    @Override
    public Struct listDeadLetterSourceQueues() {
        return this.sqsClient.listDeadLetterSourceQueues(this.queueUrl);
    }

    @Override
    public Struct editTags(Map tags) {
        return this.sqsClient.editTags(this.queueUrl, tags);
    }

    @Override
    public Struct addPermission(Map permission) {
        return this.sqsClient.addPermission(this.queueUrl, permission);
    }

    @Override
    public Struct removePermission(String permissionLabel) {
        return this.sqsClient.removePermission(this.queueUrl, permissionLabel);
    }

    @Override
    public String getQueueArn() {
        if (this.queueArn == null) {
            this.queueArn = this.sqsClient.getQueueArn(this.queueUrl);
        }
        return this.queueArn;
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "sendmessage": {
                if (args != null && args.length == 1) {
                    return this.sendMessage(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueSendMessageValidationError"));
            }
            case "sendmessagebatch": {
                if (args != null && args.length == 1) {
                    return this.sendMessageBatch(Cast._List((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueSendMessageBatchValidationError"));
            }
            case "receivemessage": {
                if (args != null && args.length == 1) {
                    return this.receiveMessage(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueReceiveMessageValidationError"));
            }
            case "addpermission": {
                if (args != null && args.length == 1) {
                    return this.addPermission(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueAddPermissionValidationError"));
            }
            case "removepermission": {
                if (args != null && args.length == 1) {
                    return this.removePermission(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueRemovePermissionValidationError"));
            }
            case "purge": {
                if (args == null || args.length == 0) {
                    return this.purge();
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueuePurgeValidationError"));
            }
            case "getqueueurl": {
                if (args == null || args.length == 0) {
                    return this.getQueueUrl();
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueGetQueueUrlValidationError"));
            }
            case "getqueuearn": {
                if (args == null || args.length == 0) {
                    return this.getQueueArn();
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueGetQueueArnValidationError"));
            }
            case "deletemessage": {
                if (args != null && args.length == 1) {
                    return this.deleteMessage(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueDeleteMessageValidationError"));
            }
            case "deletemessagebatch": {
                if (args != null && args.length == 1) {
                    return this.deleteMessageBatch(Cast._List((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueDeleteMessageBatchValidationError"));
            }
            case "tag": {
                if (args != null && args.length == 1) {
                    return this.tag(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueTagValidationError"));
            }
            case "untag": {
                if (args != null && args.length == 1) {
                    return this.untag(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueUntagValidationError"));
            }
            case "listqueuetags": {
                if (args == null || args.length == 0) {
                    return this.listQueueTags();
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueListTagsValidationError"));
            }
            case "changemessagevisibility": {
                if (args != null && args.length == 1) {
                    return this.changeMessageVisibility(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueChangeMessageVisibilityValidationError"));
            }
            case "changemessagevisibilitybatch": {
                if (args != null && args.length == 1) {
                    return this.changeMessageVisibilityBatch(Cast._List((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueChangeMessageVisibilityBatchValidationError"));
            }
            case "getattributes": {
                if (args != null && args.length == 1) {
                    return this.getAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueGetAttributesValidationError"));
            }
            case "setattributes": {
                if (args != null && args.length == 1) {
                    return this.setAttributes(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueSetAttributesValidationError"));
            }
            case "listdeadlettersourcequeues": {
                if (args == null || args.length == 0) {
                    return this.listDeadLetterSourceQueues();
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueListDeadletterQueuesValidationError"));
            }
            case "edittags": {
                if (args != null && args.length == 1) {
                    return this.editTags(Cast._Map((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSQueueImpl.class, (String)"QueueEditTagsValidationError"));
            }
        }
        Object val = super.invoke(methodName, args, pageContext);
        if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
            return val;
        }
        throw new SQSAPIException(RB.getString(SQSQueueImpl.class, (String)"MethodNotDefinedError", (Object)methodName));
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("sqs service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("sqs service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.sendMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messages"}, args);
                    return obj.sendMessageBatch(Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"receiveMessageOptions"}, args);
                    return obj.receiveMessage(Cast._Map((Object)argColl.get((Object)"receiveMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"purge", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.purge();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("purge", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueUrl", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getQueueUrl();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueUrl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setQueueUrl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    obj.setQueueUrl(Cast._String((Object)argColl.get((Object)"queueUrl")));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setQueueUrl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.deleteMessage(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messages"}, args);
                    return obj.deleteMessageBatch(Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"tag", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"tags"}, args);
                    return obj.tag(Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("tag", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"untag", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"tags"}, args);
                    return obj.untag(Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("untag", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listQueueTags", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listQueueTags();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listQueueTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeMessageVisibility", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"message"}, args);
                    return obj.changeMessageVisibility(Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeMessageVisibility", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeMessageVisibilityBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"messages"}, args);
                    return obj.changeMessageVisibilityBatch(Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeMessageVisibilityBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"attributes"}, args);
                    return obj.setAttributes(Cast._Map((Object)argColl.get((Object)"attributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"attributes"}, args);
                    return obj.getAttributes(Cast._Map((Object)argColl.get((Object)"attributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDeadLetterSourceQueues", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listDeadLetterSourceQueues();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDeadLetterSourceQueues", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"editTags", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"tags"}, args);
                    return obj.editTags(Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("editTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addPermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"permission"}, args);
                    return obj.addPermission(Cast._Map((Object)argColl.get((Object)"permission")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addPermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removePermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"permissionLabel"}, args);
                    return obj.removePermission(Cast._String((Object)argColl.get((Object)"permissionLabel")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removePermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueArn", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getQueueArn();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueArn", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

