/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.protocol;

import coldfusion.log.CFLogs;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;

public class ResponsePacketWriter {
    private static final int MAX_2BYTES_PAYLOAD_LEN = 65535;

    public static Object writeHybi_text(Channel channel, WebSocketFrame dataFrame) {
        CFLogs.WEBSOCKET_LOG.info((Object)"ResponsePacketWriter: writting response data as per Hybi specification.");
        byte[] headerBytes = new byte[2];
        headerBytes[0] = -127;
        ChannelBuffer buffer = dataFrame.getBinaryData();
        int payLoadLength = buffer.readableBytes();
        boolean payLoadByte = false;
        if (payLoadLength < 126) {
            headerBytes[1] = (byte)payLoadLength;
        } else if (payLoadLength <= 65535) {
            headerBytes[1] = 126;
            int buffSize = headerBytes.length;
            headerBytes = ResponsePacketWriter.arrayCopy(headerBytes, buffSize + 2);
            headerBytes[2] = (byte)(payLoadLength >> 8 & 0xFF);
            headerBytes[3] = (byte)(payLoadLength & 0xFF);
        } else {
            headerBytes[1] = 127;
            long length = payLoadLength;
            int buffSize = headerBytes.length;
            headerBytes = ResponsePacketWriter.arrayCopy(headerBytes, buffSize + 8);
            headerBytes[buffSize] = (byte)(length >>> 56);
            headerBytes[buffSize + 1] = (byte)(length >>> 48);
            headerBytes[buffSize + 2] = (byte)(length >>> 40);
            headerBytes[buffSize + 3] = (byte)(length >>> 32);
            headerBytes[buffSize + 4] = (byte)(length >>> 24);
            headerBytes[buffSize + 5] = (byte)(length >>> 16);
            headerBytes[buffSize + 6] = (byte)(length >>> 8);
            headerBytes[buffSize + 7] = (byte)length;
        }
        ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(buffer.order(), buffer.readableBytes() + headerBytes.length);
        encoded.writeBytes(headerBytes);
        encoded.writeBytes(buffer, buffer.readerIndex(), buffer.readableBytes());
        return encoded;
    }

    public static Object writeHixie_text(Channel channel, WebSocketFrame dataFrame) {
        ChannelBuffer data = dataFrame.getBinaryData();
        int type = dataFrame.getType();
        ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), data.readableBytes() + 2);
        encoded.writeByte((int)((byte)type));
        encoded.writeBytes(data, data.readerIndex(), data.readableBytes());
        encoded.writeByte(-1);
        return encoded;
    }

    public static Object writeHixie_binary(Channel channel, WebSocketFrame dataFrame) {
        CFLogs.WEBSOCKET_LOG.info((Object)"ResponsePacketWriter: writting response data as per Hixie specification.");
        ChannelBuffer data = dataFrame.getBinaryData();
        int type = dataFrame.getType();
        int dataLen = data.readableBytes();
        ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), dataLen + 5);
        encoded.writeByte((int)((byte)type));
        int b1 = dataLen >>> 28 & 0x7F;
        int b2 = dataLen >>> 14 & 0x7F;
        int b3 = dataLen >>> 7 & 0x7F;
        int b4 = dataLen & 0x7F;
        if (b1 == 0) {
            if (b2 == 0) {
                if (b3 == 0) {
                    encoded.writeByte(b4);
                } else {
                    encoded.writeByte(b3 | 0x80);
                    encoded.writeByte(b4);
                }
            } else {
                encoded.writeByte(b2 | 0x80);
                encoded.writeByte(b3 | 0x80);
                encoded.writeByte(b4);
            }
        } else {
            encoded.writeByte(b1 | 0x80);
            encoded.writeByte(b2 | 0x80);
            encoded.writeByte(b3 | 0x80);
            encoded.writeByte(b4);
        }
        encoded.writeBytes(data, data.readerIndex(), dataLen);
        return encoded;
    }

    private static byte[] arrayCopy(byte[] src, int newLength) {
        byte[] lCopy = new byte[newLength];
        System.arraycopy(src, 0, lCopy, 0, Math.min(src.length, newLength));
        return lCopy;
    }
}

