/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.log.CFLogs;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.HttpTaskHeader;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.tagext.net.websocket.server.netty.WebSocketFrameDecoder;
import coldfusion.tagext.net.websocket.server.netty.WebSocketFrameEncoder;
import coldfusion.tagext.net.websocket.server.protocol.HandShakeProcessor;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.UpstreamChannelStateEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.util.CharsetUtil;

public class MessageHandler
extends SimpleChannelUpstreamHandler {
    private WebSocketService webSocketService = ServiceFactory.getWebsocketService();
    private AbstractClientConnection clientConnection = null;
    private ChannelHandlerContext channelHandlerContext = null;
    private static Logger exceptionLogger = Logger.getLogger(MessageHandler.class);
    private int spec_version = -1;
    public static final HttpResponseStatus PROTOCOLERROR = new HttpResponseStatus(403, "Protocol Error");

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent event) throws Exception {
        this.channelHandlerContext = context;
        super.handleUpstream(context, event);
    }

    public void exceptionCaught(ChannelHandlerContext context, ExceptionEvent event) throws Exception {
        this.channelHandlerContext = context;
        event.getCause().printStackTrace();
        CFLogs.WEBSOCKET_LOG.info((Object)"Connection closed as an exception occurred.");
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        if (this.clientConnection == null) {
            return;
        }
        WSTaskProcessor.getTaskProcessor().connectionClosed(this.clientConnection);
        ClientConnectionManager.removeClientConnection(this.clientConnection.getConnectionId());
        super.channelDisconnected(ctx, event);
        CFLogs.WEBSOCKET_LOG.info((Object)"Connection is being disconnected.");
    }

    public void messageReceived(ChannelHandlerContext context, MessageEvent event) throws Exception {
        try {
            this.channelHandlerContext = context;
            CFLogs.WEBSOCKET_LOG.info((Object)"message received from client");
            if (event.getMessage() instanceof HttpRequest) {
                CFLogs.WEBSOCKET_LOG.info((Object)"request for new connection. Starting Handshaking process");
                this.processWelcomeRequest(context, (HttpRequest)event.getMessage());
                context.getChannel().getConfig().setConnectTimeoutMillis(this.webSocketService.getSocketTimeOut() * 1000);
            } else if (event.getMessage() instanceof WebSocketFrame) {
                if (((WebSocketFrame)event.getMessage()).getType() == 8 && this.spec_version > 3) {
                    UpstreamChannelStateEvent closeEvent = new UpstreamChannelStateEvent(event.getChannel(), ChannelState.CONNECTED, null);
                    this.channelDisconnected(context, (ChannelStateEvent)closeEvent);
                    return;
                }
                CFLogs.WEBSOCKET_LOG.info((Object)"websocket request from the client. Request processing is started");
                this.processWebSocketRequest(context, (WebSocketFrame)event.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processWelcomeRequest(ChannelHandlerContext context, HttpRequest requestMessage) {
        if (requestMessage.getMethod() != HttpMethod.GET || !"WebSocket".equalsIgnoreCase(requestMessage.getHeader("Upgrade"))) {
            this.sendForbiddenWelcomeResponse(context);
        }
        HttpResponse handshakeResponse = null;
        this.spec_version = this.parseVersion(requestMessage);
        try {
            handshakeResponse = HandShakeProcessor.generateHandShakeResponse(context, requestMessage, this.spec_version);
        }
        catch (NoSuchAlgorithmException e) {
            exceptionLogger.error((Object)"Error while procesing welcome request", (Throwable)e);
            e.printStackTrace();
            context.getChannel().close();
            return;
        }
        context.getChannel().write((Object)handshakeResponse);
        CFLogs.WEBSOCKET_LOG.info((Object)"Handshake response is sent back to client.");
        ChannelPipeline channelPipeline = context.getChannel().getPipeline();
        channelPipeline.remove("aggregator");
        channelPipeline.replace("decoder", "cfdecoder", (ChannelHandler)new WebSocketFrameDecoder(this.webSocketService.getMaxFrameSize() * 1024, this.spec_version));
        channelPipeline.replace("encoder", "cfencoder", (ChannelHandler)new WebSocketFrameEncoder(this.spec_version));
        this.initClientConnection(context, requestMessage);
    }

    private void processWebSocketRequest(ChannelHandlerContext context, WebSocketFrame packetData) {
        if (packetData.isText()) {
            WSTaskProcessor.getTaskProcessor().processWebSocketRequest(this.clientConnection, packetData.getTextData());
        } else {
            CFLogs.WEBSOCKET_LOG.info((Object)"Does not support other data type..");
        }
    }

    private void sendForbiddenWelcomeResponse(ChannelHandlerContext context) {
        DefaultHttpResponse errorResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
        errorResponse.setContent(ChannelBuffers.copiedBuffer((CharSequence)HttpResponseStatus.FORBIDDEN.toString(), (Charset)CharsetUtil.UTF_8));
        errorResponse.setHeader("Content-Length", (Object)errorResponse.getContent().readable());
        ChannelFuture channelFuture = context.getChannel().write((Object)errorResponse);
        channelFuture.addListener(ChannelFutureListener.CLOSE);
    }

    private void initClientConnection(ChannelHandlerContext context, HttpRequest requestMessage) {
        HttpTaskHeader headers = new HttpTaskHeader();
        this.clientConnection = new ClientConnection(context, headers);
        ClientConnectionManager.addClientConnection(this.clientConnection);
        String lSubProt = requestMessage.getHeader("Sec-WebSocket-Protocol");
        headers.put("origin", requestMessage.getHeader("origin"));
        String location = "ws://" + requestMessage.getHeader("Host") + requestMessage.getUri();
        headers.put("location", location);
        headers.put("path", requestMessage.getUri());
        headers.put("subprot", lSubProt);
        headers.put("host", requestMessage.getHeader("host"));
        this.clientConnection.setRequestHeader(headers);
    }

    private int parseVersion(HttpRequest httpRequest) {
        int version = -1;
        String str_version = httpRequest.getHeader("Sec-WebSocket-Version");
        if (str_version == null) {
            str_version = httpRequest.getHeader("Sec-WebSocket-Draft");
        }
        if (str_version != null) {
            try {
                return Integer.parseInt(str_version);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }
}

