/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.core;

import coldfusion.runtime.OleDateTime;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.HttpTaskHeader;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;

public class ClientConnection
extends AbstractClientConnection {
    private ChannelHandlerContext channelHandlerContext;

    public ClientConnection(ChannelHandlerContext context, HttpTaskHeader header) {
        this.channelHandlerContext = context;
        this.requestHeader = header;
        this.requestHeader = header;
        context.getChannel().getConfig().setConnectTimeoutMillis(ServiceFactory.getWebsocketService().getSocketTimeOut() * 1000);
        this.connectionTime = new OleDateTime(System.currentTimeMillis());
        this.setConnectionId(context);
        this.populateConnectionInfo();
    }

    @Override
    public void writeData(Object aDataPacket) {
        if (this.channelHandlerContext.getChannel().isConnected()) {
            this.channelHandlerContext.getChannel().write((Object)new DefaultWebSocketFrame(aDataPacket.toString()));
        }
    }

    @Override
    public Object writeDataAsync(Object aDataPacket) {
        if (this.channelHandlerContext.getChannel().isConnected()) {
            ChannelFuture internalFuture = this.channelHandlerContext.getChannel().write((Object)new DefaultWebSocketFrame(aDataPacket.toString()));
            return null;
        }
        return null;
    }

    @Override
    public void setConnectionId(Object context) {
        ChannelHandlerContext handleContext = (ChannelHandlerContext)context;
        InetSocketAddress address = (InetSocketAddress)handleContext.getChannel().getRemoteAddress();
        this.connectionId = address.getHostName() + address.getPort() + "";
        this.connectionId = this.connectionId.hashCode() + "";
        if (this.connectionId.charAt(0) == '-') {
            this.connectionId = this.connectionId.substring(1);
        }
    }
}

