/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RequestScope;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.messaging.Channel;
import coldfusion.tagext.net.websocket.messaging.ChannelException;
import coldfusion.tagext.net.websocket.messaging.ChannelManager;
import coldfusion.tagext.net.websocket.messaging.ChannelRequestHeader;
import coldfusion.tagext.net.websocket.messaging.ChannelUtil;
import coldfusion.tagext.net.websocket.messaging.Subscriber;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.TokenMap;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebSocketUtil {
    private static ThreadLocal contextThreadLocal = new ThreadLocal();
    private static WebSocketService webSocketService = ServiceFactory.getWebsocketService();

    public static List getAllChannels(String appName) {
        ChannelManager mChannelManeger = ChannelManager.getInstance(appName);
        return new ArrayList<String>(mChannelManeger.getChannelMap().keySet());
    }

    public static List getAllChannels(String appName, String channelName) {
        return WebSocketUtil.getAllChannels(appName, channelName, false);
    }

    public static List getAllChannels(String appName, String channelName, boolean clustered) {
        List remoteResultsList;
        Channel mChannel = WebSocketUtil.getChannel(appName, channelName);
        if (mChannel == null) {
            throw new ChannelNotFoundException(channelName);
        }
        List<String> channels = mChannel.getAllSubChannels();
        if (clustered && webSocketService.isEnterpriseClusterEnabled() && (remoteResultsList = WebSocketClusterManager.getInstance().delegateGetChannels(appName, channelName)) != null) {
            channels.addAll(remoteResultsList);
        }
        return channels;
    }

    public static WebSocketContext getWSThreadContext() {
        return (WebSocketContext)contextThreadLocal.get();
    }

    public static WebSocketContext createWSThreadContext() {
        WebSocketContext context = new WebSocketContext();
        contextThreadLocal.set(context);
        return context;
    }

    public static void clearWSThreadContext() {
        contextThreadLocal.remove();
    }

    public static List getAllClients(String appName, String achannel) {
        return WebSocketUtil.getAllClients(appName, achannel, false);
    }

    public static List getAllClients(String appName, String achannel, boolean clustered) {
        List remoteResultsList;
        ArrayList<Struct> lSubscribers = new ArrayList<Struct>();
        Channel mChannel = WebSocketUtil.getChannel(appName, achannel);
        if (mChannel == null) {
            return lSubscribers;
        }
        List<Subscriber> lChannelSubscribers = mChannel.getSubscribers();
        if (null != lChannelSubscribers) {
            for (Subscriber lSubscriber : lChannelSubscribers) {
                if (lSubscriber == null) continue;
                Struct lItem = new Struct();
                String clientId = lSubscriber.getId();
                lItem.put((Object)"clientid", (Object)clientId);
                Struct subscriberInfo = mChannel.getSubscriberInfo(lSubscriber).getCustomOptionMap();
                lItem.put((Object)"subscriberinfo", (Object)subscriberInfo);
                lSubscribers.add(lItem);
            }
        }
        if (clustered && webSocketService.isEnterpriseClusterEnabled() && (remoteResultsList = WebSocketClusterManager.getInstance().delegateGetClients(appName, achannel)) != null) {
            lSubscribers.addAll(remoteResultsList);
        }
        return lSubscribers;
    }

    public static int getSubscriberCount(String appName, String achannel, boolean clustered) {
        Channel mChannel = WebSocketUtil.getChannel(appName, achannel);
        int subsCount = 0;
        if (mChannel == null) {
            return subsCount;
        }
        List<Subscriber> lChannelSubscribers = mChannel.getSubscribers();
        if (lChannelSubscribers != null) {
            subsCount = lChannelSubscribers.size();
        }
        if (clustered && webSocketService.isEnterpriseClusterEnabled()) {
            int remoteSusbcriberCount = WebSocketClusterManager.getInstance().delegateGetSubscriberCount(appName, achannel);
            subsCount += remoteSusbcriberCount;
        }
        return subsCount;
    }

    private static Channel getChannel(String appName, String channel) {
        ChannelManager mChannelManeger = ChannelManager.getInstance(appName);
        return mChannelManeger.getChannel(channel);
    }

    public static List getAllClients(String appName) {
        List mChannelList = WebSocketUtil.getAllChannels(appName);
        ArrayList lSubscriber = new ArrayList();
        for (Object mChannel : mChannelList) {
            lSubscriber.addAll(WebSocketUtil.getAllClients(appName, (String)mChannel));
        }
        return lSubscriber;
    }

    public static List getClients(String appName, String channelName) {
        return WebSocketUtil.getAllClients(appName, channelName, webSocketService.isEnterpriseClusterEnabled());
    }

    public static void sendMessage(String clientId, Object message) {
        if (clientId == null) {
            throw new ClientNotConnectedException();
        }
        Map clientMap = ClientConnectionManager.getConnections();
        AbstractClientConnection lConnector = (AbstractClientConnection)clientMap.get(clientId);
        if (lConnector == null) {
            throw new ClientNotConnectedException();
        }
        TokenMap lResToken = new TokenMap("data");
        String messageStr = WebSocketUtil.serializeMessage(message);
        lResToken.setString("data", messageStr);
        lResToken.setType("data");
        lResToken.setString("ns", "coldfusion.websocket.channels");
        WSTaskProcessor.getTaskProcessor();
        WSTaskProcessor.sendToken(lConnector, lResToken);
    }

    public static void publishMessage(String appName, String channel, Object message) {
        WebSocketUtil.publishMessage(appName, channel, message, null);
    }

    public static void publishMessage(String appName, String channel, Object message, Map filterCriteria) {
        WebSocketUtil.publishMessage(appName, channel, message, filterCriteria, true);
    }

    public static void publishMessage(String appName, String channel, Object message, Map filterCriteria, boolean isClustered) {
        ChannelManager mChannelManager = ChannelManager.getInstance(appName);
        Channel mChannel = mChannelManager.getChannel(channel, true);
        ChannelRequestHeader mPublisherReqHeader = ChannelUtil.parseRequestHeader(channel, filterCriteria);
        if (mChannel == null) {
            throw new ChannelNotFoundForPublishException(channel);
        }
        TokenMap lResToken = new TokenMap("data");
        String messageStr = WebSocketUtil.serializeMessage(message);
        lResToken.setString("data", messageStr);
        lResToken.setType("data");
        FusionContext fusionContext = FusionContext.getCurrent();
        HttpServletRequest oldRequest = fusionContext.getRequest();
        NeoPageContext oldPageContext = fusionContext.pageContext;
        Scope hiddenScope = fusionContext.hiddenScope;
        try {
            mChannel.broadcastToken(null, lResToken, mPublisherReqHeader, isClustered);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString(WebSocketUtil.class, (String)"MessageBroadcastError", (Object)e.getMessage()), e);
        }
        finally {
            fusionContext.setServletObjects(fusionContext.getServlet(), (ServletRequest)oldRequest, (ServletResponse)fusionContext.getResponse());
            fusionContext.pageContext = oldPageContext;
            fusionContext.hiddenScope = hiddenScope;
            fusionContext.hiddenScope.putCanonicalKey((Object)"REQUEST", (Object)new RequestScope(oldRequest));
        }
    }

    public static void publishMessage_Remote(String appName, String channel, Object message, Map filterCriteria, boolean isClustered) {
        ChannelManager mChannelManager = ChannelManager.getInstance(appName);
        Channel mChannel = mChannelManager.getChannel(channel, false, true);
        ChannelRequestHeader mPublisherReqHeader = ChannelUtil.parseRequestHeader(channel, filterCriteria);
        if (mChannel == null) {
            throw new ChannelNotFoundForPublishException(channel);
        }
        TokenMap lResToken = new TokenMap("data");
        String messageStr = WebSocketUtil.serializeMessage(message);
        lResToken.setString("data", messageStr);
        lResToken.setType("data");
        try {
            mChannel.broadcastToken(null, lResToken, mPublisherReqHeader, isClustered);
        }
        catch (Throwable e) {
            throw new ChannelException(RB.getString(WebSocketUtil.class, (String)"MessageBroadcastError", (Object)e.getMessage()), e);
        }
    }

    public static String serializeMessage(Object aMessage) {
        String sMessage = "";
        if (aMessage instanceof String) {
            sMessage = (String)aMessage;
        } else {
            try {
                sMessage = JSONUtils.serializeJSON((Object)aMessage);
            }
            catch (Throwable e) {
                throw new ChannelException(RB.getString(WebSocketUtil.class, (String)"MessageSerializationError"), e);
            }
        }
        return sMessage;
    }

    public static class ChannelNotFoundForPublishException
    extends ApplicationException {
        public String channelName;

        public ChannelNotFoundForPublishException(String aChannelName) {
            this.channelName = aChannelName;
        }
    }

    public static class ChannelNotFoundException
    extends ApplicationException {
        public String channelName;

        public ChannelNotFoundException(String aChannelName) {
            this.channelName = aChannelName;
        }
    }

    public static class ClientNotConnectedException
    extends ApplicationException {
    }

    public static class WebSocketContext {
        private String webRootPath;
        private String baseTemplatePath;

        public String getWebRootPath() {
            return this.webRootPath;
        }

        public void setWebRootPath(String webRootPath) {
            this.webRootPath = webRootPath;
        }

        public String getBaseTemplatePath() {
            return this.baseTemplatePath;
        }

        public void setBaseTemplatePath(String baseTemplatePath) {
            this.baseTemplatePath = baseTemplatePath;
        }
    }
}

