/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml.util;

import coldfusion.saml.util.Utils;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Constants;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SignatureCreator {
    private static DocumentBuilderFactory dbf = Utils.createDocumentFactory();
    private static TransformerFactory tf = TransformerFactory.newInstance();

    public String signRequest(String requestXml, Saml2Settings settings, String id) throws Throwable {
        requestXml.replaceAll("(?:>)(\\s*)<", "><");
        XMLSignatureFactory xmlSigFactory = XMLSignatureFactory.getInstance("DOM");
        PrivateKey privateKey = settings.getSPkey();
        if (privateKey == null) {
            throw new Exception("Service Provider Private key is missing. Signature cannot be generated without it");
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(requestXml)));
        SignatureCreator.trimValues(doc.getDocumentElement());
        DOMSignContext domSignCtx = new DOMSignContext(privateKey, (Node)doc.getDocumentElement());
        domSignCtx.setIdAttributeNS(doc.getDocumentElement(), null, "ID");
        domSignCtx.setDefaultNamespacePrefix("ds");
        Reference ref = null;
        SignedInfo signedInfo = null;
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        transformList.add(xmlSigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transformList.add(xmlSigFactory.newTransform(Constants.C14NEXC, (TransformParameterSpec)null));
        try {
            ref = xmlSigFactory.newReference("#" + id, xmlSigFactory.newDigestMethod(settings.getDigestAlgorithm(), null), transformList, null, null);
            SignatureMethod signatureMethod = xmlSigFactory.newSignatureMethod(settings.getSignatureAlgorithm(), null);
            signedInfo = xmlSigFactory.newSignedInfo(xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), signatureMethod, Collections.singletonList(ref));
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw ex;
        }
        KeyInfo keyInfo = SignatureCreator.getKeyInfo(settings);
        XMLSignature xmlSignature = xmlSigFactory.newXMLSignature(signedInfo, keyInfo);
        try {
            xmlSignature.sign(domSignCtx);
        }
        catch (MarshalException ex) {
            throw ex;
        }
        catch (XMLSignatureException ex) {
            throw ex;
        }
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString().replaceAll("&#13;", "");
        return output;
    }

    private static KeyInfo getKeyInfo(Saml2Settings settings) throws CertificateEncodingException, IOException {
        X509Certificate cert = settings.getSPcert();
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance();
        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
        x509Content.add(cert);
        X509Data x509Data = keyInfoFactory.newX509Data(x509Content);
        return keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
    }

    private static void trimValues(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String textContent = currentNode.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            currentNode.setTextContent(textContent);
        }
    }
}

