/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDoubleAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleCountIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleSumIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;

public class JRDoubleIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Double ZERO = new Double(0.0);
    private static JRDoubleIncrementerFactory mainInstance = new JRDoubleIncrementerFactory();

    private JRDoubleIncrementerFactory() {
    }

    public static JRDoubleIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(byte calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRDoubleCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRDoubleSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRDoubleAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRDoubleStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRDoubleVarianceIncrementer.getInstance();
                break;
            }
            case 10: {
                incrementer = JRDoubleDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

