/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.s3.consumer.TaggingConsumer;
import coldfusion.s3.request.AbstractPutObjectRequest;
import coldfusion.wddx.Base64Encoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3.model.ObjectLockMode;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;

public abstract class AbstractUploadRequestConsumer<T extends AbstractPutObjectRequest>
extends ConsumerMap<T> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public AbstractUploadRequestConsumer() {
        this.put("acl", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().acl(ObjectCannedACL.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("cacheControl", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"cacheControl");
            uploadFileRequest.getPutObjectRequest().cacheControl(input);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentDisposition");
            uploadFileRequest.getPutObjectRequest().contentDisposition(input);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentEncoding");
            uploadFileRequest.getPutObjectRequest().contentEncoding(input);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentLanguage");
            uploadFileRequest.getPutObjectRequest().contentLanguage(input);
        }, Collections.emptyList()));
        this.put("contentLength", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().contentLength(this.cast.getLongProperty(value)), Collections.emptyList()));
        this.put("validateContentMD5", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.setValidateContentMD5(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentType");
            uploadFileRequest.getPutObjectRequest().contentType(input);
        }, Collections.emptyList()));
        this.put("expires", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().expires(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("grantFullControl", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantFullControl");
            uploadFileRequest.getPutObjectRequest().grantFullControl(input);
        }, Collections.emptyList()));
        this.put("grantRead", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantRead");
            uploadFileRequest.getPutObjectRequest().grantRead(input);
        }, Collections.emptyList()));
        this.put("grantReadACP", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantReadACP");
            uploadFileRequest.getPutObjectRequest().grantReadACP(input);
        }, Collections.emptyList()));
        this.put("grantWriteACP", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantWriteACP");
            uploadFileRequest.getPutObjectRequest().grantWriteACP(input);
        }, Collections.emptyList()));
        this.put("key", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            uploadFileRequest.getPutObjectRequest().key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("metadata", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().metadata(this.cast.getMapProperty(value)), Collections.emptyList()));
        this.put("serverSideEncryption", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().serverSideEncryption(ServerSideEncryption.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().storageClass(StorageClass.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("websiteRedirectLocation", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"websiteRedirectLocation");
            uploadFileRequest.getPutObjectRequest().websiteRedirectLocation(input);
        }, Collections.emptyList()));
        this.put("sseCustomerAlgorithm", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerAlgorithm");
            uploadFileRequest.getPutObjectRequest().sseCustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKey", new ConsumerValidator((uploadFileRequest, value) -> {
            String key = this.cast.getStringProperty(value);
            uploadFileRequest.getPutObjectRequest().sseCustomerKey(BinaryUtils.toBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
            uploadFileRequest.getPutObjectRequest().sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
        }, Collections.emptyList()));
        this.put("ssekmsKeyId", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ssekmsKeyId");
            uploadFileRequest.getPutObjectRequest().ssekmsKeyId(input);
        }, Collections.emptyList()));
        this.put("ssekmsEncryptionContext", new ConsumerValidator((uploadFileRequest, value) -> {
            if (value instanceof String) {
                String input = this.cast.getStringProperty(value);
                ValidationUtil.validNonBlankString((String)input, (String)"ssekmsEncryptionContext");
                uploadFileRequest.getPutObjectRequest().ssekmsEncryptionContext(input);
            } else {
                String base64Encoded;
                Map map = this.cast.getMapProperty(value);
                String serializeJSON = JSONUtils.serializeJSON((Object)map);
                if (serializeJSON != null && !FusionContext.getCurrent().pageContext.isUnderCFThread()) {
                    String responseEncoding = FusionContext.getCurrent().pageContext.getResponse().getCharacterEncoding();
                    base64Encoded = Base64Encoder.encode((byte[])CfJspPage._Binary((String)serializeJSON, (String)responseEncoding));
                } else {
                    base64Encoded = Base64Encoder.encode((byte[])Cast._Binary((Object)serializeJSON));
                }
                uploadFileRequest.getPutObjectRequest().ssekmsEncryptionContext(base64Encoded);
            }
        }, Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("tagging", new ConsumerValidator((uploadFileRequest, value) -> {
            List<Tag> tags = TaggingConsumer.getInstance().getTagsList(value);
            uploadFileRequest.getPutObjectRequest().tagging((Tagging)Tagging.builder().tagSet(tags).build());
        }, Collections.emptyList()));
        this.put("objectLockMode", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().objectLockMode(ObjectLockMode.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("objectLockRetainUntilDate", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().objectLockRetainUntilDate(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("objectLockLegalHoldStatus", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPutObjectRequest().objectLockLegalHoldStatus(ObjectLockLegalHoldStatus.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
    }
}

