/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.request;

import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.util.RB;
import com.google.cloud.storage.Storage;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;

public class BlobWriteOptionBuilder {
    private boolean crc32cMatch;
    private boolean detectContentType;
    private boolean disableGzipContent;
    private boolean doesNotExist;
    private Object encryptionKey;
    private boolean generationMatch;
    private boolean generationNotMatch;
    private String kmsKeyName;
    private boolean metagenerationMatch;
    private boolean metagenerationNotMatch;
    private String acl;
    private String userProject;
    List<Storage.BlobWriteOption> blobWriteOption = new ArrayList<Storage.BlobWriteOption>();

    public boolean isCrc32cMatch() {
        return this.crc32cMatch;
    }

    public void setCrc32cMatch(boolean crc32cMatch) {
        this.crc32cMatch = crc32cMatch;
        if (crc32cMatch) {
            this.blobWriteOption.add(Storage.BlobWriteOption.crc32cMatch());
        }
    }

    public boolean isDetectContentType() {
        return this.detectContentType;
    }

    public void setDetectContentType(boolean detectContentType) {
        this.detectContentType = detectContentType;
        if (detectContentType) {
            this.blobWriteOption.add(Storage.BlobWriteOption.detectContentType());
        }
    }

    public boolean isDisableGzipContent() {
        return this.disableGzipContent;
    }

    public void setDisableGzipContent(boolean disableGzipContent) {
        this.disableGzipContent = disableGzipContent;
        if (disableGzipContent) {
            this.blobWriteOption.add(Storage.BlobWriteOption.disableGzipContent());
        }
    }

    public boolean isDoesNotExist() {
        return this.doesNotExist;
    }

    public void setDoesNotExist(boolean doesNotExist) {
        this.doesNotExist = doesNotExist;
        if (doesNotExist) {
            this.blobWriteOption.add(Storage.BlobWriteOption.doesNotExist());
        }
    }

    public Object getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(Object encryptionKey) {
        if (encryptionKey instanceof String) {
            String key = FieldTypecastUtil.INSTANCE.getStringProperty(encryptionKey);
            this.blobWriteOption.add(Storage.BlobWriteOption.encryptionKey((String)key));
        } else if (encryptionKey instanceof Key) {
            this.blobWriteOption.add(Storage.BlobWriteOption.encryptionKey((Key)((Key)encryptionKey)));
        } else {
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_ENCRYPTION_KEY"));
        }
    }

    public boolean isGenerationMatch() {
        return this.generationMatch;
    }

    public void setGenerationMatch(boolean generationMatch) {
        this.generationMatch = generationMatch;
        if (generationMatch) {
            this.blobWriteOption.add(Storage.BlobWriteOption.generationMatch());
        }
    }

    public boolean isGenerationNotMatch() {
        return this.generationNotMatch;
    }

    public void setGenerationNotMatch(boolean generationNotMatch) {
        this.generationNotMatch = generationNotMatch;
        if (generationNotMatch) {
            this.blobWriteOption.add(Storage.BlobWriteOption.generationNotMatch());
        }
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public void setKmsKeyName(String kmsKeyName) {
        this.kmsKeyName = kmsKeyName;
        this.blobWriteOption.add(Storage.BlobWriteOption.kmsKeyName((String)kmsKeyName));
    }

    public boolean isMetagenerationMatch() {
        return this.metagenerationMatch;
    }

    public void setMetagenerationMatch(boolean metagenerationMatch) {
        this.metagenerationMatch = metagenerationMatch;
        if (metagenerationMatch) {
            this.blobWriteOption.add(Storage.BlobWriteOption.metagenerationMatch());
        }
    }

    public boolean isMetagenerationNotMatch() {
        return this.metagenerationNotMatch;
    }

    public void setMetagenerationNotMatch(boolean metagenerationNotMatch) {
        this.metagenerationNotMatch = metagenerationNotMatch;
        if (metagenerationNotMatch) {
            this.blobWriteOption.add(Storage.BlobWriteOption.metagenerationNotMatch());
        }
    }

    public String getAcl() {
        return this.acl;
    }

    public void setAcl(String acl) {
        this.acl = acl;
        this.blobWriteOption.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)Storage.PredefinedAcl.valueOf((String)acl)));
    }

    public String getUserProject() {
        return this.userProject;
    }

    public void setUserProject(String userProject) {
        this.userProject = userProject;
        this.blobWriteOption.add(Storage.BlobWriteOption.userProject((String)userProject));
    }

    public List<Storage.BlobWriteOption> getBlobWriteOption() {
        return this.blobWriteOption;
    }
}

