/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.IdentityRoleBuilder;
import coldfusion.gcp.storage.util.StorageUtils;
import coldfusion.util.RB;
import com.google.cloud.Identity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IdentityRoleConsumer
extends ConsumerMap<IdentityRoleBuilder> {
    private static final long serialVersionUID = -9077995796092623898L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static IdentityRoleConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdentityRoleConsumer getInstance() {
        if (instance != null) return instance;
        Class<IdentityRoleConsumer> clazz = IdentityRoleConsumer.class;
        synchronized (IdentityRoleConsumer.class) {
            instance = new IdentityRoleConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IdentityRoleConsumer() {
        this.put("role", new ConsumerValidator((builder, val) -> {
            String role = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)role, (String)"role");
            builder.setRole(StorageUtils.getRole(role));
        }, Collections.emptyList()));
        this.put("identity", new ConsumerValidator((builder, val) -> {
            List list = this.cast.getListProperty(val);
            ArrayList<Identity> identities = new ArrayList<Identity>();
            block18: for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj instanceof String) {
                    String type = (String)obj;
                    if (type.equalsIgnoreCase("allAuthenticatedUsers")) {
                        identities.add(Identity.allAuthenticatedUsers());
                        continue;
                    }
                    if (type.equalsIgnoreCase("allUsers")) {
                        identities.add(Identity.allUsers());
                        continue;
                    }
                    throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_IDENTITY_TYPE", (Object)type));
                }
                Map map = this.cast.getStringStringMapProperty(obj);
                String type = (String)map.keySet().iterator().next();
                String value = ((String)map.get(type)).trim();
                switch (type.trim()) {
                    case "domain": {
                        identities.add(Identity.domain((String)value));
                        continue block18;
                    }
                    case "group": {
                        identities.add(Identity.group((String)value));
                        continue block18;
                    }
                    case "projectEditor": {
                        identities.add(Identity.projectEditor((String)value));
                        continue block18;
                    }
                    case "projectOwner": {
                        identities.add(Identity.projectOwner((String)value));
                        continue block18;
                    }
                    case "projectViewer": {
                        identities.add(Identity.projectViewer((String)value));
                        continue block18;
                    }
                    case "serviceAccount": {
                        identities.add(Identity.serviceAccount((String)value));
                        continue block18;
                    }
                    case "user": {
                        identities.add(Identity.user((String)value));
                        continue block18;
                    }
                    default: {
                        throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_IDENTITY_TYPE", (Object)type));
                    }
                }
            }
            builder.setIdentity(identities);
        }, Collections.emptyList()));
    }
}

