/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.BlobIdBuilderConsumer;
import coldfusion.gcp.storage.request.BlobIdBuilder;
import coldfusion.gcp.storage.request.DeleteBlobRequest;
import java.util.Collections;
import java.util.Map;

public class DeleteBlobRequestConsumer
extends ConsumerMap<DeleteBlobRequest> {
    private static final long serialVersionUID = -7812201691863194879L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static DeleteBlobRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteBlobRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<DeleteBlobRequestConsumer> clazz = DeleteBlobRequestConsumer.class;
        synchronized (DeleteBlobRequestConsumer.class) {
            if (instance != null) return instance;
            instance = new DeleteBlobRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DeleteBlobRequestConsumer() {
        this.put("blobId", new ConsumerValidator((blobDeleteBuilder, val) -> {
            Map map = this.cast.getStringObjectMapProperty(val);
            BlobIdBuilder blobIdBuilder = new BlobIdBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)blobIdBuilder, map, (ConsumerMap)BlobIdBuilderConsumer.getInstance());
            blobDeleteBuilder.setBlobId(blobIdBuilder.getBlobId());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("generationMatch", new ConsumerValidator((blobdeleteBuilder, val) -> {
            Long generationMatch = this.cast.getLongProperty(val);
            blobdeleteBuilder.setGenerationMatch(generationMatch);
        }, Collections.emptyList()));
        this.put("generationNotMatch", new ConsumerValidator((blobdeleteBuilder, val) -> {
            Long generationNotMatch = this.cast.getLongProperty(val);
            blobdeleteBuilder.setGenerationNotMatch(generationNotMatch);
        }, Collections.emptyList()));
        this.put("metaGenerationMatch", new ConsumerValidator((blobdeleteBuilder, val) -> {
            Long metageneration = this.cast.getLongProperty(val);
            blobdeleteBuilder.setMetageneration(metageneration);
        }, Collections.emptyList()));
        this.put("metaGenerationNotMatch", new ConsumerValidator((blobdeleteBuilder, val) -> {
            Long metagenerationNotMatch = this.cast.getLongProperty(val);
            blobdeleteBuilder.setMetagenerationNotMatch(metagenerationNotMatch);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((blobdeleteBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            blobdeleteBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
    }
}

