/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.CreateHmacKeyOptionConsumer;
import coldfusion.gcp.storage.request.CreateHmacKeyBuilder;
import coldfusion.gcp.storage.request.CreateHmacKeyOptionBuilder;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CreateHmacKeyConsumer
extends ConsumerMap<CreateHmacKeyBuilder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static CreateHmacKeyConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CreateHmacKeyConsumer getInstance() {
        if (instance != null) return instance;
        Class<CreateHmacKeyConsumer> clazz = CreateHmacKeyConsumer.class;
        synchronized (CreateHmacKeyConsumer.class) {
            instance = new CreateHmacKeyConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CreateHmacKeyConsumer() {
        this.put("serviceAccountEmail", new ConsumerValidator((builder, val) -> {
            String serviceAccountEmail = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)serviceAccountEmail, (String)"serviceAccountEmail");
            builder.setServiceAccountEmail(serviceAccountEmail);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("createHmacKeyOption", new ConsumerValidator((builder, val) -> {
            List list = this.cast.getListProperty(val);
            ArrayList<Storage.CreateHmacKeyOption> option = new ArrayList<Storage.CreateHmacKeyOption>();
            for (int i = 0; i < list.size(); ++i) {
                Map map = this.cast.getStringStringMapProperty(list.get(i));
                CreateHmacKeyOptionBuilder createHmacKeyOptionBuilder = new CreateHmacKeyOptionBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)createHmacKeyOptionBuilder, map, (ConsumerMap)CreateHmacKeyOptionConsumer.getInstance());
                option.addAll(createHmacKeyOptionBuilder.getCreateHmacKeyOption());
            }
            builder.setOption(option);
        }, Collections.singletonList(new EmptyListValidator("createHmacKeyOption"))));
    }
}

