/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.gcp.storage.request.ListBlobRequest;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BlobListOptionConsumer
extends ConsumerMap<ListBlobRequest> {
    private static final long serialVersionUID = -2914396250044574079L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static BlobListOptionConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlobListOptionConsumer getInstance() {
        if (instance != null) return instance;
        Class<BlobListOptionConsumer> clazz = BlobListOptionConsumer.class;
        synchronized (BlobListOptionConsumer.class) {
            instance = new BlobListOptionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BlobListOptionConsumer() {
        this.put("currentDirectory", new ConsumerValidator((blobListBuilder, val) -> {
            boolean currDir = this.cast.getBooleanProperty(val);
            blobListBuilder.setCurrentDirectory(currDir);
        }, Collections.emptyList()));
        this.put("delimeter", new ConsumerValidator((blobListBuilder, val) -> {
            String delimeter = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)delimeter, (String)"delimeter");
            blobListBuilder.setDelimeter(delimeter);
        }, Collections.emptyList()));
        this.put("endOffSet", new ConsumerValidator((blobListBuilder, val) -> {
            String endOffset = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)endOffset, (String)"endOffSet");
            blobListBuilder.setEndoffSet(endOffset);
        }, Collections.emptyList()));
        this.put("fields", new ConsumerValidator((blobListBuilder, val) -> {
            List value = this.cast.getStringListProperty(val);
            Iterator itr = value.iterator();
            ArrayList<Storage.BlobField> bfield = new ArrayList<Storage.BlobField>();
            while (itr.hasNext()) {
                bfield.add(Storage.BlobField.valueOf((String)((String)itr.next())));
            }
            Storage.BlobField[] blobField = bfield.toArray(new Storage.BlobField[bfield.size()]);
            blobListBuilder.setFields(blobField);
        }, Collections.singletonList(new EmptyListValidator("fields"))));
        this.put("pageSize", new ConsumerValidator((blobListBuilder, val) -> {
            Long pageSize = this.cast.getLongProperty(val);
            blobListBuilder.setPageSize(pageSize);
        }, Collections.emptyList()));
        this.put("pageToken", new ConsumerValidator((blobListBuilder, val) -> {
            String pageToken = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)pageToken, (String)"pageToken");
            blobListBuilder.setPageToken(pageToken);
        }, Collections.emptyList()));
        this.put("prefix", new ConsumerValidator((blobListBuilder, val) -> {
            String prefix = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)prefix, (String)"prefix");
            blobListBuilder.setPrefix(prefix);
        }, Collections.emptyList()));
        this.put("startOffset", new ConsumerValidator((blobListBuilder, val) -> {
            String startOffset = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)startOffset, (String)"startOffset");
            blobListBuilder.setStartoffSet(startOffset);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((blobListBuilder, val) -> {
            String userProject = this.cast.getStringProperty(val);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            blobListBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
        this.put("versions", new ConsumerValidator((blobListBuilder, val) -> {
            boolean versions = this.cast.getBooleanProperty(val);
            blobListBuilder.setVersions(versions);
        }, Collections.emptyList()));
    }
}

