/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.runtime.ApplicationException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.StaleStateException;

public class HibernateSessionException
extends ApplicationException {
    private String detailString;

    public HibernateSessionException(HibernateException ex) {
        super((Throwable)ex);
        if (ex instanceof JDBCException) {
            this.rootCause = ((JDBCException)ex).getSQLException();
        } else if (ex instanceof StaleStateException) {
            this.detailString = "detailStaleStateException";
        }
    }

    public HibernateSessionException(PersistenceException persistenceException) {
        super((Throwable)persistenceException);
        if (persistenceException instanceof JDBCException) {
            this.rootCause = ((JDBCException)persistenceException).getSQLException();
        } else if (persistenceException instanceof StaleStateException) {
            this.detailString = "detailStaleStateException";
        }
    }

    public String getMessage() {
        if (this.msg == null) {
            this.msg = this.detailString == null ? this.rootCause.getMessage() : super.getMessage();
        }
        return this.msg;
    }

    public Throwable getCause() {
        return this.rootCause;
    }

    public String getDetail() {
        if ("detailStaleStateException".equals(this.detailString)) {
            return HibernateSessionException.getString((Throwable)((Object)this), (String)this.detailString, (Locale)this.locale);
        }
        return super.getDetail();
    }

    public StackTraceElement[] getStackTrace() {
        return this.rootCause.getStackTrace();
    }

    public void printStackTrace() {
        this.rootCause.printStackTrace();
    }

    public void printStackTrace(PrintStream s) {
        this.rootCause.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        this.rootCause.printStackTrace(s);
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.rootCause.setStackTrace(stackTrace);
    }
}

