/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.db2;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import macromedia.db2util.ddbf;
import macromedia.jdbc.db2.DB2ImplConnection;
import macromedia.jdbc.db2.drda.ddc;
import macromedia.jdbc.db2.drda.ddd;
import macromedia.jdbc.db2.drda.ddt;
import macromedia.jdbc.db2base.BaseConnection;
import macromedia.jdbc.db2base.ddc2;
import macromedia.jdbc.db2base.ddfe;
import macromedia.jdbcx.db2.DB2Xid;
import macromedia.jdbcx.db2base.ddk;

public class DB2ImplXAResource
extends ddk {
    private static String footprint = "$Revision$";
    BaseConnection connection;
    DB2ImplConnection implConn;
    ddt request;
    int timeout;
    private ddfe warnings;
    private ddbf suspendedXids;
    public ddd writer;
    public ddc reader;

    public DB2ImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.implConn = (DB2ImplConnection)baseConnection.g;
        this.suspendedXids = new ddbf();
        this.reader = this.implConn.c.b();
        this.writer = this.implConn.a;
        this.warnings = ((ddc2)this.implConn).e;
        DB2ImplConnection dB2ImplConnection = this.implConn;
        this.request = new ddt(dB2ImplConnection, dB2ImplConnection.c, this.reader, this.writer);
    }

    protected void open() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Xid xid, int n2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                if (n2 == 0x8000000) {
                    for (int i2 = 0; i2 < this.suspendedXids.size(); ++i2) {
                        if ((Xid)this.suspendedXids.b(i2) != xid) continue;
                        this.suspendedXids.remove(i2);
                    }
                }
                this.implConn.e = false;
                this.request.a(new DB2Xid(xid), n2);
                this.request.b();
                this.request.b(this.warnings);
                this.checkXAStatus();
            }
            catch (SQLException sQLException) {
                throw new XAException(((ddc2)this.implConn).f.a(7100).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                ++this.implConn.bd;
                this.request.b(new DB2Xid(xid));
                this.request.b();
                this.request.b(this.warnings);
                this.checkXAStatus();
            }
            catch (SQLException sQLException) {
                throw new XAException(((ddc2)this.implConn).f.a(7101).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Xid xid, boolean bl) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                ++this.implConn.bd;
                this.request.a(new DB2Xid(xid), bl);
                this.request.b();
                this.request.b(this.warnings);
                this.checkXAStatus();
            }
            catch (SQLException sQLException) {
                throw new XAException(((ddc2)this.implConn).f.a(7102).getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid[] recover(int n2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.a();
                this.request.b();
                this.request.b(this.warnings);
            }
            catch (SQLException sQLException) {
                throw new XAException(((ddc2)this.implConn).f.a(7099).getMessage());
            }
            return this.request.a;
        }
    }

    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.a(new DB2Xid(xid));
                this.request.b();
                this.request.b(this.warnings);
                return this.request.c;
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(Xid xid, int n2) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                if (!this.isXidSuspended(xid)) {
                    if (n2 == 0x2000000) {
                        this.suspendedXids.add(xid);
                    }
                    this.implConn.e = true;
                    this.request.b(new DB2Xid(xid), n2);
                    this.request.b();
                    this.request.b(this.warnings);
                    this.checkXAStatus();
                } else if (n2 == 0x4000000 || n2 == 0x20000000) {
                    for (int i2 = 0; i2 < this.suspendedXids.size(); ++i2) {
                        if ((Xid)this.suspendedXids.b(i2) != xid) continue;
                        this.suspendedXids.remove(i2);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(((ddc2)this.implConn).f.a(7103).getMessage());
            }
        }
    }

    protected void forget(Xid xid) throws XAException {
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.timeout = n2;
        return false;
    }

    protected String getRmIdentification() throws XAException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.implConn.x);
        stringBuilder.append("_");
        stringBuilder.append(this.implConn.y);
        stringBuilder.append("_");
        stringBuilder.append(this.implConn.l);
        return stringBuilder.toString();
    }

    private final boolean isXidSuspended(Xid xid) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.suspendedXids.size(); ++i2) {
            if ((Xid)this.suspendedXids.b(i2) != xid) continue;
            bl = true;
        }
        return bl;
    }

    private final void checkXAStatus() throws XAException {
        switch (this.request.c) {
            case 0: {
                break;
            }
            case 99: {
                this.warnings.a(7111);
                break;
            }
            default: {
                throw new XAException(this.request.c);
            }
        }
    }
}

