/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.pqc.crypto.ntru;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA256Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SHA512Digest;

public class NTRUEncryptionParameters
implements Cloneable {
    public int N;
    public int q;
    public int df;
    public int df1;
    public int df2;
    public int df3;
    public int dr;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dg;
    int llen;
    public int maxMsgLenBytes;
    public int db;
    public int bufferLenBits;
    int bufferLenTrits;
    public int dm0;
    public int pkLen;
    public int c;
    public int minCallsR;
    public int minCallsMask;
    public boolean hashSeed;
    public byte[] oid;
    public boolean sparse;
    public boolean fastFp;
    public int polyType;
    public Digest hashAlg;

    public NTRUEncryptionParameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        this.N = n2;
        this.q = n3;
        this.df = n4;
        this.db = n6;
        this.dm0 = n5;
        this.c = n7;
        this.minCallsR = n8;
        this.minCallsMask = n9;
        this.hashSeed = bl;
        this.oid = byArray;
        this.sparse = bl2;
        this.fastFp = bl3;
        this.polyType = 0;
        this.hashAlg = digest;
        this.init();
    }

    public NTRUEncryptionParameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        this.N = n2;
        this.q = n3;
        this.df1 = n4;
        this.df2 = n5;
        this.df3 = n6;
        this.db = n8;
        this.dm0 = n7;
        this.c = n9;
        this.minCallsR = n10;
        this.minCallsMask = n11;
        this.hashSeed = bl;
        this.oid = byArray;
        this.sparse = bl2;
        this.fastFp = bl3;
        this.polyType = 1;
        this.hashAlg = digest;
        this.init();
    }

    private final void init() {
        this.dr = this.df;
        this.dr1 = this.df1;
        this.dr2 = this.df2;
        this.dr3 = this.df3;
        this.dg = this.N / 3;
        this.llen = 1;
        this.maxMsgLenBytes = this.N * 3 / 2 / 8 - this.llen - this.db / 8 - 1;
        this.bufferLenBits = ((this.N * 3 / 2 + 7) / 8 << 3) + 1;
        this.bufferLenTrits = this.N - 1;
        this.pkLen = this.db;
    }

    public NTRUEncryptionParameters(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.N = dataInputStream.readInt();
        this.q = dataInputStream.readInt();
        this.df = dataInputStream.readInt();
        this.df1 = dataInputStream.readInt();
        this.df2 = dataInputStream.readInt();
        this.df3 = dataInputStream.readInt();
        this.db = dataInputStream.readInt();
        this.dm0 = dataInputStream.readInt();
        this.c = dataInputStream.readInt();
        this.minCallsR = dataInputStream.readInt();
        this.minCallsMask = dataInputStream.readInt();
        this.hashSeed = dataInputStream.readBoolean();
        this.oid = new byte[3];
        dataInputStream.read(this.oid);
        this.sparse = dataInputStream.readBoolean();
        this.fastFp = dataInputStream.readBoolean();
        this.polyType = dataInputStream.read();
        String string = dataInputStream.readUTF();
        if ("SHA-512".equals(string)) {
            this.hashAlg = new SHA512Digest();
        } else if ("SHA-256".equals(string)) {
            this.hashAlg = new SHA256Digest();
        }
        this.init();
    }

    public NTRUEncryptionParameters clone() {
        if (this.polyType == 0) {
            return new NTRUEncryptionParameters(this.N, this.q, this.df, this.dm0, this.db, this.c, this.minCallsR, this.minCallsMask, this.hashSeed, this.oid, this.sparse, this.fastFp, this.hashAlg);
        }
        return new NTRUEncryptionParameters(this.N, this.q, this.df1, this.df2, this.df3, this.dm0, this.db, this.c, this.minCallsR, this.minCallsMask, this.hashSeed, this.oid, this.sparse, this.fastFp, this.hashAlg);
    }

    public int getMaxMessageLength() {
        return this.maxMsgLenBytes;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.N);
        dataOutputStream.writeInt(this.q);
        dataOutputStream.writeInt(this.df);
        dataOutputStream.writeInt(this.df1);
        dataOutputStream.writeInt(this.df2);
        dataOutputStream.writeInt(this.df3);
        dataOutputStream.writeInt(this.db);
        dataOutputStream.writeInt(this.dm0);
        dataOutputStream.writeInt(this.c);
        dataOutputStream.writeInt(this.minCallsR);
        dataOutputStream.writeInt(this.minCallsMask);
        dataOutputStream.writeBoolean(this.hashSeed);
        dataOutputStream.write(this.oid);
        dataOutputStream.writeBoolean(this.sparse);
        dataOutputStream.writeBoolean(this.fastFp);
        dataOutputStream.write(this.polyType);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.N;
        n3 = 31 * n3 + this.bufferLenBits;
        n3 = 31 * n3 + this.bufferLenTrits;
        n3 = 31 * n3 + this.c;
        n3 = 31 * n3 + this.db;
        n3 = 31 * n3 + this.df;
        n3 = 31 * n3 + this.df1;
        n3 = 31 * n3 + this.df2;
        n3 = 31 * n3 + this.df3;
        n3 = 31 * n3 + this.dg;
        n3 = 31 * n3 + this.dm0;
        n3 = 31 * n3 + this.dr;
        n3 = 31 * n3 + this.dr1;
        n3 = 31 * n3 + this.dr2;
        n3 = 31 * n3 + this.dr3;
        n3 = 31 * n3 + (this.fastFp ? 1231 : 1237);
        n3 = 31 * n3 + (this.hashAlg == null ? 0 : this.hashAlg.getAlgorithmName().hashCode());
        n3 = 31 * n3 + (this.hashSeed ? 1231 : 1237);
        n3 = 31 * n3 + this.llen;
        n3 = 31 * n3 + this.maxMsgLenBytes;
        n3 = 31 * n3 + this.minCallsMask;
        n3 = 31 * n3 + this.minCallsR;
        n3 = 31 * n3 + Arrays.hashCode(this.oid);
        n3 = 31 * n3 + this.pkLen;
        n3 = 31 * n3 + this.polyType;
        n3 = 31 * n3 + this.q;
        n3 = 31 * n3 + (this.sparse ? 1231 : 1237);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NTRUEncryptionParameters nTRUEncryptionParameters = (NTRUEncryptionParameters)object;
        if (this.N != nTRUEncryptionParameters.N) {
            return false;
        }
        if (this.bufferLenBits != nTRUEncryptionParameters.bufferLenBits) {
            return false;
        }
        if (this.bufferLenTrits != nTRUEncryptionParameters.bufferLenTrits) {
            return false;
        }
        if (this.c != nTRUEncryptionParameters.c) {
            return false;
        }
        if (this.db != nTRUEncryptionParameters.db) {
            return false;
        }
        if (this.df != nTRUEncryptionParameters.df) {
            return false;
        }
        if (this.df1 != nTRUEncryptionParameters.df1) {
            return false;
        }
        if (this.df2 != nTRUEncryptionParameters.df2) {
            return false;
        }
        if (this.df3 != nTRUEncryptionParameters.df3) {
            return false;
        }
        if (this.dg != nTRUEncryptionParameters.dg) {
            return false;
        }
        if (this.dm0 != nTRUEncryptionParameters.dm0) {
            return false;
        }
        if (this.dr != nTRUEncryptionParameters.dr) {
            return false;
        }
        if (this.dr1 != nTRUEncryptionParameters.dr1) {
            return false;
        }
        if (this.dr2 != nTRUEncryptionParameters.dr2) {
            return false;
        }
        if (this.dr3 != nTRUEncryptionParameters.dr3) {
            return false;
        }
        if (this.fastFp != nTRUEncryptionParameters.fastFp) {
            return false;
        }
        if (this.hashAlg == null ? nTRUEncryptionParameters.hashAlg != null : !this.hashAlg.getAlgorithmName().equals(nTRUEncryptionParameters.hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.hashSeed != nTRUEncryptionParameters.hashSeed) {
            return false;
        }
        if (this.llen != nTRUEncryptionParameters.llen) {
            return false;
        }
        if (this.maxMsgLenBytes != nTRUEncryptionParameters.maxMsgLenBytes) {
            return false;
        }
        if (this.minCallsMask != nTRUEncryptionParameters.minCallsMask) {
            return false;
        }
        if (this.minCallsR != nTRUEncryptionParameters.minCallsR) {
            return false;
        }
        if (!Arrays.equals(this.oid, nTRUEncryptionParameters.oid)) {
            return false;
        }
        if (this.pkLen != nTRUEncryptionParameters.pkLen) {
            return false;
        }
        if (this.polyType != nTRUEncryptionParameters.polyType) {
            return false;
        }
        if (this.q != nTRUEncryptionParameters.q) {
            return false;
        }
        return this.sparse == nTRUEncryptionParameters.sparse;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("EncryptionParameters(N=" + this.N + " q=" + this.q);
        if (this.polyType == 0) {
            stringBuilder.append(" polyType=SIMPLE df=" + this.df);
        } else {
            stringBuilder.append(" polyType=PRODUCT df1=" + this.df1 + " df2=" + this.df2 + " df3=" + this.df3);
        }
        stringBuilder.append(" dm0=" + this.dm0 + " db=" + this.db + " c=" + this.c + " minCallsR=" + this.minCallsR + " minCallsMask=" + this.minCallsMask + " hashSeed=" + this.hashSeed + " hashAlg=" + this.hashAlg + " oid=" + Arrays.toString(this.oid) + " sparse=" + this.sparse + ")");
        return stringBuilder.toString();
    }
}

