/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.pqc.crypto.gmss;

import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import macromedia.db2util.externals.org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import macromedia.db2util.externals.org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.pqc.crypto.gmss.GMSSSigner;
import macromedia.db2util.externals.org.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner gmssSigner;
    private GMSSPrivateKeyParameters key;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable memoable = ((Memoable)((Object)digest)).copy();
        this.gmssSigner = new GMSSSigner(new GMSSDigestProvider(){

            public Digest get() {
                return (Digest)((Object)memoable.copy());
            }
        });
    }

    public void init(boolean bl, dda dda10) {
        if (bl) {
            if (dda10 instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda10;
                this.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.key = (GMSSPrivateKeyParameters)dda10;
            }
        }
        this.gmssSigner.init(bl, dda10);
    }

    public byte[] generateSignature(byte[] byArray) {
        if (this.key == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] byArray2 = this.gmssSigner.generateSignature(byArray);
        this.key = this.key.nextKey();
        return byArray2;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        return this.gmssSigner.verifySignature(byArray, byArray2);
    }

    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this.key;
        this.key = null;
        return gMSSPrivateKeyParameters;
    }
}

