/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.pqc.crypto;

import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.Signer;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest messDigest;
    private final MessageSigner messSigner;
    private boolean forSigning;

    public DigestingMessageSigner(MessageSigner messageSigner, Digest digest) {
        this.messSigner = messageSigner;
        this.messDigest = digest;
    }

    public void init(boolean bl, dda dda10) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = dda10 instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)dda10).getParameters() : (AsymmetricKeyParameter)dda10;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.messSigner.init(bl, dda10);
    }

    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray, 0);
        return this.messSigner.generateSignature(byArray);
    }

    public void update(byte by) {
        this.messDigest.update(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.messDigest.update(byArray, n2, n3);
    }

    public void reset() {
        this.messDigest.reset();
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray2, 0);
        return this.messSigner.verifySignature(byArray2, byArray);
    }
}

