/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECMultiplier;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECPoint;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    public ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger) {
        int n2 = bigInteger.signum();
        if (n2 == 0 || eCPoint.isInfinity()) {
            return eCPoint.getCurve().getInfinity();
        }
        ECPoint eCPoint2 = this.multiplyPositive(eCPoint, bigInteger.abs());
        ECPoint eCPoint3 = n2 > 0 ? eCPoint2 : eCPoint2.negate();
        return this.checkResult(eCPoint3);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);

    protected ECPoint checkResult(ECPoint eCPoint) {
        return ECAlgorithms.implCheckResult(eCPoint);
    }
}

