/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.dh;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import macromedia.db2util.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.db2util.externals.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import macromedia.db2util.externals.org.bouncycastle.crypto.generators.DHParametersGenerator;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import macromedia.db2util.externals.org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import macromedia.db2util.externals.org.bouncycastle.jce.provider.BouncyCastleProvider;
import macromedia.db2util.externals.org.bouncycastle.util.Integers;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.strength = n2;
        this.random = secureRandom;
        this.initialised = false;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        try {
            this.param = this.convertParams(secureRandom, dHParameterSpec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    private final DHKeyGenerationParameters convertParams(SecureRandom secureRandom, DHParameterSpec dHParameterSpec) {
        if (dHParameterSpec instanceof DHDomainParameterSpec) {
            return new DHKeyGenerationParameters(secureRandom, ((DHDomainParameterSpec)dHParameterSpec).getDomainParameters());
        }
        return new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (!this.initialised) {
            object3 = Integers.valueOf(this.strength);
            if (params.containsKey(object3)) {
                this.param = (DHKeyGenerationParameters)params.get(object3);
            } else {
                object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
                if (object2 != null) {
                    KeyPairGeneratorSpi keyPairGeneratorSpi = this;
                    keyPairGeneratorSpi.param = keyPairGeneratorSpi.convertParams(keyPairGeneratorSpi.random, (DHParameterSpec)object2);
                } else {
                    object = lock;
                    synchronized (object) {
                        if (params.containsKey(object3)) {
                            this.param = (DHKeyGenerationParameters)params.get(object3);
                        } else {
                            DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
                            int n2 = this.strength;
                            dHParametersGenerator.init(n2, PrimeCertaintyCalculator.getDefaultCertainty(n2), this.random);
                            this.param = new DHKeyGenerationParameters(this.random, dHParametersGenerator.generateParameters());
                            params.put(object3, this.param);
                        }
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object3 = this.engine.generateKeyPair();
        object2 = (DHPublicKeyParameters)((AsymmetricCipherKeyPair)object3).getPublic();
        object = (DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object3).getPrivate();
        return new KeyPair(new BCDHPublicKey((DHPublicKeyParameters)object2), new BCDHPrivateKey((DHPrivateKeyParameters)object));
    }
}

