/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import macromedia.db2util.externals.org.bouncycastle.crypto.AsymmetricBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.db2util.externals.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.RSABlindedEngine;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.RSAKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.ProtocolVersion;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsContext;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.db2util.externals.org.bouncycastle.crypto.tls.TlsUtils;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(tlsContext.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, tlsContext.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (TlsUtils.isSSL(tlsContext)) {
                outputStream.write(byArray2);
            } else {
                TlsUtils.writeOpaque16(byArray2, outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
        }
        return byArray;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, byte[] byArray) {
        ProtocolVersion protocolVersion = tlsContext.getClientVersion();
        boolean bl = false;
        byte[] byArray2 = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray2);
        byte[] byArray3 = Arrays.clone(byArray2);
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), byArray2);
            pKCS1Encoding.init(false, new ParametersWithRandom(rSAKeyParameters, tlsContext.getSecureRandom()));
            byArray3 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || !protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int n2 = protocolVersion.getMajorVersion() ^ byArray3[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray3[1] & 0xFF;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            int n3 = ~((n2 & 1) - 1);
            for (int i2 = 0; i2 < 48; ++i2) {
                byArray3[i2] = (byte)(byArray3[i2] & ~n3 | byArray2[i2] & n3);
            }
        }
        return byArray3;
    }
}

