/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.modes.gcm;

import macromedia.db2util.externals.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;
import macromedia.db2util.externals.org.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int i2 = 0; i2 < 32; ++i2) {
            long[][] lArray = this.T[i2];
            if (i2 == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP3(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP4(this.T[i2 - 1][1], lArray[1]);
            }
            for (int i3 = 2; i3 < 16; i3 += 2) {
                GCMUtil.divideP(lArray[i3 >> 1], lArray[i3]);
                GCMUtil.xor(lArray[i3], lArray[1], lArray[i3 + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 15; i2 >= 0; --i2) {
            long[] lArray = this.T[i2 + i2 + 1][byArray[i2] & 0xF];
            long[] lArray2 = this.T[i2 + i2][(byArray[i2] & 0xF0) >>> 4];
            l2 ^= lArray[0] ^ lArray2[0];
            l3 ^= lArray[1] ^ lArray2[1];
        }
        Pack.longToBigEndian(l2, byArray, 0);
        Pack.longToBigEndian(l3, byArray, 8);
    }
}

