/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.macs;

import macromedia.db2util.externals.org.bouncycastle.crypto.Mac;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SkeinEngine;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.SkeinParameters;

public class SkeinMac
implements Mac {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine engine;

    public SkeinMac(int n2, int n3) {
        this.engine = new SkeinEngine(n2, n3);
    }

    public SkeinMac(SkeinMac skeinMac) {
        this.engine = new SkeinEngine(skeinMac.engine);
    }

    public String getAlgorithmName() {
        return "Skein-MAC-" + (this.engine.getBlockSize() << 3) + "-" + (this.engine.getOutputSize() << 3);
    }

    public void init(dda dda10) throws IllegalArgumentException {
        SkeinParameters skeinParameters;
        if (dda10 instanceof SkeinParameters) {
            skeinParameters = (SkeinParameters)dda10;
        } else if (dda10 instanceof KeyParameter) {
            skeinParameters = new SkeinParameters.Builder().setKey(((KeyParameter)dda10).getKey()).build();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Skein MAC init - " + dda10.getClass().getName());
        }
        if (skeinParameters.getKey() == null) {
            throw new IllegalArgumentException("Skein MAC requires a key parameter.");
        }
        this.engine.init(skeinParameters);
    }

    public int getMacSize() {
        return this.engine.getOutputSize();
    }

    public void reset() {
        this.engine.reset();
    }

    public void update(byte by) {
        this.engine.update(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.engine.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        return this.engine.doFinal(byArray, n2);
    }
}

