/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.macs;

import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.Mac;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.DESEngine;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.CBCBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;

public class ISO9797Alg3Mac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;
    private KeyParameter lastKey2;
    private KeyParameter lastKey3;

    public ISO9797Alg3Mac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() << 3, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() << 3, blockCipherPadding);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n2) {
        this(blockCipher, n2, null);
    }

    public ISO9797Alg3Mac(BlockCipher blockCipher, int n2, BlockCipherPadding blockCipherPadding) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!(blockCipher instanceof DESEngine)) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.cipher = new CBCBlockCipher(blockCipher);
        this.padding = blockCipherPadding;
        this.macSize = n2 / 8;
        this.mac = new byte[blockCipher.getBlockSize()];
        this.buf = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    public void init(dda dda10) {
        KeyParameter keyParameter;
        this.reset();
        if (!(dda10 instanceof KeyParameter) && !(dda10 instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        KeyParameter keyParameter2 = dda10 instanceof KeyParameter ? (KeyParameter)dda10 : (KeyParameter)((ParametersWithIV)dda10).getParameters();
        byte[] byArray = keyParameter2.getKey();
        if (byArray.length == 16) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.lastKey2 = new KeyParameter(byArray, 8, 8);
            this.lastKey3 = keyParameter;
        } else if (byArray.length == 24) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.lastKey2 = new KeyParameter(byArray, 8, 8);
            this.lastKey3 = new KeyParameter(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (dda10 instanceof ParametersWithIV) {
            this.cipher.init(true, new ParametersWithIV(keyParameter, ((ParametersWithIV)dda10).getIV()));
        } else {
            this.cipher.init(true, keyParameter);
        }
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.cipher.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.bufOff;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n6);
            n5 += this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.cipher.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.cipher.getBlockSize();
        if (this.padding == null) {
            while (this.bufOff < n3) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n3) {
                this.cipher.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.padding.addPadding(this.buf, this.bufOff);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        DESEngine dESEngine = new DESEngine();
        dESEngine.init(false, this.lastKey2);
        dESEngine.processBlock(this.mac, 0, this.mac, 0);
        dESEngine.init(true, this.lastKey3);
        dESEngine.processBlock(this.mac, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

