/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.digests.SM3Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithID;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.db2util.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;
import macromedia.db2util.externals.org.bouncycastle.util.Memoable;
import macromedia.db2util.externals.org.bouncycastle.util.Pack;

public class SM2KeyExchange {
    private final Digest digest;
    private byte[] userID;
    private ECPrivateKeyParameters staticKey;
    private ECPoint staticPubPoint;
    private ECPoint ephemeralPubPoint;
    private ECDomainParameters ecParams;
    private int w;
    private ECPrivateKeyParameters ephemeralKey;
    private boolean initiator;

    public SM2KeyExchange() {
        this(new SM3Digest());
    }

    public SM2KeyExchange(Digest digest) {
        this.digest = digest;
    }

    public void init(dda dda10) {
        SM2KeyExchangePrivateParameters sM2KeyExchangePrivateParameters;
        if (dda10 instanceof ParametersWithID) {
            sM2KeyExchangePrivateParameters = (SM2KeyExchangePrivateParameters)((ParametersWithID)dda10).getParameters();
            this.userID = ((ParametersWithID)dda10).getID();
        } else {
            sM2KeyExchangePrivateParameters = (SM2KeyExchangePrivateParameters)dda10;
            this.userID = new byte[0];
        }
        this.initiator = sM2KeyExchangePrivateParameters.isInitiator();
        this.staticKey = sM2KeyExchangePrivateParameters.getStaticPrivateKey();
        this.ephemeralKey = sM2KeyExchangePrivateParameters.getEphemeralPrivateKey();
        this.ecParams = this.staticKey.getParameters();
        this.staticPubPoint = sM2KeyExchangePrivateParameters.getStaticPublicPoint();
        this.ephemeralPubPoint = sM2KeyExchangePrivateParameters.getEphemeralPublicPoint();
        this.w = this.ecParams.getCurve().getFieldSize() / 2 - 1;
    }

    public byte[] calculateKey(int n2, dda dda10) {
        byte[] byArray;
        SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters;
        if (dda10 instanceof ParametersWithID) {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)((ParametersWithID)dda10).getParameters();
            byArray = ((ParametersWithID)dda10).getID();
        } else {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)dda10;
            byArray = new byte[]{};
        }
        SM2KeyExchange sM2KeyExchange = this;
        byte[] byArray2 = sM2KeyExchange.getZ(sM2KeyExchange.digest, this.userID, this.staticPubPoint);
        SM2KeyExchange sM2KeyExchange2 = this;
        byte[] byArray3 = sM2KeyExchange2.getZ(sM2KeyExchange2.digest, byArray, sM2KeyExchangePublicParameters.getStaticPublicKey().getQ());
        ECPoint eCPoint = this.calculateU(sM2KeyExchangePublicParameters);
        byte[] byArray4 = this.initiator ? this.kdf(eCPoint, byArray2, byArray3, n2) : this.kdf(eCPoint, byArray3, byArray2, n2);
        return byArray4;
    }

    public byte[][] calculateKeyWithConfirmation(int n2, byte[] byArray, dda dda10) {
        byte[] byArray2;
        SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters;
        if (dda10 instanceof ParametersWithID) {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)((ParametersWithID)dda10).getParameters();
            byArray2 = ((ParametersWithID)dda10).getID();
        } else {
            sM2KeyExchangePublicParameters = (SM2KeyExchangePublicParameters)dda10;
            byArray2 = new byte[]{};
        }
        if (this.initiator && byArray == null) {
            throw new IllegalArgumentException("if initiating, confirmationTag must be set");
        }
        SM2KeyExchange sM2KeyExchange = this;
        byte[] byArray3 = sM2KeyExchange.getZ(sM2KeyExchange.digest, this.userID, this.staticPubPoint);
        SM2KeyExchange sM2KeyExchange2 = this;
        byte[] byArray4 = sM2KeyExchange2.getZ(sM2KeyExchange2.digest, byArray2, sM2KeyExchangePublicParameters.getStaticPublicKey().getQ());
        ECPoint eCPoint = this.calculateU(sM2KeyExchangePublicParameters);
        if (this.initiator) {
            byte[] byArray5 = this.kdf(eCPoint, byArray3, byArray4, n2);
            SM2KeyExchange sM2KeyExchange3 = this;
            byte[] byArray6 = sM2KeyExchange3.calculateInnerHash(sM2KeyExchange3.digest, eCPoint, byArray3, byArray4, this.ephemeralPubPoint, sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ());
            SM2KeyExchange sM2KeyExchange4 = this;
            byte[] byArray7 = sM2KeyExchange4.S1(sM2KeyExchange4.digest, eCPoint, byArray6);
            if (!Arrays.constantTimeAreEqual(byArray7, byArray)) {
                throw new IllegalStateException("confirmation tag mismatch");
            }
            byte[][] byArrayArray = new byte[2][];
            byArrayArray[0] = byArray5;
            SM2KeyExchange sM2KeyExchange5 = this;
            byArrayArray[1] = sM2KeyExchange5.S2(sM2KeyExchange5.digest, eCPoint, byArray6);
            return byArrayArray;
        }
        byte[] byArray8 = this.kdf(eCPoint, byArray4, byArray3, n2);
        SM2KeyExchange sM2KeyExchange6 = this;
        byte[] byArray9 = sM2KeyExchange6.calculateInnerHash(sM2KeyExchange6.digest, eCPoint, byArray4, byArray3, sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ(), this.ephemeralPubPoint);
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = byArray8;
        SM2KeyExchange sM2KeyExchange7 = this;
        byArrayArray[1] = sM2KeyExchange7.S1(sM2KeyExchange7.digest, eCPoint, byArray9);
        SM2KeyExchange sM2KeyExchange8 = this;
        byArrayArray[2] = sM2KeyExchange8.S2(sM2KeyExchange8.digest, eCPoint, byArray9);
        return byArrayArray;
    }

    private final ECPoint calculateU(SM2KeyExchangePublicParameters sM2KeyExchangePublicParameters) {
        ECDomainParameters eCDomainParameters = this.staticKey.getParameters();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), sM2KeyExchangePublicParameters.getStaticPublicKey().getQ());
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), sM2KeyExchangePublicParameters.getEphemeralPublicKey().getQ());
        SM2KeyExchange sM2KeyExchange = this;
        BigInteger bigInteger = sM2KeyExchange.reduce(sM2KeyExchange.ephemeralPubPoint.getAffineXCoord().toBigInteger());
        BigInteger bigInteger2 = this.reduce(eCPoint2.getAffineXCoord().toBigInteger());
        BigInteger bigInteger3 = this.staticKey.getD().add(bigInteger.multiply(this.ephemeralKey.getD()));
        BigInteger bigInteger4 = this.ecParams.getH().multiply(bigInteger3).mod(this.ecParams.getN());
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger2).mod(this.ecParams.getN());
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint, bigInteger4, eCPoint2, bigInteger5).normalize();
    }

    private final byte[] kdf(ECPoint eCPoint, byte[] byArray, byte[] byArray2, int n2) {
        int n3 = this.digest.getDigestSize();
        byte[] byArray3 = new byte[Math.max(4, n3)];
        byte[] byArray4 = new byte[(n2 + 7) / 8];
        int n4 = 0;
        Memoable memoable = null;
        Memoable memoable2 = null;
        if (this.digest instanceof Memoable) {
            SM2KeyExchange sM2KeyExchange = this;
            sM2KeyExchange.addFieldElement(sM2KeyExchange.digest, eCPoint.getAffineXCoord());
            SM2KeyExchange sM2KeyExchange2 = this;
            sM2KeyExchange2.addFieldElement(sM2KeyExchange2.digest, eCPoint.getAffineYCoord());
            this.digest.update(byArray, 0, byArray.length);
            this.digest.update(byArray2, 0, byArray2.length);
            memoable = (Memoable)((Object)this.digest);
            memoable2 = memoable.copy();
        }
        int n5 = 0;
        while (n4 < byArray4.length) {
            if (memoable != null) {
                memoable.reset(memoable2);
            } else {
                SM2KeyExchange sM2KeyExchange = this;
                sM2KeyExchange.addFieldElement(sM2KeyExchange.digest, eCPoint.getAffineXCoord());
                SM2KeyExchange sM2KeyExchange3 = this;
                sM2KeyExchange3.addFieldElement(sM2KeyExchange3.digest, eCPoint.getAffineYCoord());
                this.digest.update(byArray, 0, byArray.length);
                this.digest.update(byArray2, 0, byArray2.length);
            }
            Pack.intToBigEndian(++n5, byArray3, 0);
            this.digest.update(byArray3, 0, 4);
            this.digest.doFinal(byArray3, 0);
            int n6 = Math.min(n3, byArray4.length - n4);
            System.arraycopy(byArray3, 0, byArray4, n4, n6);
            n4 += n6;
        }
        return byArray4;
    }

    private final BigInteger reduce(BigInteger bigInteger) {
        return bigInteger.and(BigInteger.valueOf(1L).shiftLeft(this.w).subtract(BigInteger.valueOf(1L))).setBit(this.w);
    }

    private final byte[] S1(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)2);
        this.addFieldElement(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.digestDoFinal();
    }

    private final byte[] calculateInnerHash(Digest digest, ECPoint eCPoint, byte[] byArray, byte[] byArray2, ECPoint eCPoint2, ECPoint eCPoint3) {
        this.addFieldElement(digest, eCPoint.getAffineXCoord());
        digest.update(byArray, 0, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
        this.addFieldElement(digest, eCPoint2.getAffineXCoord());
        this.addFieldElement(digest, eCPoint2.getAffineYCoord());
        this.addFieldElement(digest, eCPoint3.getAffineXCoord());
        this.addFieldElement(digest, eCPoint3.getAffineYCoord());
        return this.digestDoFinal();
    }

    private final byte[] S2(Digest digest, ECPoint eCPoint, byte[] byArray) {
        digest.update((byte)3);
        this.addFieldElement(digest, eCPoint.getAffineYCoord());
        digest.update(byArray, 0, byArray.length);
        return this.digestDoFinal();
    }

    private final byte[] getZ(Digest digest, byte[] byArray, ECPoint eCPoint) {
        this.addUserID(digest, byArray);
        this.addFieldElement(digest, this.ecParams.getCurve().getA());
        this.addFieldElement(digest, this.ecParams.getCurve().getB());
        this.addFieldElement(digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement(digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement(digest, eCPoint.getAffineXCoord());
        this.addFieldElement(digest, eCPoint.getAffineYCoord());
        return this.digestDoFinal();
    }

    private final void addUserID(Digest digest, byte[] byArray) {
        int n2 = byArray.length << 3;
        digest.update((byte)(n2 >>> 8));
        digest.update((byte)n2);
        digest.update(byArray, 0, byArray.length);
    }

    private final void addFieldElement(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        digest.update(byArray, 0, byArray.length);
    }

    private final byte[] digestDoFinal() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }
}

