/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.db2util.externals.org.bouncycastle.crypto.BasicAgreement;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHMQVPrivateParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHMQVPublicParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class MQVBasicAgreement
implements BasicAgreement {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    DHMQVPrivateParameters privParams;

    public void init(dda dda10) {
        this.privParams = (DHMQVPrivateParameters)dda10;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(dda dda10) {
        DHMQVPublicParameters dHMQVPublicParameters = (DHMQVPublicParameters)dda10;
        DHPrivateKeyParameters dHPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        if (!this.privParams.getStaticPrivateKey().getParameters().equals(dHMQVPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalStateException("MQV public key components have wrong domain parameters");
        }
        if (this.privParams.getStaticPrivateKey().getParameters().getQ() == null) {
            throw new IllegalStateException("MQV key domain parameters do not have Q set");
        }
        BigInteger bigInteger = this.calculateDHMQVAgreement(dHPrivateKeyParameters.getParameters(), dHPrivateKeyParameters, dHMQVPublicParameters.getStaticPublicKey(), this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), dHMQVPublicParameters.getEphemeralPublicKey());
        if (bigInteger.equals(ONE)) {
            throw new IllegalStateException("1 is not a valid agreement value for MQV");
        }
        return bigInteger;
    }

    private final BigInteger calculateDHMQVAgreement(DHParameters dHParameters, DHPrivateKeyParameters dHPrivateKeyParameters, DHPublicKeyParameters dHPublicKeyParameters, DHPrivateKeyParameters dHPrivateKeyParameters2, DHPublicKeyParameters dHPublicKeyParameters2, DHPublicKeyParameters dHPublicKeyParameters3) {
        BigInteger bigInteger = dHParameters.getQ();
        int n2 = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(n2);
        BigInteger bigInteger3 = dHPublicKeyParameters2.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger4 = dHPrivateKeyParameters2.getX().add(bigInteger3.multiply(dHPrivateKeyParameters.getX())).mod(bigInteger);
        BigInteger bigInteger5 = dHPublicKeyParameters3.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger6 = dHPublicKeyParameters3.getY().multiply(dHPublicKeyParameters.getY().modPow(bigInteger5, dHParameters.getP())).modPow(bigInteger4, dHParameters.getP());
        return bigInteger6;
    }
}

