/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1.crmf;

import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERTaggedObject;
import macromedia.db2util.externals.org.bouncycastle.asn1.cms.EnvelopedData;
import macromedia.db2util.externals.org.bouncycastle.asn1.crmf.EncryptedValue;
import macromedia.db2util.externals.org.bouncycastle.asn1.dda;

public class EncryptedKey
extends ASN1Object
implements dda {
    private EnvelopedData envelopedData;
    private EncryptedValue encryptedValue;

    public static EncryptedKey getInstance(Object object) {
        if (object instanceof EncryptedKey) {
            return (EncryptedKey)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new EncryptedKey(EnvelopedData.getInstance((ASN1TaggedObject)object, false));
        }
        if (object instanceof EncryptedValue) {
            return new EncryptedKey((EncryptedValue)object);
        }
        return new EncryptedKey(EncryptedValue.getInstance(object));
    }

    public EncryptedKey(EnvelopedData envelopedData) {
        this.envelopedData = envelopedData;
    }

    public EncryptedKey(EncryptedValue encryptedValue) {
        this.encryptedValue = encryptedValue;
    }

    public boolean isEncryptedValue() {
        return this.encryptedValue != null;
    }

    public ASN1Encodable getValue() {
        if (this.encryptedValue != null) {
            return this.encryptedValue;
        }
        return this.envelopedData;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.encryptedValue != null) {
            return this.encryptedValue.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.envelopedData);
    }
}

