/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1;

import java.io.IOException;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.db2util.externals.org.bouncycastle.asn1.StreamUtil;

public class DERTaggedObject
extends ASN1TaggedObject {
    private static final byte[] ZERO_BYTES = new byte[0];

    public DERTaggedObject(boolean bl, int n2, ASN1Encodable aSN1Encodable) {
        super(bl, n2, aSN1Encodable);
    }

    public DERTaggedObject(int n2, ASN1Encodable aSN1Encodable) {
        super(true, n2, aSN1Encodable);
    }

    final boolean isConstructed() {
        if (!this.empty) {
            if (this.explicit) {
                return true;
            }
            ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDERObject();
            return aSN1Primitive.isConstructed();
        }
        return true;
    }

    final int encodedLength() throws IOException {
        if (!this.empty) {
            ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDERObject();
            int n2 = aSN1Primitive.encodedLength();
            if (this.explicit) {
                return StreamUtil.calculateTagLength(this.tagNo) + StreamUtil.calculateBodyLength(n2) + n2;
            }
            return StreamUtil.calculateTagLength(this.tagNo) + --n2;
        }
        return StreamUtil.calculateTagLength(this.tagNo) + 1;
    }

    final void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        if (!this.empty) {
            ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDERObject();
            if (this.explicit) {
                aSN1OutputStream.writeTag(160, this.tagNo);
                aSN1OutputStream.writeLength(aSN1Primitive.encodedLength());
                aSN1OutputStream.writeObject(aSN1Primitive);
            } else {
                int n2 = aSN1Primitive.isConstructed() ? 160 : 128;
                aSN1OutputStream.writeTag(n2, this.tagNo);
                aSN1OutputStream.writeImplicitObject(aSN1Primitive);
            }
        } else {
            aSN1OutputStream.writeEncoded(160, this.tagNo, ZERO_BYTES);
        }
    }
}

