/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import sun.security.pkcs.ParsingException;

public class MacDataIBM {
    private String digestAlgorithmName;
    private AlgorithmParameters digestAlgorithmParams;
    private byte[] digest;
    private byte[] macSalt;
    private int iterations;
    private byte[] encoded = null;

    MacDataIBM(DerInputStream derInputStream) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray2[0]);
        this.digestAlgorithmName = algorithmId.getName();
        this.digestAlgorithmParams = algorithmId.getAlgParameters();
        this.digest = derValueArray2[1].getOctetString();
        this.macSalt = derValueArray[1].getOctetString();
        this.iterations = derValueArray.length > 2 ? derValueArray[2].getInteger().intValue() : 1;
    }

    String getDigestAlgName() {
        return this.digestAlgorithmName;
    }

    byte[] getSalt() {
        return this.macSalt;
    }

    int getIterations() {
        return this.iterations;
    }

    byte[] getDigest() {
        return this.digest;
    }
}

