/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

public final class Angle {
    private static final int ANGLE_360_RESVALUE = 360000;
    private static final int ANGLE_MAX_RESVALUE = 360000;
    private static final int ANGLE_MIN_RESVALUE = 0;
    public static final Angle ZERO = new Angle();
    private final int mlResValue;

    public Angle() {
        this.mlResValue = 0;
    }

    public Angle(Angle source) {
        this.mlResValue = source.mlResValue;
    }

    public Angle(double dDegrees) {
        this.mlResValue = Angle.resolve(dDegrees);
    }

    public Angle(int nDegrees) {
        this.mlResValue = Angle.resolve(nDegrees);
    }

    public Angle(long nDegrees) {
        this.mlResValue = Angle.resolve(nDegrees);
    }

    public Angle(int value, boolean isResolved) {
        this.mlResValue = isResolved ? value : Angle.resolve(value);
    }

    public Angle add(Angle oAdd) {
        int lNewresValue = this.resValue() + oAdd.resValue();
        if (lNewresValue > 360000) {
            lNewresValue -= 360000;
        }
        return new Angle(lNewresValue, true);
    }

    public int degrees() {
        return (int)Math.round((double)this.resValue() / 1000.0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.resValue() == ((Angle)object).resValue();
    }

    public int hashCode() {
        int hash = 11;
        return hash * 31 ^ this.resValue();
    }

    public double getAngle() {
        return (double)this.resValue() / 1000.0;
    }

    public boolean gt(Angle compare) {
        return this.resValue() > compare.resValue();
    }

    public boolean gte(Angle compare) {
        return this.resValue() >= compare.resValue();
    }

    public boolean lt(Angle compare) {
        return this.resValue() < compare.resValue();
    }

    public boolean lte(Angle compare) {
        return this.resValue() <= compare.resValue();
    }

    private static int resolve(double value) {
        if (value < 0.0 || value > 360000.0) {
            throw new ExFull(ResId.ANGLE_ERR_RANGE);
        }
        return (int)(value * 1000.0);
    }

    private static int resolve(int value) {
        if (value < 0 || value > 360000) {
            throw new ExFull(ResId.ANGLE_ERR_RANGE);
        }
        return value * 1000;
    }

    private static int resolve(long value) {
        if (value < 0L || value > 360000L) {
            throw new ExFull(ResId.ANGLE_ERR_RANGE);
        }
        return (int)(value * 1000L);
    }

    private int resValue() {
        return this.mlResValue;
    }

    public Angle subtract(Angle subtract) {
        int lNewresValue = this.resValue() - subtract.resValue();
        if (lNewresValue < 0) {
            lNewresValue += 360000;
        }
        return new Angle(lNewresValue, true);
    }

    public String toString() {
        return Double.toString(this.getAngle());
    }

    public static Angle zero() {
        return ZERO;
    }
}

