/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.text.markup.XMLParserBase;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class XMLParserImpl
implements ContentHandler,
ErrorHandler {
    private final XMLParserBase mClient;

    XMLParserImpl(XMLParserBase client) {
        this.mClient = client;
    }

    public void processText(String sText) {
        try {
            StringReader stringReader = new StringReader(sText);
            InputSource inputSource = new InputSource(stringReader);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void characters(char[] content, int start, int length) throws SAXException {
        this.mClient.onContent(new String(content, start, length));
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.mClient.onEndTag(this.resolveElement(uri, localName, qName));
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] content, int start, int length) throws SAXException {
        this.characters(content, start, length);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.mClient.onStartTag(this.resolveElement(uri, localName, qName), attributes);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    private String resolveElement(String uri, String localName, String qName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        if (qName != null && qName.length() > 0) {
            return qName;
        }
        return uri;
    }
}

