/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.font.FontService;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.TextMarkupBase;
import com.adobe.xfa.ut.Storage;

public abstract class MarkupIn {
    private static final Byte NULL_BYTE = 0;
    private final TextAttr moPrevAttr = new TextAttr();
    private final TextAttr moPendingAttr = new TextAttr();
    private TextMarkupBase mpoBase;
    private boolean mbFirstPara = true;
    private Storage<Byte> moMBText;
    private TextGfxSource moGfxSource;
    private boolean mbLegacyBlankLineMode = true;

    public abstract void translate();

    public void setup(TextMarkupBase poBase, TextGfxSource poGfxSource) {
        this.moPrevAttr.setDefault(false);
        this.moPendingAttr.setDefault(false);
        this.mpoBase = poBase;
        if (poGfxSource != null) {
            this.moGfxSource = poGfxSource;
        }
    }

    protected MarkupIn() {
    }

    protected void text(String sText) {
        if (sText.length() == 0) {
            return;
        }
        this.commitPending(true);
        this.mpoBase.text(sText);
        this.mbFirstPara = false;
    }

    protected void attr(TextAttr oAttr) {
        this.moPendingAttr.override(oAttr);
    }

    protected void mbText(byte[] cText) {
        if (cText[0] == 0) {
            return;
        }
        this.commitPending();
        if (this.moMBText == null) {
            this.moMBText = new Storage();
        }
        if (this.moMBText.size() == 0) {
            this.moMBText.add(NULL_BYTE);
        }
        int i = 0;
        while (cText[i] != 0) {
            this.moMBText.removeLast();
            this.moMBText.add(cText[i]);
            this.moMBText.add(NULL_BYTE);
            ++i;
        }
    }

    protected String mbText() {
        if (this.hasPendingMBText()) {
            byte[] bytes = new byte[this.moMBText.size()];
            for (int i = 0; i < this.moMBText.size(); ++i) {
                Byte b = (Byte)this.moMBText.get(i);
                bytes[i] = b;
            }
            this.moMBText.clear();
            return new String(bytes);
        }
        return "";
    }

    protected boolean hasPendingMBText() {
        return this.moMBText != null && this.moMBText.size() > 0;
    }

    protected void para() {
        if (this.mpoBase.issueFirstPara() || !this.mbFirstPara) {
            this.commitPending();
            this.mpoBase.para();
        }
        this.mbFirstPara = false;
    }

    protected void field(TextField poField) {
        this.commitPending(true);
        this.mpoBase.field(poField);
        if (!this.mbLegacyBlankLineMode) {
            this.mbFirstPara = false;
        }
    }

    protected void openScopedBlock() {
        this.mpoBase.openScopedBlock();
    }

    protected void closeScopedBlock() {
        this.mpoBase.closeScopedBlock();
    }

    protected TextMarkupBase posn() {
        return this.mpoBase;
    }

    protected void commitPending(boolean bForceMBText) {
        if ((bForceMBText || !this.moPendingAttr.isEmpty()) && this.moMBText != null && this.moMBText.size() > 0) {
            this.mpoBase.text(this.mbText());
        }
        if (!this.moPendingAttr.isEmpty()) {
            TextAttr oDiffs = new TextAttr();
            this.moPrevAttr.override(this.moPendingAttr, oDiffs);
            if (!oDiffs.isEmpty()) {
                this.mpoBase.attr(oDiffs);
            }
            this.moPendingAttr.setDefault(false);
        }
    }

    protected void commitPending() {
        this.commitPending(false);
    }

    protected FontService fontService() {
        return this.moGfxSource.getFontService();
    }

    protected boolean legacyPositioning() {
        return this.mpoBase == null ? false : this.mpoBase.legacyPositioning();
    }

    protected boolean legacyBlankLineMode() {
        return this.mbLegacyBlankLineMode;
    }

    protected void setLegacyBlankLineMode(boolean bLegacyBlankLineMode) {
        this.mbLegacyBlankLineMode = bLegacyBlankLineMode;
    }
}

