/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXMappingList;
import com.adobe.xfa.text.AFEAttrMap;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.LineDesc;
import com.adobe.xfa.text.LocaleInfo;
import com.adobe.xfa.text.MappingManager;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextIntArray;
import com.adobe.xfa.ut.LcLocale;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TextContext {
    private static final int BREAK_CANDIDATE_MIN = 100;
    private DispMapSet mpoDisposableMaps;
    private boolean mbMapsCheckedOut;
    private boolean[] moBreakCandidates;
    private final Map<String, LocaleInfo> moLocalePool = new HashMap<String, LocaleInfo>();
    private final TextIntArray moAccentRun = new TextIntArray();
    private final TextIntArray moGlyphArray = new TextIntArray();
    private GFXMappingList mpoMappingList;
    private MappingManager mMappingManager;
    private AFEAttrMap mAFEAttrMap = new AFEAttrMap(this);
    private FileWriter mDebugFile;
    private static final boolean gEnableDebug = false;

    public void detach() {
        if (this.mDebugFile != null) {
            try {
                this.mDebugFile.write(this.mAFEAttrMap.toString());
                this.mDebugFile.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.mDebugFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    LocaleInfo lookupLocale(String sLocaleName) {
        LocaleInfo oLocaleInfo = this.moLocalePool.get(sLocaleName);
        if (oLocaleInfo != null) {
            return oLocaleInfo;
        }
        LcLocale poLocale = new LcLocale(sLocaleName);
        oLocaleInfo = new LocaleInfo(poLocale, poLocale.isBIDI(), poLocale.isIdeographic(), poLocale.needsDictionaryBreaking(), 1);
        this.moLocalePool.put(sLocaleName, oLocaleInfo);
        return oLocaleInfo;
    }

    DispMapSet getDisposableMaps() {
        if (this.mpoDisposableMaps == null) {
            this.mpoDisposableMaps = new DispMapSet();
        }
        if (this.mbMapsCheckedOut) {
            return new DispMapSet();
        }
        this.mbMapsCheckedOut = true;
        return this.mpoDisposableMaps;
    }

    void releaseDisposableMaps(DispMapSet poMaps) {
        if (poMaps == this.mpoDisposableMaps) {
            this.mbMapsCheckedOut = false;
        }
    }

    boolean[] getBreakCandidates(int nCount, int nPreserve) {
        if (nCount < 100) {
            nCount = 100;
        }
        if (this.moBreakCandidates == null) {
            assert (nPreserve == 0);
            this.moBreakCandidates = new boolean[nCount];
        } else if (nCount > this.moBreakCandidates.length) {
            assert (nPreserve <= this.moBreakCandidates.length);
            boolean[] newCandidates = new boolean[nCount];
            for (int i = 0; i < nPreserve; ++i) {
                newCandidates[i] = this.moBreakCandidates[i];
            }
            this.moBreakCandidates = newCandidates;
        }
        return this.moBreakCandidates;
    }

    int[] getAccentRun(int size) {
        return this.moAccentRun.setSize(size, true);
    }

    int[] getGlyphArray() {
        return this.moGlyphArray.getArray();
    }

    int[] getGlyphArray(int size) {
        return this.moGlyphArray.setSize(size, true);
    }

    GFXMappingList getMappingList() {
        if (this.mpoMappingList == null) {
            this.mpoMappingList = new GFXMappingList();
        }
        return this.mpoMappingList;
    }

    DispLineWrapped allocateWrappedLine(TextFrame poFrame, LineDesc oLineDesc) {
        DispLineWrapped poLine = new DispLineWrapped();
        poLine.initialize(poFrame, oLineDesc);
        return poLine;
    }

    void releaseWrappedLine(DispLineWrapped poLine) {
    }

    MappingManager getMappingManager() {
        if (this.mMappingManager == null) {
            this.mMappingManager = new MappingManager();
        }
        return this.mMappingManager;
    }

    AFEAttrMap getAFEAttrMap() {
        return this.mAFEAttrMap;
    }

    boolean debug() {
        return this.mDebugFile != null;
    }

    void debug(String data) {
        if (this.mDebugFile != null) {
            try {
                this.mDebugFile.write(data);
                this.mDebugFile.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

