/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.markup.MarkupOut;
import java.util.List;

class StrField
extends StrItem {
    protected final TextField mpoField;
    protected int meLegacyLevel;

    StrField(TextField poNewField, TextGfxSource oGfxSource, int eLegacyLevel) {
        super(3);
        this.mpoField = poNewField.cloneField();
        this.cascadeLegacyLevel(eLegacyLevel);
    }

    @Override
    void addField(List<TextField> oFields) {
        oFields.add(this.mpoField);
    }

    @Override
    TextAttr markup(MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
        if (!bFlattenFields) {
            oMarkup.field(this.mpoField);
        } else {
            this.mpoField.markup(oMarkup, null, true, false);
            poPrevAttr = null;
        }
        return poPrevAttr;
    }

    @Override
    TextField fieldAt(int nIndex) {
        return this.mpoField;
    }

    @Override
    boolean isEqual(StrItem poCompare) {
        if (!(poCompare instanceof StrField)) {
            return false;
        }
        StrField poFieldItem = (StrField)poCompare;
        TextField poCompareField = poFieldItem.mpoField;
        if (this.mpoField == null || poCompareField == null) {
            return this.mpoField == poCompareField;
        }
        return this.mpoField.isEqual(poCompareField);
    }

    @Override
    StrItem cloneItem(TextGfxSource oGfxSource) {
        return new StrField(this.mpoField, oGfxSource, this.meLegacyLevel);
    }

    @Override
    void gfxSource(TextGfxSource oGfxSource) {
        if (this.mpoField != null) {
            this.mpoField.gfxSource(oGfxSource);
        }
    }

    @Override
    void cascadeLegacyLevel(int eLevel) {
        this.meLegacyLevel = eLevel;
        if (this.mpoField != null) {
            this.mpoField.setLegacyLevel(eLevel);
        }
    }

    @Override
    void debug(int indent) {
        System.out.println(Pkg.doIndent(indent + 1) + "Field");
        if (this.mpoField != null) {
            this.mpoField.debug(indent + 1);
        }
    }
}

