/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.AFEElement;
import com.adobe.xfa.text.DispEmbed;
import com.adobe.xfa.text.DispMap;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphExtra;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.Storage;

class DispLine {
    static final int CARET_INVALID = 0;
    static final int CARET_CONDITIONAL = 1;
    static final int CARET_PRESENT = 2;
    static final int INTERNAL_LINE = 0;
    static final int TAB_TO_END = 1;
    static final int HARD_NEW_LINE = 2;
    static final int REAL_LAST_LINE = 3;
    static final int LINE_BREAK_NORMAL = 0;
    static final int LINE_BREAK_HYPHEN_SUPPRESS = 1;
    static final int LINE_BREAK_HYPHEN = 2;
    static final int LINE_BREAK_FORCED = 3;
    static final int POSN_TYPE_INVALID = 0;
    static final int POSN_TYPE_RUN = 1;
    static final int POSN_TYPE_LIGATURE = 2;
    static final int POSN_TYPE_MULTIPLE = 3;
    private TextDisplay mpoDisplay;
    private TextFrame mpoFrame;
    private DispMapSet mpoMaps;
    private float moWidth;
    private float moTrailingWidth;
    private int mnVisualCharCount;
    private Storage<GlyphExtra> moGlyphExtra;
    private int[] moGlyphLocOrder;
    private boolean mbVerticalOrientation;
    private boolean mbHasBIDI;
    private boolean mbOptycaJustify;
    private boolean mbOptycaMapping;
    private boolean mbIsFirstLineInStream;
    private boolean mbIsLastLineInStream;
    private boolean mbIsFirstParaLine;
    private boolean mbHasDecoration;
    private boolean mbHasSingleColour;
    private boolean mbHasAXTEMappings;
    private boolean mbIsLayoutLine;
    private boolean mbIsRTL;
    private boolean mbEndInMiddle;
    private int meLastParaLine;
    private int meStartBreak;
    private int meEndBreak;

    DispLine(TextFrame poFrame) {
        this.mpoMaps = poFrame.getDisposableMaps();
        this.initialize(poFrame);
    }

    DispLine(DispMapSet poMaps) {
        this.mpoMaps = poMaps;
    }

    DispLine() {
    }

    void detach() {
        this.mpoFrame.releaseDisposableMaps(this.mpoMaps);
        this.mpoMaps.clear();
    }

    void initialize(TextFrame poFrame) {
        this.mpoFrame = poFrame;
        this.mpoDisplay = poFrame.display();
        this.mbHasBIDI = false;
        this.meLastParaLine = 0;
        this.meStartBreak = 0;
        this.meEndBreak = 0;
        this.mbIsRTL = this.mpoDisplay.isRTL();
    }

    TextSparseStream stream() {
        return this.mpoFrame.getStream();
    }

    TextDisplay display() {
        return this.mpoDisplay;
    }

    TextFrame frame() {
        return this.mpoFrame;
    }

    void setFrame(TextFrame poFrame) {
        this.mpoFrame = poFrame;
    }

    void setVerticalOrientation(boolean bVerticalOrientation) {
        this.mbVerticalOrientation = bVerticalOrientation;
    }

    boolean verticalOrientation() {
        return this.mbVerticalOrientation;
    }

    boolean hasBIDI() {
        return this.mbHasBIDI;
    }

    void setHasBIDI(boolean bHasBIDI) {
        this.mbHasBIDI = bHasBIDI;
    }

    boolean optycaJustify() {
        return this.mbOptycaJustify;
    }

    void setOptycaJustify(boolean bOptycaJustify) {
        this.mbOptycaJustify = bOptycaJustify;
    }

    boolean optycaMapping() {
        return this.mbOptycaMapping;
    }

    void setOptycaMapping(boolean bOptycaMapping) {
        this.mbOptycaMapping = bOptycaMapping;
    }

    boolean isFirstLineInStream() {
        return this.mbIsFirstLineInStream;
    }

    void setFirstLineInStream(boolean bIsFirstLineInStream) {
        this.mbIsFirstLineInStream = bIsFirstLineInStream;
    }

    boolean isLastLineInStream() {
        return this.mbIsLastLineInStream;
    }

    void setLastLineInStream(boolean bIsLastLineInStream) {
        this.mbIsLastLineInStream = bIsLastLineInStream;
    }

    boolean isFirstParaLine() {
        return this.mbIsFirstParaLine;
    }

    void setFirstParaLine(boolean bIsFirstParaLine) {
        this.mbIsFirstParaLine = bIsFirstParaLine;
    }

    boolean isLastParaLine() {
        return this.getLastParaLine() >= 3;
    }

    int getLastParaLine() {
        return this.meLastParaLine;
    }

    void setLastParaLine(int eLast) {
        this.meLastParaLine = eLast;
    }

    int getStartBreak() {
        return this.meStartBreak;
    }

    void setStartBreak(int eStartBreak) {
        this.meStartBreak = eStartBreak;
    }

    int getEndBreak() {
        return this.meEndBreak;
    }

    void setEndBreak(int eEndBreak) {
        this.meEndBreak = eEndBreak;
    }

    boolean hasDecoration() {
        return this.mbHasDecoration;
    }

    void setHasDecoration(boolean bHasDecoration) {
        this.mbHasDecoration = bHasDecoration;
    }

    boolean hasSingleColour() {
        return this.mbHasSingleColour;
    }

    void setHasSingleColour(boolean bHasSingleColour) {
        this.mbHasSingleColour = bHasSingleColour;
    }

    boolean hasAXTEMappings() {
        return this.mbHasAXTEMappings;
    }

    void setHasAXTEMappings(boolean bHasAXTEMappings) {
        this.mbHasAXTEMappings = bHasAXTEMappings;
    }

    boolean isLayoutLine() {
        return this.mbIsLayoutLine;
    }

    void setLayoutLine(boolean bIsLayoutLine) {
        this.mbIsLayoutLine = bIsLayoutLine;
    }

    boolean isRTL() {
        return this.mbIsRTL;
    }

    void setRTL(boolean bIsRTL) {
        this.mbIsRTL = bIsRTL;
    }

    boolean isEndInMiddle() {
        return this.mbEndInMiddle;
    }

    void setEndInMiddle(boolean bIsEndInMiddle) {
        this.mbEndInMiddle = bIsEndInMiddle;
    }

    boolean allowLastPosition(int eAffinity) {
        return this.mbIsLastLineInStream || this.mbEndInMiddle && eAffinity == 1;
    }

    int getCombCells() {
        return this.mpoFrame.getActualCombCells();
    }

    int getLegacyLevel() {
        return this.mpoFrame.getLegacyLevel();
    }

    boolean legacyPositioning() {
        return this.mpoFrame.getLegacyLevel() == -1;
    }

    int getCharCount() {
        return this.mpoMaps.mnCharCount;
    }

    int[] getCharArray() {
        return this.mpoMaps.getCharArray();
    }

    int getChar(int nIndex) {
        return this.mpoMaps.getChar(nIndex);
    }

    int[] getBreakArray() {
        return this.mpoMaps.getBreakArray();
    }

    int getBreakData(int nIndex) {
        return this.mpoMaps.getBreakData(nIndex);
    }

    int getBreakClass(int nIndex) {
        return TextCharProp.getBreakClass(this.mpoMaps.getBreakData(nIndex));
    }

    int getWidthClass(int nIndex) {
        return TextCharProp.getWidthClass(this.mpoMaps.getBreakData(nIndex));
    }

    int getGraphemeClass(int nIndex) {
        return TextCharProp.getGraphemeClass(this.mpoMaps.getBreakData(nIndex));
    }

    int getWordClass(int nIndex) {
        return TextCharProp.getWordClass(this.mpoMaps.getBreakData(nIndex));
    }

    void setChar(int nIndex, int c, int eBreak) {
        this.mpoMaps.setChar(nIndex, c, eBreak);
        this.testBIDI(c, eBreak);
    }

    void setBreak(int nIndex, int eBreak) {
        this.mpoMaps.setBreakData(nIndex, eBreak);
        this.testBIDI(this.mpoMaps.getChar(nIndex), eBreak);
    }

    void preAllocChars(int nChars) {
        this.mpoMaps.preAllocChars(nChars);
    }

    int getLastGlyphChar() {
        if (this.getGlyphCount() == 0 || this.getCharCount() == 0) {
            return 0;
        }
        GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(this.getGlyphCount() - 1);
        int nCharIndex = oGlyphLoc.getMapIndex() + oGlyphLoc.getMapLength() - 1;
        return this.getChar(nCharIndex);
    }

    int getVisualCharCount() {
        return this.mnVisualCharCount;
    }

    void setVisualCharCount(int nCount) {
        this.mnVisualCharCount = nCount;
    }

    boolean isVisualChar(int nCharIndex) {
        return nCharIndex < this.mnVisualCharCount;
    }

    boolean isValidPosition(int nCharIndex, int eAffinity) {
        return this.allowLastPosition(eAffinity) ? nCharIndex <= this.getCharCount() : nCharIndex < this.getCharCount();
    }

    boolean isValidPosition(int nCharIndex) {
        return this.isValidPosition(nCharIndex, 0);
    }

    DispMap getPositionMap() {
        return this.mpoMaps.moPosnMap;
    }

    int getPositionCount() {
        return this.mpoMaps.moPosnMap.size();
    }

    DispPosn getPosition(int nIndex) {
        return this.mpoMaps.getPosition(nIndex);
    }

    DispPosn getMappedPosition(int nCharIndex) {
        int nMapIndex = this.mpoMaps.moPosnMap.findItem(nCharIndex);
        assert (this.getPositionMap().isValidMapIndex(nMapIndex));
        return this.mpoMaps.getPosition(nMapIndex);
    }

    static int getPositionStreamCount(DispPosn oPosition) {
        return oPosition.getStreamCount() == 0 ? oPosition.getMapLength() : oPosition.getStreamCount();
    }

    static int getCharStreamCount(DispPosn oPosition) {
        int streamCount = oPosition.getStreamCount();
        return streamCount == 0 ? 1 : streamCount;
    }

    void clearPositionMap() {
        this.mpoMaps.moPosnMap.empty();
    }

    int charToStreamIndex(int nCharIndex, int nStreamOffset) {
        return DispLine.charToStreamIndex(this.getMappedPosition(nCharIndex), nCharIndex, nStreamOffset);
    }

    static int charToStreamIndex(DispPosn oPosition, int nCharIndex, int nStreamOffset) {
        int nCharOffset = nCharIndex - oPosition.getMapIndex();
        if (DispLine.getPositionType(oPosition) == 3 && nCharOffset < oPosition.getMapLength()) {
            nCharOffset = 0;
        }
        return nCharOffset + oPosition.pp().index() + nStreamOffset;
    }

    void charToStreamInfo(int nCharIndex, PosnInfo info) {
        DispLine.charToStreamInfo(this.getMappedPosition(nCharIndex), nCharIndex, info);
    }

    static void charToStreamInfo(DispPosn oPosition, int nCharIndex, PosnInfo info) {
        info.index = DispLine.charToStreamIndex(oPosition, nCharIndex, 0);
        info.auxInfo = 1;
        if (DispLine.getPositionType(oPosition) == 2) {
            info.auxInfo = DispLine.getPositionStreamCount(oPosition);
        }
    }

    TextPosnBase getStreamPosition(int nCharIndex, int nStreamOffset) {
        DispPosn oBasePosn = this.getMappedPosition(nCharIndex);
        return new TextPosnBase(oBasePosn.pp().stream(), DispLine.charToStreamIndex(oBasePosn, nCharIndex, nStreamOffset));
    }

    static int streamToCharIndex(DispPosn oPosition, int nStreamIndex, int nCharOffset) {
        int nCharRelative = nStreamIndex - oPosition.pp().index();
        if (DispLine.getPositionType(oPosition) == 2) {
            nCharRelative = 0;
        }
        return nCharRelative + oPosition.getMapIndex() + nCharOffset;
    }

    static void streamToCharIndex(DispPosn oPosition, int nStreamIndex, PosnInfo info) {
        info.index = DispLine.streamToCharIndex(oPosition, nStreamIndex, 0);
        info.auxInfo = 0;
        if (DispLine.getPositionType(oPosition) == 2) {
            info.auxInfo = nStreamIndex - oPosition.pp().index();
        }
    }

    static void streamToCharInfo(DispPosn oPosition, int nStreamIndex, PosnInfo info) {
        info.index = DispLine.streamToCharIndex(oPosition, nStreamIndex, 0);
        info.auxInfo = 1;
        if (DispLine.getPositionType(oPosition) == 3) {
            info.auxInfo = oPosition.getMapLength();
        }
    }

    static int getPositionType(DispPosn oPosn) {
        if (oPosn.getStreamCount() == 0) {
            return 1;
        }
        if (oPosn.getMapLength() == 1) {
            return 2;
        }
        if (oPosn.getStreamCount() == 1) {
            return 3;
        }
        return 0;
    }

    static boolean isValidPosition(DispPosn oPosn) {
        return DispLine.getPositionType(oPosn) != 0;
    }

    DispMap getRunMap() {
        return this.mpoMaps.moRunMap;
    }

    int getRunCount() {
        return this.mpoMaps.moRunMap.size();
    }

    DispRun getRun(int nIndex) {
        return this.mpoMaps.getRun(nIndex);
    }

    DispRun getMappedRun(int nCharIndex) {
        int nMapIndex = this.mpoMaps.moRunMap.findItem(nCharIndex);
        assert (this.getRunMap().isValidMapIndex(nMapIndex));
        return this.mpoMaps.getRun(nMapIndex);
    }

    TextAttr getMappedAttr(int nCharIndex) {
        return this.getMappedRun(nCharIndex).getAttr();
    }

    int getGlyphCount() {
        return this.mpoMaps.moGlyphs.size();
    }

    Glyph getGlyph(int nIndex) {
        return this.mpoMaps.getGlyph(nIndex);
    }

    Glyph getMappedGlyph(int nCharIndex) {
        GlyphLoc oGlyphLoc = this.getMappedGlyphLoc(nCharIndex);
        return this.getGlyph(oGlyphLoc.getGlyphIndex());
    }

    int nextGlyphBaseAccentIndex(int nStart) {
        int nGlyphs = this.getGlyphCount();
        if (nStart >= nGlyphs) {
            return nGlyphs;
        }
        Glyph poGlyph = this.getGlyph(nStart);
        int nIndex = nStart;
        if (!poGlyph.isRTL()) {
            ++nIndex;
        }
        while (nIndex < nGlyphs) {
            GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(nIndex);
            int nCharIndex = oGlyphLoc.getMapIndex();
            if (this.getBreakClass(nCharIndex) != 8) {
                if (!poGlyph.isRTL()) break;
                ++nIndex;
                break;
            }
            ++nIndex;
        }
        return nIndex;
    }

    void preAllocGlyphs(int nGlyphs, boolean bAllocGlyphLocs) {
        this.mpoMaps.preAllocGlyphs(nGlyphs, bAllocGlyphLocs);
    }

    GlyphExtra forceExtra(int nGlyphIndex) {
        Glyph oGlyph = this.getGlyph(nGlyphIndex);
        GlyphExtra poExtra = oGlyph.getExtra(this);
        if (poExtra == null) {
            if (this.moGlyphExtra == null) {
                this.moGlyphExtra = new Storage();
            }
            int nIndex = this.moGlyphExtra.size();
            this.moGlyphExtra.setSize(this.moGlyphExtra.size() + 1);
            poExtra = new GlyphExtra();
            this.moGlyphExtra.set(nIndex, poExtra);
            oGlyph.setExtraIndex(nIndex);
        }
        poExtra.setWidth(oGlyph.getOriginalNextX() - oGlyph.getOriginalX());
        return poExtra;
    }

    GlyphExtra getGlyphExtra(int nGlyphIndex) {
        return (GlyphExtra)this.moGlyphExtra.get(nGlyphIndex);
    }

    void preAllocExtra(int nSize) {
        if (nSize > 0) {
            if (this.moGlyphExtra == null) {
                this.moGlyphExtra = new Storage();
            }
            if (nSize > this.moGlyphExtra.size()) {
                this.moGlyphExtra.ensureCapacity(nSize);
            }
        }
    }

    DispMap getGlyphLocMap() {
        return this.mpoMaps.moGlyphLocMap;
    }

    GlyphLoc getGlyphLoc(int nIndex) {
        if (this.mpoMaps.moGlyphLocMap.size() == 0) {
            return new GlyphLoc(nIndex, nIndex, 1);
        }
        return this.mpoMaps.getGlyphLoc(nIndex);
    }

    GlyphLoc getMappedGlyphLoc(int nCharIndex) {
        if (this.mpoMaps.moGlyphLocMap.size() == 0) {
            return this.getGlyphLoc(nCharIndex);
        }
        int nMapIndex = this.mpoMaps.moGlyphLocMap.findItem(nCharIndex);
        assert (this.getGlyphLocMap().isValidMapIndex(nMapIndex));
        return this.mpoMaps.getGlyphLoc(nMapIndex);
    }

    int getGlyphLocCharIndex(int nGlyphLocIndex) {
        if (this.mpoMaps.moGlyphLocMap.size() == 0) {
            return nGlyphLocIndex;
        }
        return this.mpoMaps.getGlyphLoc(nGlyphLocIndex).getMapIndex();
    }

    GlyphLoc getOrderedGlyphLoc(int nGlyphIndex) {
        return this.getGlyphLoc(this.getGlyphLocOrder(nGlyphIndex));
    }

    int getGlyphLocOrder(int nGlyphIndex) {
        return this.moGlyphLocOrder == null || this.moGlyphLocOrder.length == 0 ? nGlyphIndex : this.moGlyphLocOrder[nGlyphIndex];
    }

    void setGlyphLocOrder(int nGlyphIndex, int nGlyphLocIndex) {
        this.moGlyphLocOrder[nGlyphIndex] = nGlyphLocIndex;
    }

    void allocateGlyphLocOrder(int glyphCount) {
        if (this.moGlyphLocOrder == null || this.moGlyphLocOrder.length < glyphCount) {
            this.moGlyphLocOrder = new int[glyphCount];
        }
    }

    DispMap getEmbedMap() {
        return this.mpoMaps.moEmbedMap;
    }

    int getEmbedCount() {
        return this.mpoMaps.moEmbedMap.size();
    }

    DispEmbed getEmbed(int nIndex) {
        return this.mpoMaps.getEmbed(nIndex);
    }

    DispEmbed isObject(int nCharIndex) {
        int nEmbedMapIndex = this.findObject(nCharIndex);
        if (nEmbedMapIndex < 0) {
            return null;
        }
        DispEmbed oEmbed = this.mpoMaps.getEmbed(nEmbedMapIndex);
        if (oEmbed.getMapIndex() != nCharIndex) {
            return null;
        }
        return oEmbed;
    }

    DispEmbed isObject(GlyphLoc oGlyphLoc) {
        if (oGlyphLoc.getMapLength() > 1) {
            return null;
        }
        return this.isObject(oGlyphLoc.getMapIndex());
    }

    int findObject(int nCharIndex) {
        int nEmbedMapIndex = this.mpoMaps.moEmbedMap.findItem(nCharIndex);
        if (!this.mpoMaps.moEmbedMap.isValidMapIndex(nEmbedMapIndex)) {
            return -1;
        }
        return nEmbedMapIndex;
    }

    int findObject(GlyphLoc oGlyphLoc) {
        if (oGlyphLoc.getMapLength() > 1) {
            return -1;
        }
        return this.findObject(oGlyphLoc.getMapIndex());
    }

    DispTab tabAt(int nCharIndex) {
        if (this.mpoMaps.moEmbedMap.size() == 0) {
            return null;
        }
        DispEmbed dispEmbed = this.isObject(nCharIndex);
        if (dispEmbed == null) {
            return null;
        }
        TextEmbed embed = dispEmbed.getEmbed();
        if (!(embed instanceof DispTab)) {
            return null;
        }
        return (DispTab)embed;
    }

    void addChar(int c, int eBreak) {
        this.mpoMaps.addChar(c, eBreak);
        this.mnVisualCharCount = this.mpoMaps.mnCharCount;
        this.testBIDI(c, eBreak);
    }

    void add(DispEmbed oAdd, int nStart) {
        this.mpoMaps.moEmbedMap.add(oAdd, nStart);
    }

    void add(DispPosn oAdd, int nStart, int nLength) {
        this.mpoMaps.moPosnMap.add(oAdd, nStart, nLength);
        if (DispLine.getPositionType(this.getPosition(this.getPositionCount() - 1)) != 1) {
            this.setHasAXTEMappings(true);
        }
    }

    void add(DispRun oAdd, int nStart, int nLength) {
        this.mpoMaps.moRunMap.add(oAdd, nStart, nLength);
        if (this.mbHasBIDI) {
            return;
        }
        if (oAdd.isRTL()) {
            this.mbHasBIDI = true;
        } else {
            TextAttr poAttr = oAdd.getAttr();
            int eDigits = this.display().getDigits(poAttr);
            if (eDigits != 0 && eDigits != 1) {
                this.mbHasBIDI = true;
            }
            if (poAttr != null) {
                if (poAttr.direction() == 2 || poAttr.paraDirection() == 2) {
                    this.mbHasBIDI = true;
                } else if (poAttr.invisibleEnable() && poAttr.invisible()) {
                    char c = poAttr.invisChar();
                    this.testBIDI(c, TextCharProp.getCharProperty(c));
                }
            }
        }
    }

    void add(Glyph oAdd) {
        this.mpoMaps.moGlyphs.add(oAdd);
    }

    void add(GlyphLoc oAdd, int nStart, int nLength) {
        this.mpoMaps.moGlyphLocMap.add(oAdd, nStart, nLength);
    }

    float getWidth() {
        return this.moWidth;
    }

    void setWidth(float oWidth) {
        this.moWidth = oWidth;
    }

    float getTrailingWidth() {
        return this.moTrailingWidth;
    }

    void setTrailingWidth(float oWidth) {
        this.moTrailingWidth = oWidth;
    }

    int findPosition(TextPosnBase oPosn, PosnInfo info) {
        int eCaret = 0;
        DispPosn matchPosn = null;
        info.index = 0;
        info.auxInfo = 0;
        info.posnIndex = 0;
        TextPosnBase oFwdPosn = new TextPosnBase(oPosn);
        oFwdPosn.tighten(true);
        TextPosnBase oBkwdPosn = null;
        for (int i = 0; i < this.getPositionCount(); ++i) {
            DispPosn oTestPosn = this.getPosition(i);
            int nAfterIndex = oTestPosn.pp().index() + DispLine.getPositionStreamCount(oTestPosn);
            if (oFwdPosn.stream() != oTestPosn.pp().stream() || oFwdPosn.index() < oTestPosn.pp().index()) continue;
            if (oFwdPosn.index() < nAfterIndex) {
                matchPosn = oTestPosn;
                DispLine.streamToCharIndex(oTestPosn, oFwdPosn.index(), info);
                eCaret = 2;
                info.posnIndex = i;
                break;
            }
            TextPosnBase poEqualTest = null;
            if (oFwdPosn.index() == nAfterIndex) {
                poEqualTest = oFwdPosn;
            } else {
                if (oBkwdPosn == null) {
                    oBkwdPosn = new TextPosnBase(oPosn);
                    oBkwdPosn.tighten(false);
                }
                if (oBkwdPosn.index() == nAfterIndex) {
                    poEqualTest = oBkwdPosn;
                }
            }
            if (poEqualTest == null) continue;
            eCaret = i + 1 < this.getPositionCount() || this.allowLastPosition(oPosn.affinity()) ? 2 : 1;
            matchPosn = oTestPosn;
            DispLine.streamToCharIndex(oTestPosn, poEqualTest.index(), info);
            info.posnIndex = i;
            break;
        }
        if (matchPosn != null && !this.isValidPosition(info.index, oPosn.affinity())) {
            eCaret = 1;
        }
        return eCaret;
    }

    static boolean isUnicodeFont(TextAttr poAttr) {
        return false;
    }

    void removeContent(int nStart, int nLength) {
        if (nLength == 0) {
            return;
        }
        int nOldLength = this.getCharCount();
        int nRestIndex = nStart + nLength;
        assert (nRestIndex <= nOldLength);
        int nNewLength = nOldLength - nLength;
        this.mpoMaps.preAllocChars(nNewLength, true);
        float oWidthRemoved = 0.0f;
        if (!this.mbHasBIDI) {
            oWidthRemoved = this.removeGlyphs(nStart, nLength);
        } else {
            int nCharRangeStart = 0;
            int nCharRangeLimit = 0;
            int nGlyphStart = 0;
            int nGlyphCount = 0;
            for (int nGlyph = 0; nGlyph < this.getGlyphCount(); ++nGlyph) {
                GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(nGlyph);
                int nCharIndex = oGlyphLoc.getMapIndex();
                if (nCharIndex < nStart || nCharIndex >= nRestIndex) continue;
                int nCharLimit = nCharIndex + oGlyphLoc.getMapLength();
                assert (nCharLimit <= nRestIndex);
                if (nGlyphCount == 0) {
                    nCharRangeStart = nCharIndex;
                    nCharRangeLimit = nCharLimit;
                    nGlyphStart = nGlyph;
                    nGlyphCount = 1;
                    continue;
                }
                if (nCharIndex == nCharRangeLimit) {
                    nCharRangeLimit = nCharLimit;
                    ++nGlyphCount;
                    continue;
                }
                if (nCharLimit == nCharRangeStart) {
                    nCharRangeStart = nCharIndex;
                    ++nGlyphCount;
                    continue;
                }
                oWidthRemoved += this.removeGlyphs(nGlyphStart, nGlyphCount);
                nCharRangeLimit = nCharRangeStart;
                nGlyphCount = 0;
            }
            oWidthRemoved += this.removeGlyphs(nGlyphStart, nGlyphCount);
        }
        this.moWidth -= oWidthRemoved;
        this.mpoMaps.moEmbedMap.removeRange(nStart, nLength);
        this.mpoMaps.moPosnMap.removeRange(nStart, nLength);
        this.mpoMaps.moRunMap.removeRange(nStart, nLength);
        if (this.mpoMaps.moGlyphLocMap.size() > 0) {
            this.mpoMaps.moGlyphLocMap.removeRange(nStart, nLength);
            for (int i = nStart; i < this.mpoMaps.moGlyphLocMap.size(); ++i) {
                this.getGlyphLoc(i).setGlyphIndex(i);
            }
        }
        this.mnVisualCharCount -= nLength;
    }

    void insertContent(DispLine poSource, int nIndex) {
        int i;
        assert (nIndex <= this.getCharCount());
        int nInsert = poSource.getCharCount();
        if (nInsert == 0) {
            return;
        }
        int nOldLength = this.getCharCount();
        int nNewLength = nOldLength + nInsert;
        this.mpoMaps.preAllocChars(nNewLength, true);
        this.mpoMaps.moEmbedMap.insertMap(poSource.mpoMaps.moEmbedMap, nIndex, nInsert);
        this.mpoMaps.moPosnMap.insertMap(poSource.mpoMaps.moPosnMap, nIndex, nInsert);
        this.mpoMaps.moRunMap.insertMap(poSource.mpoMaps.moRunMap, nIndex, nInsert);
        GlyphLoc oGlyphLoc = this.getMappedGlyphLoc(nIndex);
        int nGlyphIndex = oGlyphLoc.getGlyphIndex();
        int nGlyphRest = nGlyphIndex + poSource.getGlyphCount();
        float oShiftNew = nGlyphIndex >= this.getGlyphCount() ? this.getWidth() : this.getGlyph(nGlyphIndex).getOriginalX();
        int nOldGlyphs = this.getGlyphCount();
        int nInsertGlyphs = poSource.getGlyphCount();
        this.mpoMaps.moGlyphs.setSize(nOldGlyphs + nInsertGlyphs);
        for (i = nGlyphIndex; i < nGlyphRest; ++i) {
            this.getGlyph(i).shift(oShiftNew);
        }
        for (i = nGlyphRest; i < this.getGlyphCount(); ++i) {
            this.getGlyph(i).shift(oShiftNew);
        }
        if (this.mbHasBIDI || poSource.mbHasBIDI) {
            // empty if block
        }
        if (this.mpoMaps.moGlyphLocMap.size() > 0 || poSource.mpoMaps.moGlyphLocMap.size() > 0) {
            DispMap oTempMap = new DispMap();
            DispMap poSourceMap = poSource.mpoMaps.moGlyphLocMap;
            if (poSourceMap.size() == 0) {
                poSourceMap = oTempMap;
                DispLine.manufactureGlyphLocMap(nInsert, oTempMap);
            }
            if (this.mpoMaps.moGlyphLocMap.size() == 0) {
                DispLine.manufactureGlyphLocMap(nOldLength, this.mpoMaps.moGlyphLocMap);
            }
            this.mpoMaps.moGlyphLocMap.insertMap(poSourceMap, nIndex, nInsert);
            for (i = nIndex; i < this.getGlyphCount(); ++i) {
                this.getGlyphLoc(i).setGlyphIndex(i);
            }
        }
        this.moWidth += poSource.moWidth;
        this.mnVisualCharCount += nInsert;
    }

    TextAttr getLastAttr() {
        TextPosnBase oPosn = new TextPosnBase(this.stream(), Integer.MAX_VALUE);
        return oPosn.attributePtr();
    }

    void clear() {
        this.mpoMaps.clear();
    }

    void setMaps(DispMapSet maps) {
        this.mpoMaps = maps;
    }

    DispMapSet getMaps() {
        return this.mpoMaps;
    }

    private float removeGlyphs(int nStart, int nRemoveLength) {
        float oWidthRemoved = 0.0f;
        if (nRemoveLength == 0) {
            return oWidthRemoved;
        }
        int nNewLength = this.getGlyphCount() - nRemoveLength;
        float oStartX = this.getGlyph(nStart).getOriginalX();
        this.mpoMaps.moGlyphs.setSize(nNewLength);
        if (nStart >= this.getGlyphCount()) {
            return oWidthRemoved;
        }
        float oShift = oStartX - this.getGlyph(nStart).getOriginalX();
        for (int i = nStart; i < this.getGlyphCount(); ++i) {
            Glyph oGlyph = this.getGlyph(i);
            oWidthRemoved += oGlyph.getOriginalNextX() - oGlyph.getOriginalX();
            oGlyph.shift(oShift);
        }
        return oWidthRemoved;
    }

    private void testBIDI(int c, int eBreak) {
        if (this.mbHasBIDI) {
            return;
        }
        switch (TextCharProp.getBIDIClass(eBreak)) {
            case 0: 
            case 262144: 
            case 0x380000: 
            case 0x3C0000: 
            case 0x400000: {
                this.mbHasBIDI = true;
            }
        }
    }

    private static void manufactureGlyphLocMap(int nSize, DispMap oMap) {
        for (int i = 0; i < nSize; ++i) {
            GlyphLoc oGlyphLoc = new GlyphLoc(i);
            oMap.add(oGlyphLoc, i, 1);
        }
    }

    static class GlyphMaker {
        private final DispLine mLine;
        private float mWidth = 0.0f;
        private float mTrailingWidth = 0.0f;
        private float mCharSpacing;
        private float mWordSpacing;
        private DispRun mCurrentRun;

        GlyphMaker(DispLine line) {
            this.mLine = line;
        }

        void addGlyph(AFEElement afeElement, int charIndex) {
            int glyphIndex = this.mLine.getGlyphCount();
            if (this.mCurrentRun == null || charIndex < this.mCurrentRun.getMapIndex() || charIndex >= this.mCurrentRun.getMapIndex() + this.mCurrentRun.getMapLength()) {
                this.mCurrentRun = this.mLine.getMappedRun(charIndex);
                TextAttr attr = this.mCurrentRun.getAttr();
                this.mCharSpacing = attr.charSpacingEnable() ? Units.toFloat(attr.charSpacing().getLength()) : 0.0f;
                this.mWordSpacing = attr.wordSpacingEnable() ? Units.toFloat(attr.wordSpacing().getLength()) : 0.0f;
            }
            float charWidth = afeElement.getScaledXAdvance() + this.mCharSpacing;
            if (this.mLine.getBreakClass(charIndex) == 31) {
                charWidth += this.mWordSpacing;
            }
            Glyph glyph = new Glyph();
            glyph.setGlyph(afeElement.elementAt());
            glyph.setOriginalX(this.mWidth);
            this.mWidth += charWidth;
            glyph.setOriginalNextX(this.mWidth);
            glyph.setRenderByGlyphID(afeElement.renderByGlyphID());
            glyph.setRTL(afeElement.isRTL());
            this.mLine.add(glyph);
            float offsetX = afeElement.getScaledXPlacement();
            float offsetY = afeElement.getScaledYPlacement();
            if (offsetX != 0.0f || offsetY != 0.0f) {
                GlyphExtra glyphExtra = this.mLine.forceExtra(glyphIndex);
                glyphExtra.setOffsetX(offsetX);
                glyphExtra.setY(offsetY);
                this.mLine.getGlyph(glyphIndex).setShifted(true);
            }
            if (!this.mLine.isVisualChar(charIndex) && this.mLine.getBreakClass(charIndex) == 31) {
                this.mTrailingWidth += charWidth;
            }
        }

        void applyWidths() {
            this.mLine.setWidth(this.mWidth);
            this.mLine.setTrailingWidth(this.mTrailingWidth);
        }
    }

    static class PosnInfo {
        int index;
        int auxInfo;
        int posnIndex = -1;

        PosnInfo() {
        }
    }
}

