/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Bool;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;

public final class Value
extends ProtoableNode {
    public Value(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "value", "value", null, XFA.VALUETAG, "value");
    }

    @Override
    public int defaultElement() {
        Element pUIElement;
        UI pUI;
        Element pParent = this.getXFAParent();
        if ((pParent instanceof Field || pParent instanceof Draw) && (pUI = (UI)pParent.getElement(XFA.UITAG, true, 0, false, false)) != null && (pUIElement = pUI.getUIElement(true)) != null) {
            int eValue;
            boolean bRichText;
            int eTag = pUIElement.getClassTag();
            if (eTag == XFA.NUMERICEDITTAG) {
                return XFA.FLOATTAG;
            }
            if (eTag == XFA.DATETIMEEDITTAG) {
                return XFA.DATETIMETAG;
            }
            if (eTag == XFA.IMAGEEDITTAG) {
                return XFA.IMAGETAG;
            }
            if (eTag == XFA.TEXTEDITTAG ? (bRichText = Bool.getValue((EnumValue)pUIElement.getAttribute(XFA.ALLOWRICHTEXTTAG))) : eTag == XFA.CHOICELISTTAG && (eValue = pUIElement.getEnum(XFA.OPENTAG)) == 0x230003) {
                return XFA.EXDATATAG;
            }
        }
        return XFA.TEXTTAG;
    }

    @Override
    protected Node defaultElementImpl(int eTag, int nOccurrence, boolean bAppend) {
        if (eTag == XFA.SCHEMA_DEFAULTTAG) {
            eTag = this.defaultElement();
        }
        if (eTag == XFA.SCHEMA_DEFAULTTAG) {
            return null;
        }
        Node node = super.defaultElementImpl(eTag, nOccurrence, bAppend);
        if (node != null) {
            Content content = (Content)node;
            if (eTag == XFA.EXDATATAG) {
                StringAttr sTextHtml = new StringAttr("contentType", "text/html");
                content.setAttribute(sTextHtml, XFA.CONTENTTYPETAG);
            }
            content.setIsNull(true, false, false);
        }
        return node;
    }

    public Element replaceContent(int eTag) {
        Attribute oMaxChars = null;
        Node oOneOf = this.getOneOfChild(true, false);
        if (oOneOf != null) {
            if (oOneOf.isSameClass(XFA.TEXTTAG)) {
                oMaxChars = ((Element)oOneOf).getAttribute(XFA.MAXCHARSTAG, true, false);
            } else if (oOneOf.isSameClass(XFA.EXDATATAG)) {
                oMaxChars = ((Element)oOneOf).getAttribute(XFA.MAXLENGTHTAG, true, false);
            }
        }
        Element oNewNode = this.getModel().createElement(eTag, null);
        if (oMaxChars != null && oNewNode != null) {
            if (oNewNode.isSameClass(XFA.TEXTTAG)) {
                oNewNode.setAttribute(oMaxChars, XFA.MAXCHARSTAG);
            } else if (oNewNode.isSameClass(XFA.EXDATATAG)) {
                oNewNode.setAttribute(oMaxChars, XFA.MAXLENGTHTAG);
            }
        }
        this.setOneOfChild(oNewNode);
        return oNewNode;
    }
}

