/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Manifest;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.formatting.Button;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.StringUtils;
import java.util.List;

public class TemplateModelFixup {
    private final List<ExFull> mErrorList;
    private final List<Element> mErrorContextList;
    private final TemplateModel mModel;
    private final int meGenerator;
    private final int mnBuildNumber;
    private boolean mbFixupRenderCache;
    private boolean mbCheckedInteractive;
    private boolean mbIsInteractive;
    private boolean mbCheckedCache;

    public TemplateModelFixup(TemplateModel model, boolean bFixupRenderCache) {
        this.mModel = model;
        this.mErrorList = model.getErrorList();
        this.mErrorContextList = model.getErrorContextList();
        this.mbFixupRenderCache = bFixupRenderCache;
        Generator generator = this.mModel.getGenerator();
        if (generator != null) {
            this.meGenerator = generator.generator();
            this.mnBuildNumber = generator.getBuildNumber();
        } else {
            this.meGenerator = 0;
            this.mnBuildNumber = 0;
        }
    }

    public void processFixups() {
        for (int i = this.mErrorContextList.size(); i > 0; --i) {
            Element e = this.mErrorContextList.get(i - 1);
            boolean bHandled = false;
            if (e.getClassName() == "layout") {
                e.remove();
                bHandled = true;
            }
            if (this.meGenerator == 1 || this.meGenerator == 2 || this.meGenerator == 4 || this.meGenerator == 5 || this.meGenerator == 3) {
                if (this.meGenerator != 3 && e.isSameClass(XFA.EXTRASTAG)) {
                    bHandled = this.handleExtrasTag(e);
                }
                if (e.getName() == "desc" && !(e.getXFAParent() instanceof TemplateModel)) {
                    e.privateSetName("extras");
                }
                if (e.getName() == "ref" && !(e.getXFAParent() instanceof Manifest)) {
                    bHandled = this.upgradeXFARef(e);
                }
                if (e.getName() == "extras") {
                    if (e.getXFAParent() instanceof TemplateModel) {
                        bHandled = this.doDescFixup(e);
                    }
                    e.remove();
                }
            }
            if (!bHandled) continue;
            this.mErrorList.remove(i - 1);
            this.mErrorContextList.remove(i - 1);
        }
    }

    public void applyFixups(Node node) {
        if (node == null) {
            return;
        }
        if (this.stripRenderCache() && node instanceof ProcessingInstruction && (node.getName().equals("renderCache.bounds") || node.getName().equals("renderCache.textRun") || node.getName().equals("renderCache.line") || node.getName().equals("renderCache.subset") || node.getName().equals("renderCache.macro"))) {
            node.remove();
            return;
        }
        boolean bNodeRemoved = false;
        if (node instanceof Element && this.meGenerator != 0) {
            bNodeRemoved = this.fixupElement((Element)node);
        }
        if (!bNodeRemoved) {
            Node child = node.getFirstXMLChild();
            while (child != null) {
                Node nextChild = child.getNextXMLSibling();
                this.applyFixups(child);
                child = nextChild;
            }
        }
    }

    private boolean fixupElement(Element node) {
        boolean bRemoved = false;
        if (this.meGenerator == 52 && node instanceof Subform) {
            this.fixupTableAccessibility(node);
        }
        if (this.meGenerator == 50 || this.meGenerator == 51) {
            if (node.getName() == "exData") {
                this.fixupNameSpace(node);
            }
            if (this.mnBuildNumber < 4029 && node.getClassTag() == XFA.BORDERTAG) {
                bRemoved = this.fixup4SAPBorders(node);
            }
            if (bRemoved) {
                return bRemoved;
            }
            if (this.mnBuildNumber < 3346 && node.getClassTag() == XFA.VALIDATETAG) {
                this.fixupPictures(node);
            }
        }
        if ((this.meGenerator == 50 || this.meGenerator == 52 || this.meGenerator == 53 && this.mnBuildNumber < 5048) && node instanceof Field) {
            this.fixupDefaults((Field)node);
        }
        if (this.meGenerator == 53 || this.meGenerator == 54 || this.meGenerator == 55 || this.meGenerator == 56) {
            this.fixupButtonPresence(node);
        }
        return bRemoved;
    }

    private void fixupButtonPresence(Element node) {
        boolean bButtonFound = false;
        block0: for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() != XFA.UITAG) continue;
            for (Node child2 = child.getFirstXMLChild(); child2 != null; child2 = child2.getNextXFASibling()) {
                if (!(child2 instanceof Button)) continue;
                bButtonFound = true;
                break block0;
            }
            break;
        }
        if (!bButtonFound) {
            return;
        }
        if (!this.isFormInteractive()) {
            Attribute oPresenceAttr = node.getAttribute(XFA.PRESENCETAG, true, false);
            Attribute oRelevantAttr = node.getAttribute(XFA.RELEVANTTAG, true, false);
            if (oPresenceAttr != null && oRelevantAttr != null) {
                String sRelevant = "+print";
                if (oPresenceAttr.getAttrValue().equals(EnumAttr.getString(1076494337)) && oRelevantAttr.getAttrValue().equals(sRelevant)) {
                    node.setAttribute(new StringAttr("presence", EnumAttr.getString(1076494336)), XFA.PRESENCETAG);
                }
            }
        }
    }

    private boolean isFormInteractive() {
        if (!this.mbCheckedInteractive) {
            Node textNode;
            String sDestination = null;
            Node oConfigNode = this.mModel.resolveNode("$config.present.destination");
            if (oConfigNode != null && (textNode = oConfigNode.getFirstXFAChild()) instanceof TextNode) {
                sDestination = ((TextNode)textNode).getValue();
            }
            if (!StringUtils.isEmpty(sDestination)) {
                String sInteractive;
                Node textNode2;
                String sSOM = "$config.present.";
                sSOM = sSOM + sDestination;
                oConfigNode = this.mModel.resolveNode(sSOM = sSOM + ".interactive");
                if (oConfigNode != null && (textNode2 = oConfigNode.getFirstXFAChild()) instanceof TextNode && (sInteractive = ((TextNode)textNode2).getValue()).equals("1")) {
                    this.mbIsInteractive = true;
                }
            }
            this.mbCheckedInteractive = true;
        }
        return this.mbIsInteractive;
    }

    private void fixupDefaults(Field field) {
        Element oBind = null;
        Element oValue = null;
        for (Node child = field.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() == XFA.BINDTAG) {
                oBind = (Element)child;
                continue;
            }
            if (child.getClassTag() != XFA.VALUETAG) continue;
            oValue = (Element)child;
        }
        if (oBind == null || oValue == null) {
            return;
        }
        Element oPicture = null;
        for (Node child = oBind.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() != XFA.PICTURETAG) continue;
            oPicture = (Element)child;
            break;
        }
        if (oPicture == null) {
            return;
        }
        Node oPictChild = oPicture.getFirstXFAChild();
        if (oPictChild == null) {
            return;
        }
        String sPicture = oPictChild.getData();
        Attribute oLocale = field.getAttribute(XFA.LOCALETAG, true, false);
        String sLocale = oLocale != null ? oLocale.getAttrValue() : field.getXMLParent().getInstalledLocale();
        for (Node child = oValue.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            String sCanon;
            String sCanon2;
            PictureFmt oPict = new PictureFmt(sLocale);
            if (child.getClassTag() == XFA.FLOATTAG) {
                double d = ((FloatValue)child).getValue();
                sCanon2 = oPict.parse(Double.toString(d), sPicture, null);
                ((FloatValue)child).setValue(sCanon2, false, true, false);
                continue;
            }
            if (child.getClassTag() == XFA.DECIMALTAG) {
                double d = ((DecimalValue)child).getValue();
                sCanon2 = oPict.parse(Double.toString(d), sPicture, null);
                ((DecimalValue)child).setValue(sCanon2, false, true, false);
                continue;
            }
            if (child.getClassTag() == XFA.INTEGERTAG) {
                int i = ((IntegerValue)child).getValue();
                sCanon = oPict.parse(Integer.toString(i), sPicture, null);
                ((IntegerValue)child).setValue(sCanon, false);
                continue;
            }
            if (child.getClassTag() == XFA.DATETAG) {
                String date = ((DateValue)child).getValue();
                sCanon = oPict.parse(date, sPicture, null);
                ((DateValue)child).setValue(sCanon);
                continue;
            }
            if (child.getClassTag() == XFA.TIMETAG) {
                String time = ((TimeValue)child).getValue();
                sCanon = oPict.parse(time, sPicture, null);
                ((TimeValue)child).setValue(sCanon);
                continue;
            }
            if (child.getClassTag() != XFA.DATETIMETAG) continue;
            String dateTime = ((DateTimeValue)child).getValue();
            sCanon = oPict.parse(dateTime, sPicture, null);
            ((DateTimeValue)child).setValue(sCanon);
        }
    }

    private void fixupPictures(Element node) {
        boolean bPictureFound = false;
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() != XFA.PICTURETAG) continue;
            bPictureFound = true;
            break;
        }
        if (!bPictureFound) {
            Attribute oFormatTestAttr = node.getAttribute(XFA.FORMATTESTTAG, true, false);
            boolean bAdjust = true;
            if (oFormatTestAttr != null) {
                String sFormatTestAttrValue = oFormatTestAttr.getAttrValue();
                boolean bl = bAdjust = sFormatTestAttrValue.equals("error") || sFormatTestAttrValue.equals("warning");
            }
            if (bAdjust) {
                block1: for (Node child = node.getXFAParent().getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (child.getClassTag() != XFA.FORMATTAG) continue;
                    for (Node picture = child.getFirstXFAChild(); picture != null; picture = picture.getNextXFASibling()) {
                        if (picture.getClassTag() != XFA.PICTURETAG) continue;
                        picture.clone(node);
                        break block1;
                    }
                    break;
                }
            }
        }
    }

    private boolean fixup4SAPBorders(Element node) {
        boolean bRemoved = false;
        boolean bHasFill = false;
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() == XFA.EDGETAG || child.getClassTag() == XFA.CORNERTAG) {
                return bRemoved;
            }
            if (child.getClassTag() != XFA.FILLTAG) continue;
            for (Node oFillChild = child.getFirstXMLChild(); oFillChild != null; oFillChild = oFillChild.getNextXMLSibling()) {
                if (!(oFillChild instanceof Element)) continue;
                bHasFill = true;
            }
            if (bHasFill) continue;
            child.remove();
        }
        if (!bHasFill) {
            node.remove();
            bRemoved = true;
        } else {
            Element oEdge = this.mModel.createElement("edge", null, node);
            oEdge.setAttribute(new StringAttr("presence", "hidden"), XFA.PRESENCETAG);
        }
        return bRemoved;
    }

    private void fixupNameSpace(Element node) {
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassName() != "body") continue;
            ((Element)child).setNS("http://www.w3.org/1999/xhtml");
            break;
        }
    }

    private void fixupTableAccessibility(Element node) {
        Attribute oAttr = node.getAttribute(XFA.LAYOUTTAG);
        if (oAttr != null && oAttr.getAttrValue().equals(EnumAttr.getString(1769477))) {
            Element oParent;
            Attribute oOverflowLeaderAttr;
            Element oBreak = null;
            for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (child.getClassTag() != XFA.BREAKTAG) continue;
                oBreak = (Element)child;
                break;
            }
            if (oBreak != null && (oOverflowLeaderAttr = oBreak.getAttribute(XFA.OVERFLOWLEADERTAG, true, false)) != null && (oParent = node.getXFAParent()) instanceof Subform && (oAttr = oParent.getAttribute(XFA.LAYOUTTAG, true, false)) != null && oAttr.getAttrValue().equals(EnumAttr.getString(1769476))) {
                String aOverFlowLeader;
                String aModelNamespace;
                String sOverFlowLeader = oOverflowLeaderAttr.getAttrValue();
                sOverFlowLeader = sOverFlowLeader.substring(1);
                Document doc = node.getOwnerDocument();
                Element oHeader = doc.getElementByXFAId(aModelNamespace = ((Element)this.mModel.getXmlPeer()).getNS(), aOverFlowLeader = sOverFlowLeader.intern());
                if (oHeader instanceof Subform) {
                    Element oAssist = oHeader.peekElement(XFA.ASSISTTAG, false, 0);
                    if (oAssist == null) {
                        oAssist = this.mModel.createElement("assist", "assist", oHeader);
                    }
                    assert (oAssist != null);
                    if (oAssist != null) {
                        oAssist.setAttribute(new StringAttr("role", "TH"), XFA.ROLETAG);
                    }
                }
            }
        }
    }

    private boolean handleExtrasTag(Element e) {
        for (int i = 0; i < e.getNumAttrs(); ++i) {
            Attribute a = e.getAttr(i);
            if (a.getQName() != "type") continue;
            e.removeAttr(i);
            return true;
        }
        return false;
    }

    private boolean upgradeXFARef(Element e) {
        boolean bHandled = false;
        Element parent = e.getXFAParent();
        if (parent.getName() == "traverse") {
            TextNode oText = e.getText(false, false, false);
            if (oText != null) {
                String sRefValue = oText.getValue();
                parent.setAttribute(new StringAttr("ref", sRefValue), XFA.REFTAG);
            }
            bHandled = true;
        }
        if (parent.getName() == "traverse" || parent.getName() == "value") {
            parent.removeChild(e);
            bHandled = true;
        }
        return bHandled;
    }

    private boolean doDescFixup(Element e) {
        Element template = e.getXFAParent();
        assert (template instanceof TemplateModel);
        Element oTopLevelSubform = (Element)template.resolveNode("#subform");
        if (oTopLevelSubform == null) {
            return false;
        }
        Element oDesc = (Element)oTopLevelSubform.resolveNode("#desc");
        if (oDesc == null) {
            oDesc = template.getModel().createElement("desc", "desc", oTopLevelSubform);
        }
        Node nextSibling = null;
        Node child = e.getFirstXMLChild();
        while (child != null) {
            nextSibling = child.getNextXMLSibling();
            if (child instanceof Element) {
                Attribute attribute;
                Element childElement = (Element)child;
                if (childElement.isPropertyValid(XFA.NAMETAG) && (attribute = childElement.peekAttribute(XFA.NAMETAG)) != null) {
                    String sName = attribute.toString();
                    if (sName.equals("DC.Date")) {
                        childElement.setAttribute(new StringAttr("name", "issued"), XFA.NAMETAG);
                    } else if (sName.startsWith("DC.")) {
                        childElement.setAttribute(new StringAttr("name", sName.substring(3)), XFA.NAMETAG);
                    } else if (sName.equals("CreationDate")) {
                        childElement.setAttribute(new StringAttr("name", "created"), XFA.NAMETAG);
                    }
                }
                oDesc.appendChild(childElement, false);
            }
            child = nextSibling;
        }
        return true;
    }

    private boolean stripRenderCache() {
        if (!this.mbCheckedCache) {
            Node oConfigNode;
            if (!this.mbFixupRenderCache && (oConfigNode = this.mModel.resolveNode("$config.present.cache.renderCache", true, false, false)) != null && ((Element)oConfigNode).getEnum(XFA.ENABLETAG) == 0x40040000) {
                this.mbFixupRenderCache = true;
            }
            this.mbCheckedCache = true;
        }
        return this.mbFixupRenderCache;
    }
}

