/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.qrcodepmp;

import com.adobe.xfa.pmp.qrcodepmp.QRCodeEncoderErrorCode;
import com.adobe.xfa.pmp.qrcodepmp.QRCodeEncoderException;
import com.adobe.xfa.pmp.qrcodepmp.denso.QRC;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

class QRCodeImageBuilder {
    private QRC qrc;

    QRCodeImageBuilder() {
    }

    BufferedImage buildImage(int imageCols, int imageRows, int xDimension) throws QRCodeEncoderException {
        if (imageCols <= 0) {
            imageCols = (this.qrc.Csize + 8) * xDimension;
        }
        if (imageRows <= 0) {
            imageRows = (this.qrc.Csize + 8) * xDimension;
        }
        int colOffset = (imageCols - this.qrc.Csize * xDimension) / 2;
        int rowOffset = (imageRows - this.qrc.Csize * xDimension) / 2;
        if (colOffset < 4 * xDimension || rowOffset < 4 * xDimension) {
            throw new QRCodeEncoderException(QRCodeEncoderErrorCode.IMAGE_TOO_SMALL);
        }
        BufferedImage image = new BufferedImage(imageCols, imageRows, 10);
        Graphics2D graphicsBarcodeImage = image.createGraphics();
        graphicsBarcodeImage.setColor(Color.WHITE);
        graphicsBarcodeImage.fillRect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        graphicsBarcodeImage.clipRect(0, 0, imageCols - colOffset, imageRows - rowOffset);
        Color color = Color.BLACK;
        int i = 0;
        int row = rowOffset;
        while (i < this.qrc.Csize) {
            int j = 0;
            int col = colOffset;
            while (j < this.qrc.Csize) {
                color = this.qrc.mtstcell(j, i) != 0 ? Color.BLACK : Color.WHITE;
                graphicsBarcodeImage.setColor(color);
                graphicsBarcodeImage.fillRect(col, row, col + xDimension, row + xDimension);
                ++j;
                col += xDimension;
            }
            ++i;
            row += xDimension;
        }
        return image;
    }

    public void setQrc(QRC qrc) {
        this.qrc = qrc;
    }
}

