/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.qrcodepmp;

import com.adobe.xfa.pmp.common.BarcodeEncoder;
import com.adobe.xfa.pmp.common.BarcodeGenerationParams;
import com.adobe.xfa.pmp.qrcodepmp.QRCodeEncoderErrorCode;
import com.adobe.xfa.pmp.qrcodepmp.QRCodeEncoderException;
import com.adobe.xfa.pmp.qrcodepmp.QRCodeImageBuilder;
import com.adobe.xfa.pmp.qrcodepmp.denso.QRC;
import java.awt.image.BufferedImage;

public class QRCodeEncoder
implements BarcodeEncoder {
    @Override
    public BufferedImage encode(char[] message, BarcodeGenerationParams pmpParams) throws QRCodeEncoderException {
        double resolution = pmpParams.getResolution();
        if (resolution < 1.0) {
            throw new QRCodeEncoderException(QRCodeEncoderErrorCode.RESOLUTION);
        }
        int ecc = Level.LevelM.level;
        ecc = pmpParams.getEccLevel();
        if (ecc != Level.LevelH.level && ecc != Level.LevelQ.level && ecc != Level.LevelM.level && ecc != Level.LevelL.level) {
            throw new QRCodeEncoderException(QRCodeEncoderErrorCode.ECC);
        }
        int width = (int)(pmpParams.getWidth() * resolution + 0.5);
        int height = (int)(pmpParams.getHeight() * resolution + 0.5);
        int xSymWidth = pmpParams.getXSymbolWidth();
        if (xSymWidth < 1) {
            throw new QRCodeEncoderException(QRCodeEncoderErrorCode.XSYMWIDTH);
        }
        QRC qrc = new QRC();
        qrc.modelNo = 1;
        qrc.Clvl = ecc;
        qrc.cdata = message;
        qrc.auto_conv(qrc.qdata, message, qrc.cdata, message.length);
        if (qrc.qrcode(qrc.qdata, 0) == 0) {
            throw new QRCodeEncoderException(QRCodeEncoderErrorCode.MESSAGE_TOO_BIG);
        }
        QRCodeImageBuilder imageBuilder = new QRCodeImageBuilder();
        imageBuilder.setQrc(qrc);
        BufferedImage image = imageBuilder.buildImage(width, height, xSymWidth);
        return image;
    }

    static enum Level {
        LevelH(3),
        LevelQ(2),
        LevelM(1),
        LevelL(0);

        int level;

        private Level(int level) {
            this.level = level;
        }
    }
}

