/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Model;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.RectangleValue;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.GfxTextAttrs;
import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXMappingList;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.layout.LayoutHandler;
import com.adobe.xfa.template.formatting.Color;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

public class LayoutDriver
extends GFXDriver {
    protected Rect moRect = Rect.ZERO;
    private LayoutEnv moEnv;
    private int mnMappingLevel;

    public LayoutDriver() {
        super(null);
        this.moEnv = null;
        this.mnMappingLevel = 0;
        this.initDeviceUnitsPerInch(1200, 1200);
    }

    public LayoutDriver(LayoutEnv oEnv) {
        super(oEnv);
        this.moEnv = oEnv;
        this.mnMappingLevel = 0;
        this.initDeviceUnitsPerInch(1200, 1200);
    }

    public void setLayoutEnv(LayoutEnv oEnv) {
        this.moEnv = oEnv;
    }

    @Override
    public void absLine(CoordPair oEnd, int eDrawMode) {
        LayoutHandler oLayoutHandler = this.layoutHandler();
        if (oLayoutHandler == null) {
            return;
        }
        Model model = oLayoutHandler.getModel();
        Element oLine = model.createElement(XFA.LINETAG, "line");
        switch (this.lineAttr().hand()) {
            case 0: {
                oLine.setAttribute(0x170000, XFA.HANDTAG);
                break;
            }
            case 1: {
                oLine.setAttribute(0x170001, XFA.HANDTAG);
                break;
            }
            default: {
                oLine.setAttribute(1507330, XFA.HANDTAG);
            }
        }
        Element oEdge = oLine.getElement(XFA.EDGETAG, 0);
        switch (this.lineAttr().cap()) {
            case 0: {
                oEdge.setAttribute(327680, XFA.CAPTAG);
                break;
            }
            case 1: {
                oEdge.setAttribute(327681, XFA.CAPTAG);
                break;
            }
            default: {
                oEdge.setAttribute(327682, XFA.CAPTAG);
            }
        }
        Color oColor = (Color)oEdge.getElement(XFA.COLORTAG, 0);
        oColor.setRed(this.lineAttr().colour().r());
        oColor.setGreen(this.lineAttr().colour().g());
        oColor.setBlue(this.lineAttr().colour().b());
        oEdge.setAttribute(new Measurement(this.lineAttr().width()), XFA.THICKNESSTAG);
        switch (this.lineAttr().style()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                oEdge.setAttribute(0x330000, XFA.STROKETAG);
                break;
            }
            case 9: {
                oEdge.setAttribute(0x330002, XFA.STROKETAG);
                break;
            }
            case 10: {
                oEdge.setAttribute(0x330001, XFA.STROKETAG);
                break;
            }
            case 11: {
                oEdge.setAttribute(0x330007, XFA.STROKETAG);
                break;
            }
            case 12: {
                oEdge.setAttribute(0x330008, XFA.STROKETAG);
            }
        }
        CoordPair oP1 = this.rotatePoint(this.getAbsPosition());
        CoordPair oP2 = this.rotatePoint(oEnd);
        oLayoutHandler.drawLine(new Measurement(oP1.x()), new Measurement(oP1.y()), new Measurement(oP2.x().subtract(oP1.x())), new Measurement(oP2.y().subtract(oP1.y())), oLine);
        this.setAbsPosition(oEnd);
    }

    @Override
    public void absFillRect(Rect oRect, int eDrawMode) {
        LayoutHandler oLayoutHandler = this.layoutHandler();
        if (oLayoutHandler == null) {
            return;
        }
        Model model = oLayoutHandler.getModel();
        RectangleValue oRectangle = (RectangleValue)model.createElement(XFA.RECTANGLETAG, "rectangle");
        oRectangle.setAttribute(0x170001, XFA.HANDTAG);
        Element oFill = oRectangle.getElement(XFA.FILLTAG, 0);
        Color oColor = (Color)model.createElement(XFA.COLORTAG, "color");
        oColor.setRed(this.fillAttr().colour().r());
        oColor.setGreen(this.fillAttr().colour().g());
        oColor.setBlue(this.fillAttr().colour().b());
        oFill.setElement(oColor, XFA.COLORTAG, 0);
        Element oPattern = null;
        switch (this.fillAttr().style()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                Element oSolid = model.createElement(XFA.SOLIDTAG, "solid");
                oFill.setOneOfChild(oSolid);
                break;
            }
            case 3: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796672, XFA.TYPETAG);
                break;
            }
            case 4: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796671, XFA.TYPETAG);
                break;
            }
            case 5: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796670, XFA.TYPETAG);
                break;
            }
            case 6: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796669, XFA.TYPETAG);
                break;
            }
            case 7: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796668, XFA.TYPETAG);
                break;
            }
            case 8: {
                oPattern = oFill.getElement(XFA.PATTERNTAG, 0);
                oPattern.setAttribute(-2144796667, XFA.TYPETAG);
            }
        }
        Element oEdge = oRectangle.getElement(XFA.EDGETAG, 0);
        oEdge.setAttribute(new Measurement(UnitSpan.ZERO), XFA.THICKNESSTAG);
        oLayoutHandler.drawRect(new Measurement(oRect.left()), new Measurement(oRect.top()), new Measurement(oRect.width()), new Measurement(oRect.height()), oRectangle);
    }

    @Override
    public void absText(String oText, int eDrawMode) {
        LayoutHandler oLayoutHandler = this.layoutHandler();
        if (oLayoutHandler == null) {
            return;
        }
        oLayoutHandler.setClipRect(this.moRect);
        FontInstance oFontInstance = this.fontInstance();
        assert (oFontInstance != null);
        GfxTextAttrs oAttrs = new GfxTextAttrs(this.textAttr().colour(), this.textAttr().underline(), this.textAttr().overline(), this.textAttr().strikeout(), UnitSpan.ZERO, 0);
        String sNonConst = oText;
        oLayoutHandler.handleTextRun(new Measurement(this.getAbsPosition().x()), new Measurement(this.getAbsPosition().y()), new Measurement(new UnitSpan(0, 19)), new Measurement(new UnitSpan(0, 19)), sNonConst, oFontInstance, oAttrs);
        this.moRect = Rect.ZERO;
        oLayoutHandler.setClipRect(this.moRect);
    }

    @Override
    public void absGlyphs(int[] nGlyphs, int nSize) {
        LayoutHandler oLayoutHandler = this.layoutHandler();
        if (oLayoutHandler == null) {
            return;
        }
        oLayoutHandler.setClipRect(this.moRect);
        FontInstance oFontInstance = this.fontInstance();
        assert (oFontInstance != null);
        GfxTextAttrs oAttrs = new GfxTextAttrs(this.textAttr().colour(), this.textAttr().underline(), this.textAttr().overline(), this.textAttr().strikeout(), UnitSpan.ZERO, this.glyphOrientation());
        oLayoutHandler.handleGlyphRun(new Measurement(this.getAbsPosition().x()), new Measurement(this.getAbsPosition().y()), new Measurement(new UnitSpan(0, 19)), new Measurement(new UnitSpan(0, 19)), nGlyphs, nSize, oFontInstance, oAttrs);
        this.moRect = Rect.ZERO;
        oLayoutHandler.setClipRect(this.moRect);
    }

    public void setUnicodeChars(String text, int nSize) {
        LayoutHandler poLayoutHandler = this.layoutHandler();
        if (poLayoutHandler == null) {
            return;
        }
        poLayoutHandler.handleUnicodeChars(text, nSize);
    }

    @Override
    public void mapGlyphs(GFXMappingList mappingList, boolean bIsRTL) {
        LayoutHandler poLayoutHandler = this.layoutHandler();
        if (poLayoutHandler == null) {
            return;
        }
        poLayoutHandler.handleGlyphMapping(mappingList, bIsRTL);
    }

    @Override
    public int getMappingLevel() {
        return this.mnMappingLevel;
    }

    public void setMappingLevel(int nSLevel) {
        this.mnMappingLevel = nSLevel;
    }

    @Override
    public int height() {
        return this.moRect.height().valueAsUnit(3);
    }

    @Override
    public int width() {
        return this.moRect.width().valueAsUnit(3);
    }

    @Override
    public boolean interactive() {
        return false;
    }

    @Override
    public void setClipRect(Rect oRect) {
        this.moRect = oRect;
    }

    @Override
    public void paraHint() {
        LayoutHandler oLayoutHandler = this.layoutHandler();
        if (oLayoutHandler != null) {
            oLayoutHandler.newPara();
        }
    }

    protected LayoutHandler layoutHandler() {
        if (this.moEnv != null) {
            return this.moEnv.layoutHandler();
        }
        return null;
    }

    protected LayoutEnv layoutEnv() {
        return this.moEnv;
    }
}

